/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.dimensions;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Stream;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.dimensions.RandomDimension;
import net.lerariemann.infinity.util.core.CommonIO;
import net.lerariemann.infinity.util.core.NbtUtils;
import net.lerariemann.infinity.util.core.RandomProvider;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public class RandomNoisePreset {
    private final RandomProvider PROVIDER;
    public String name;
    public String fullname;
    public RandomDimension parent;
    public String noise_router;
    public String surface_rule;
    public String spawn_target;
    public String type_alike;
    Map<String, Set<String>> biomeRegistry;

    RandomNoisePreset(RandomDimension dim) {
        this.parent = dim;
        this.biomeRegistry = new HashMap<String, Set<String>>();
        this.PROVIDER = dim.PROVIDER;
        this.name = "generated_" + dim.numericId;
        this.fullname = "infinity:" + this.name;
        class_2487 data = new class_2487();
        this.type_alike = dim.type_alike;
        String typeshort = this.type_alike.substring(this.type_alike.lastIndexOf(":") + 1);
        if (dim.isOverworldLike()) {
            this.noise_router = typeshort;
            this.spawn_target = "overworld";
            this.surface_rule = "overworld";
            data.method_10556("aquifers_enabled", true);
        } else {
            this.noise_router = this.surface_rule = typeshort;
            data.method_10556("aquifers_enabled", false);
            this.spawn_target = "default";
            switch (this.type_alike) {
                case "minecraft:nether": 
                case "minecraft:caves": {
                    this.noise_router = "caves";
                }
            }
        }
        data.method_10556("ore_veins_enabled", dim.random.nextBoolean());
        data.method_10556("disable_mob_generation", false);
        data.method_10556("legacy_random_source", false);
        data.method_10566("default_block", (class_2520)this.parent.default_block);
        data.method_10566("default_fluid", (class_2520)NbtUtils.nameToElement(this.parent.default_fluid.method_10558("Name")));
        data.method_10569("sea_level", this.parent.sea_level);
        data.method_10566("noise", (class_2520)this.noise(dim));
        data.method_10566("noise_router", (class_2520)this.getRouter(this.noise_router));
        data.method_10566("spawn_target", CommonIO.read(String.valueOf(InfinityMod.utilPath) + "/spawn_target/" + this.spawn_target + ".json").method_10580("spawn_target"));
        data.method_10566("surface_rule", (class_2520)this.buildSurfaceRule());
        CommonIO.write(data, dim.getStoragePath() + "/worldgen/noise_settings", this.name + ".json");
    }

    class_2487 noise(RandomDimension dim) {
        int s;
        class_2487 noise = new class_2487();
        noise.method_10569("height", dim.height);
        noise.method_10569("min_y", dim.min_y);
        boolean rifts = this.PROVIDER.roll(dim.random, "rift_world_chance");
        if (rifts) {
            noise.method_10569("size_horizontal", 3);
        } else {
            s = dim.random.nextInt(1, 4);
            noise.method_10569("size_horizontal", s == 3 ? 4 : s);
        }
        s = dim.random.nextInt(1, 4);
        noise.method_10569("size_vertical", s == 3 ? 4 : s);
        return noise;
    }

    class_2487 getRouter(String router) {
        String path = String.valueOf(InfinityMod.utilPath) + "/noise_router/" + router + ".json";
        int min = this.parent.min_y;
        int max = this.parent.height + this.parent.min_y;
        int softmax = Math.min(max, 256);
        Random r = this.parent.random;
        switch (router) {
            case "caves": {
                return CommonIO.readAndFormat(path, min - 8, min + 24, max - 24, max);
            }
            case "floating_islands": {
                return CommonIO.readAndFormat(path, min + 4, min + 32, max - 72, max + 184);
            }
            case "end": {
                return CommonIO.readAndFormat(path, min + 4, min + 32, max - 72, max + 184, min + 4, min + 32, max - 72, max + 184);
            }
            case "overworld": 
            case "large_biomes": {
                return CommonIO.readAndFormat(path, min, min + 24, softmax - 16, softmax, min, max, Float.valueOf(max + 1), Float.valueOf(min + 4), Float.valueOf(max + 1), Float.valueOf(min + 4), Float.valueOf(max + 1), Float.valueOf(min + 4), Float.valueOf(max + 1), Float.valueOf(min + 4), min, min + 24, softmax - 16, softmax);
            }
            case "amplified": {
                return CommonIO.readAndFormat(path, min, min + 24, max - 16, max, min, max, Float.valueOf(max + 1), Float.valueOf(min + 4), Float.valueOf(max + 1), Float.valueOf(min + 4), Float.valueOf(max + 1), Float.valueOf(min + 4), Float.valueOf(max + 1), Float.valueOf(min + 4), min, min + 24, max - 16, max);
            }
            case "whack": {
                double f = r.nextExponential();
                double a = r.nextDouble(1.0, 8.0);
                double b = r.nextDouble(1.0, 8.0);
                return CommonIO.readAndFormat(path, 2.0 * f, min, min + 8, max - 8, -2.0 * f, max, min, this.parent.sea_level, this.parent.sea_level, max, f, a, b, min, max, 2.0 * f, min, min + 8, max - 8, -2.0 * f, max, min, this.parent.sea_level, this.parent.sea_level, max, f, a, b);
            }
            case "tangled": {
                double f = r.nextDouble(0.005, 0.1);
                double a = r.nextExponential();
                double b = r.nextExponential();
                return CommonIO.readAndFormat(path, min + 32, min, min, max, a, b, a, b, f, min + 16, min, max - 16, max);
            }
        }
        return CommonIO.read(path);
    }

    class_2487 buildSurfaceRule() {
        this.parent.deepslate = this.parent.randomiseblocks ? this.PROVIDER.randomElement(this.parent.random, "full_blocks_worldgen") : NbtUtils.nameToElement("minecraft:deepslate");
        int i = 0;
        switch (this.surface_rule) {
            case "caves": 
            case "nether": 
            case "tangled": {
                i = 1;
                break;
            }
            case "floating_islands": 
            case "end": {
                i = 2;
            }
        }
        class_2487 res = RandomNoisePreset.startingRule("sequence");
        class_2499 sequence = new class_2499();
        if (i != 2) {
            sequence.add((Object)CommonIO.read(String.valueOf(InfinityMod.utilPath) + "/surface_rule/bedrock_floor.json"));
        }
        if (i == 1) {
            sequence.add((Object)CommonIO.read(String.valueOf(InfinityMod.utilPath) + "/surface_rule/bedrock_roof.json"));
        }
        sequence.add((Object)this.getBiomes(i == 0));
        if (i == 0) {
            this.addDeepslate(sequence);
        }
        res.method_10566("sequence", (class_2520)sequence);
        return res;
    }

    void addDeepslate(class_2499 base) {
        base.add((Object)CommonIO.readAndAddCompound(String.valueOf(InfinityMod.utilPath) + "/surface_rule/deepslate.json", this.parent.deepslate));
        this.parent.additional_blocks.add(this.parent.deepslate);
    }

    public static class_2487 startingRule(String str) {
        class_2487 res = new class_2487();
        res.method_10582("type", "minecraft:" + str);
        return res;
    }

    class_2487 getBiomes(boolean usePreliminarySurface) {
        if (usePreliminarySurface) {
            class_2487 res = RandomNoisePreset.startingRule("condition");
            res.method_10566("if_true", (class_2520)RandomNoisePreset.startingRule("above_preliminary_surface"));
            res.method_10566("then_run", (class_2520)this.getBiomes(false));
            return res;
        }
        class_2487 res = RandomNoisePreset.startingRule("sequence");
        class_2499 sequence = this.biomeSequence();
        res.method_10566("sequence", (class_2520)sequence);
        return res;
    }

    class_2487 randomBlock(String s) {
        return this.PROVIDER.randomElement(this.parent.random, s);
    }

    class_2499 biomeSequence() {
        class_2499 sequence = new class_2499();
        try (Stream<Path> files = Files.walk(InfinityMod.configPath.resolve("modular"), new FileVisitOption[0]);){
            files.forEach(p -> {
                if (p.toString().contains("surface_rule") && p.toFile().isFile()) {
                    class_2487 compound = CommonIO.readSurfaceRule(p.toFile(), this.parent.sea_level);
                    class_2499 biomes = compound.method_10554("biomes", 8);
                    class_2499 biomestoadd = new class_2499();
                    for (class_2520 b : biomes) {
                        if (!this.parent.vanilla_biomes.contains(b.method_10714())) continue;
                        biomestoadd.add((Object)b);
                    }
                    if (!biomestoadd.isEmpty()) {
                        class_2487 rule = compound.method_10562("rule");
                        sequence.add((Object)this.ruleWrap(biomestoadd, rule));
                    }
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (long id : this.parent.random_biome_ids) {
            boolean useRandomBlock;
            String biome = "infinity:biome_" + id;
            String root = String.valueOf(InfinityMod.utilPath) + "/surface_rule/custom/";
            boolean bl = useRandomBlock = this.parent.randomiseblocks && this.PROVIDER.roll(this.parent.random, "randomise_biome_blocks");
            class_2487 top_block = useRandomBlock ? this.randomBlock(RandomProvider.rule("forceSolidSurface") ? "full_blocks_worldgen" : "top_blocks") : NbtUtils.nameToElement(this.parent.getDefaultBlock("minecraft:grass_block"));
            this.parent.top_blocks.put(biome, top_block);
            class_2487 block_underwater = useRandomBlock ? this.randomBlock("full_blocks_worldgen") : NbtUtils.nameToElement(this.parent.getDefaultBlock("minecraft:dirt"));
            this.parent.underwater.put(biome, block_underwater);
            class_2487 beach = useRandomBlock ? this.randomBlock("full_blocks_worldgen") : top_block;
            class_2487 rule1 = CommonIO.readAndFormat(root + "ceiling.json", CommonIO.compoundToString(this.parent.deepslate, 5), CommonIO.compoundToString(this.parent.default_block, 4));
            class_2487 rule2 = CommonIO.readAndFormat(root + "grass.json", this.parent.sea_level - 1, this.parent.sea_level, CommonIO.compoundToString(beach, 10), CommonIO.compoundToString(top_block, 8), CommonIO.compoundToString(block_underwater, 5));
            class_2487 rule3 = CommonIO.readAndFormat(root + "dirt.json", CommonIO.compoundToString(block_underwater, 7));
            class_2487 rule4 = CommonIO.readAndFormat(root + "final.json", CommonIO.compoundToString(this.parent.deepslate, 5), CommonIO.compoundToString(this.parent.default_block, 4));
            class_2487 rule = RandomNoisePreset.startingRule("sequence");
            class_2499 sq = new class_2499();
            sq.add((Object)rule1);
            sq.add((Object)rule2);
            sq.add((Object)rule3);
            sq.add((Object)rule4);
            rule.method_10566("sequence", (class_2520)sq);
            class_2499 biomestoadd = new class_2499();
            biomestoadd.add((Object)class_2519.method_23256((String)biome));
            sequence.add((Object)this.ruleWrap(biomestoadd, rule));
        }
        sequence.add((Object)CommonIO.readAndFormat(String.valueOf(InfinityMod.utilPath) + "/surface_rule/default.json", this.defaultBlock("minecraft:grass_block"), this.defaultBlock("minecraft:dirt"), this.defaultBlock("minecraft:dirt"), this.defaultBlock("minecraft:stone"), this.defaultBlock("minecraft:gravel")).method_10562("rule"));
        return sequence;
    }

    String defaultBlock(String def) {
        return switch (this.type_alike) {
            case "minecraft:nether" -> "minecraft:netherrack";
            case "minecraft:end" -> "minecraft:end_stone";
            default -> def;
        };
    }

    class_2487 ruleWrap(class_2499 biomes, class_2487 rule) {
        class_2487 res = RandomNoisePreset.startingRule("condition");
        class_2487 if_true = RandomNoisePreset.startingRule("biome");
        if_true.method_10566("biome_is", (class_2520)biomes);
        res.method_10566("if_true", (class_2520)if_true);
        res.method_10566("then_run", (class_2520)rule);
        return res;
    }
}

