/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.dimensions;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.dimensions.RandomBiome;
import net.lerariemann.infinity.dimensions.RandomDimension;
import net.lerariemann.infinity.dimensions.RandomStructure;
import net.lerariemann.infinity.util.config.ConfigManager;
import net.lerariemann.infinity.util.core.NbtUtils;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.apache.commons.io.FileUtils;

public class RandomText
extends RandomStructure {
    public static List<Path> mod_resources;

    public static void walkPaths() {
        mod_resources = new ArrayList<Path>();
        try (Stream<Path> files = Files.walk(InfinityMod.rootConfigPathInJar, new FileVisitOption[0]);){
            files.filter(p -> p.toString().endsWith(".json")).forEach(p -> mod_resources.add((Path)p));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    RandomText(int i, RandomBiome b) {
        super(i, b);
    }

    @Override
    void addData() {
        RandomDimension daddy = this.parent.parent;
        this.type = "infinity:text";
        this.name = "text_" + this.id;
        this.data = new class_2487();
        this.data.method_10582("type", "infinity:text");
        this.data.method_10582("step", "surface_structures");
        this.data.method_10566("spawn_overrides", (class_2520)new class_2487());
        this.data.method_10582("biomes", this.parent.fullname);
        this.data.method_10566("block", (class_2520)daddy.PROVIDER.randomBlockProvider(this.random, "full_blocks_worldgen"));
        this.data.method_10566("y", (class_2520)NbtUtils.randomHeightProvider(this.random, daddy.sea_level, daddy.min_y + daddy.height, true, true));
        this.data.method_10582("text", RandomText.genText(this.random));
    }

    public static String genText(Random random) {
        try {
            return RandomText.genTextFromModResources(random);
        }
        catch (Exception e) {
            return RandomText.genTextRandomly(random);
        }
    }

    static String genTextFromModResources(Random random) throws IOException {
        Path tempfile = ConfigManager.tempFile;
        Path p = mod_resources.get(random.nextInt(mod_resources.size()));
        Files.copy(p, tempfile, StandardCopyOption.REPLACE_EXISTING);
        return RandomText.genTextFromFile(random, tempfile.toFile());
    }

    static String genTextFromFile(Random random, File f) throws IOException {
        try {
            return RandomText.select(random, FileUtils.readFileToString((File)f, (Charset)StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new IOException();
        }
    }

    static String select(Random random, String str) {
        int i2;
        String[] lst = str.split("\n");
        if (lst.length <= (i2 = random.nextInt(1, 16))) {
            return str;
        }
        int i = random.nextInt(0, lst.length - i2);
        StringBuilder res = new StringBuilder();
        res.append(lst[i]);
        for (int j = 1; j < i2; ++j) {
            res.append("$n").append(lst[i + j]);
        }
        return res.toString();
    }

    public static String genTextRandomly(Random random) {
        return RandomText.genTextRandomly(random, 64);
    }

    public static String genTextRandomly(Random random, int bound) {
        String s = "1234567890QWERTYUIOPASDFGHJKLZXCVBNMqwertyuiopasdfghjklzxcvbnm";
        StringBuilder res = new StringBuilder();
        for (int j = 0; j < bound; ++j) {
            res.append(s.charAt(random.nextInt(s.length())));
        }
        return res.toString();
    }
}

