/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.dimensions.features;

import java.util.Arrays;
import net.lerariemann.infinity.dimensions.RandomFeaturesList;
import net.lerariemann.infinity.dimensions.features.RandomisedFeature;
import net.lerariemann.infinity.util.core.NbtUtils;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public class RandomTree
extends RandomisedFeature {
    boolean ishuge;

    public RandomTree(RandomFeaturesList parent) {
        super(parent, "tree");
        this.ishuge = parent.roll("huge_trees");
        this.id = "tree";
        this.save_with_placement();
    }

    @Override
    void placement() {
        class_2487 predicate = RandomTree.matchingBlocks(this.parent.surface_block.method_10558("Name"));
        predicate.method_10566("offset", (class_2520)RandomTree.offsetToNbt(Arrays.asList(0, -1, 0)));
        this.addCountEveryLayer(1);
        this.addWaterDepthFilter((int)Math.floor(this.random.nextExponential() * 4.0));
        this.addBlockPredicateFilter(predicate);
    }

    @Override
    class_2487 feature() {
        class_2487 config = new class_2487();
        this.addRandomBlockProvider(config, "dirt_provider", "full_blocks");
        this.addRandomBlockProvider(config, "trunk_provider", "full_blocks_worldgen");
        this.addRandomBlockProvider(config, "foliage_provider", "full_blocks_worldgen");
        config.method_10556("force_dirt", this.random.nextBoolean());
        config.method_10556("ignore_vines", this.random.nextBoolean());
        config.method_10566("trunk_placer", (class_2520)this.trunkPlacer());
        config.method_10566("foliage_placer", (class_2520)this.foliagePlacer());
        config.method_10566("minimum_size", (class_2520)this.minimum_size());
        config.method_10566("decorators", (class_2520)this.decorators());
        if (this.random.nextBoolean()) {
            config.method_10566("root_placer", (class_2520)this.rootPlacer());
        }
        return this.feature(config);
    }

    class_2487 rootPlacer() {
        class_2487 res = new class_2487();
        res.method_10582("type", "mangrove_root_placer");
        this.addRandomBlockProvider(res, "root_provider", "full_blocks");
        res.method_10566("trunk_offset_y", NbtUtils.randomIntProvider(this.random, 9, true));
        if (this.random.nextBoolean()) {
            class_2487 above = new class_2487();
            this.addRandomBlockProvider(above, "above_root_provider", "blocks_features");
            above.method_10548("above_root_placement_chance", this.random.nextFloat());
            res.method_10566("above_root_placement", (class_2520)above);
        }
        class_2487 mangrove = new class_2487();
        mangrove.method_10569("max_root_width", 1 + this.random.nextInt(this.ishuge ? 12 : 4));
        mangrove.method_10569("max_root_length", 1 + this.random.nextInt(this.ishuge ? 64 : 8));
        mangrove.method_10548("random_skew_chance", this.random.nextFloat());
        mangrove.method_10582("can_grow_through", "#" + this.PROVIDER.randomName(this.random, "tags"));
        mangrove.method_10582("muddy_roots_in", "#" + this.PROVIDER.randomName(this.random, "tags"));
        this.addRandomBlockProvider(mangrove, "muddy_roots_provider", "full_blocks");
        res.method_10566("mangrove_root_placement", (class_2520)mangrove);
        return res;
    }

    class_2487 trunkPlacer() {
        class_2487 res = new class_2487();
        res.method_10569("base_height", this.random.nextInt(this.ishuge ? 32 : 8));
        res.method_10569("height_rand_a", this.random.nextInt(this.ishuge ? 24 : 4));
        res.method_10569("height_rand_b", this.random.nextInt(this.ishuge ? 24 : 4));
        String type = this.PROVIDER.randomName(this.random, "trunk_placers");
        res.method_10582("type", type);
        switch (type) {
            case "bending_trunk_placer": {
                this.addRandomIntProvider(res, "bend_length", 1, this.ishuge ? 63 : 8);
                res.method_10569("min_height_for_leaves", 1 + (int)Math.floor(this.random.nextExponential()));
                break;
            }
            case "upwards_branching_trunk_placer": {
                res.method_10569("extra_branch_steps", 1 + (int)Math.floor(this.random.nextExponential()));
                res.method_10569("extra_branch_length", (int)Math.floor(this.random.nextExponential() * 3.0));
                res.method_10548("place_branch_per_log_probability", this.random.nextFloat());
                res.method_10582("can_grow_through", "#" + this.PROVIDER.randomName(this.random, "tags"));
                break;
            }
            case "cherry_trunk_placer": {
                this.addRandomIntProvider(res, "branch_count", 1, 2);
                this.addRandomIntProvider(res, "branch_horizontal_length", 2, 15);
                class_2487 branch_start_offset_from_top = new class_2487();
                int a = this.random.nextInt(-16, 0);
                int b = this.random.nextInt(-16, 0);
                if (a == b) {
                    a = a == 0 ? --a : ++a;
                }
                branch_start_offset_from_top.method_10569("min_inclusive", Math.min(a, b));
                branch_start_offset_from_top.method_10569("max_inclusive", Math.max(a, b));
                res.method_10566("branch_start_offset_from_top", (class_2520)branch_start_offset_from_top);
                this.addRandomIntProvider(res, "branch_end_offset_from_top", -16, 15);
            }
        }
        return res;
    }

    class_2487 foliagePlacer() {
        class_2487 res = new class_2487();
        this.addRandomIntProvider(res, "radius", 1, this.ishuge ? 15 : 5);
        this.addRandomIntProvider(res, "offset", 1, this.ishuge ? 10 : 3);
        String type = this.PROVIDER.randomName(this.random, "foliage_placers");
        res.method_10582("type", type);
        switch (type) {
            case "blob_foliage_placer": 
            case "bush_foliage_placer": 
            case "fancy_foliage_placer": 
            case "jungle_foliage_placer": {
                res.method_10569("height", this.random.nextInt(16));
                break;
            }
            case "pine_foliage_placer": {
                res.method_10566("height", NbtUtils.randomIntProvider(this.random, this.ishuge ? 24 : 6, true));
                break;
            }
            case "spruce_foliage_placer": {
                res.method_10566("trunk_height", NbtUtils.randomIntProvider(this.random, this.ishuge ? 24 : 6, true));
                break;
            }
            case "mega_pine_foliage_placer": {
                res.method_10566("crown_height", NbtUtils.randomIntProvider(this.random, this.ishuge ? 24 : 6, true));
                break;
            }
            case "random_spread_foliage_placer": {
                this.addRandomIntProvider(res, "foliage_height", 1, this.ishuge ? 512 : 15);
                res.method_10569("leaf_placement_attempts", this.random.nextInt(256));
                break;
            }
            case "cherry_foliage_placer": {
                res.method_10566("height", NbtUtils.randomIntProvider(this.random, 4, 15, true));
                res.method_10548("wide_bottom_layer_hole_chance", this.random.nextFloat());
                res.method_10548("corner_hole_chance", this.random.nextFloat());
                res.method_10548("hanging_leaves_chance", this.random.nextFloat());
                res.method_10548("hanging_leaves_extension_chance", this.random.nextFloat());
            }
        }
        return res;
    }

    class_2487 minimum_size() {
        boolean i;
        class_2487 res = new class_2487();
        if (this.random.nextBoolean()) {
            res.method_10548("min_clipped_height", Math.min(80.0f, (float)this.random.nextExponential() * 3.0f));
        }
        if (i = this.random.nextBoolean()) {
            res.method_10582("type", "two_layers_feature_size");
        } else {
            res.method_10582("type", "three_layers_feature_size");
            if (this.random.nextBoolean()) {
                res.method_10569("upper_limit", this.random.nextInt(80));
            }
            if (this.random.nextBoolean()) {
                res.method_10569("middle_size", Math.min(16, (int)Math.floor(this.random.nextExponential() * 2.0)));
            }
        }
        if (this.random.nextBoolean()) {
            res.method_10569("limit", this.random.nextInt(80));
        }
        if (this.random.nextBoolean()) {
            res.method_10569("lower_size", Math.min(16, (int)Math.floor(this.random.nextExponential() * 2.0)));
        }
        if (this.random.nextBoolean()) {
            res.method_10569("upper_size", Math.min(16, (int)Math.floor(this.random.nextExponential() * 2.0)));
        }
        return res;
    }

    class_2499 decorators() {
        class_2499 res = new class_2499();
        int num = (int)Math.floor(this.random.nextExponential());
        for (int i = 0; i < num; ++i) {
            class_2487 dec = new class_2487();
            String type = this.PROVIDER.randomName(this.random, "tree_decorators");
            dec.method_10582("type", type);
            switch (type) {
                case "leave_vine": 
                case "cocoa": 
                case "beehive": {
                    dec.method_10548("probability", this.random.nextFloat());
                    break;
                }
                case "alter_ground": {
                    this.addRandomBlockProvider(dec, "provider", "blocks_features");
                    break;
                }
                case "attached_to_leaves": {
                    dec.method_10548("probability", this.random.nextFloat());
                    dec.method_10569("exclusion_radius_xz", Math.min((int)Math.floor(this.random.nextExponential() * 2.0), 16));
                    dec.method_10569("exclusion_radius_y", Math.min((int)Math.floor(this.random.nextExponential() * 2.0), 16));
                    dec.method_10569("required_empty_blocks", 1 + Math.min((int)Math.floor(this.random.nextExponential() * 2.0), 15));
                    this.addRandomBlockProvider(dec, "block_provider", "blocks_features");
                    class_2499 directions = new class_2499();
                    String[] dirs = new String[]{"up", "down", "north", "south", "west", "east"};
                    int j = 0;
                    for (String k : dirs) {
                        if (!this.random.nextBoolean()) continue;
                        ++j;
                        directions.add((Object)class_2519.method_23256((String)k));
                    }
                    if (j == 0) {
                        directions.add((Object)class_2519.method_23256((String)dirs[this.random.nextInt(6)]));
                    }
                    dec.method_10566("directions", (class_2520)directions);
                }
            }
            res.add((Object)dec);
        }
        return res;
    }
}

