/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.dimensions.features;

import java.util.List;
import java.util.Random;
import net.lerariemann.infinity.dimensions.RandomDimension;
import net.lerariemann.infinity.dimensions.RandomFeaturesList;
import net.lerariemann.infinity.util.InfinityMethods;
import net.lerariemann.infinity.util.core.CommonIO;
import net.lerariemann.infinity.util.core.NbtUtils;
import net.lerariemann.infinity.util.core.RandomProvider;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_7924;

public abstract class RandomisedFeature {
    protected final RandomProvider PROVIDER;
    String id;
    String name;
    Random random;
    RandomFeaturesList parent;
    RandomDimension daddy;
    class_2499 placement_data;

    public RandomisedFeature(RandomFeaturesList lst, String namecore) {
        this(InfinityMethods.getRandomSeed(lst.random), lst, namecore);
    }

    public RandomisedFeature(long i, RandomFeaturesList lst, String namecore) {
        this.random = new Random(i);
        this.id = namecore;
        this.name = namecore + "_" + i;
        this.parent = lst;
        this.daddy = this.parent.parent.parent;
        this.PROVIDER = this.parent.PROVIDER;
        this.placement_data = new class_2499();
    }

    public String fullName() {
        return "infinity:" + this.name;
    }

    public String fullNameConfigured() {
        return "infinity:configured_" + this.name;
    }

    void save_with_placement() {
        if (this.daddy.doesNotContain(class_7924.field_41239, this.name)) {
            CommonIO.write(this.feature(), this.parent.storagePath + "/worldgen/configured_feature", "configured_" + this.name + ".json");
        }
        class_2487 moredata = new class_2487();
        moredata.method_10582("feature", this.fullNameConfigured());
        this.placement();
        moredata.method_10566("placement", (class_2520)this.placement_data);
        CommonIO.write(moredata, this.parent.storagePath + "/worldgen/placed_feature", this.name + ".json");
    }

    class_2487 genBlockOrFluid() {
        class_2487 block2 = this.parent.roll("solid_lakes") ? this.PROVIDER.randomElement(this.random, "blocks_features") : NbtUtils.nameToElement(this.PROVIDER.randomName(this.random, "fluids"));
        return block2;
    }

    void addRandomBlockProvider(class_2487 config, String key, String group) {
        class_2487 block = this.PROVIDER.randomElement(this.random, group);
        config.method_10566(key, (class_2520)this.PROVIDER.blockToProvider(block, this.random));
    }

    void addRandomBlock(class_2487 config, String key, String group) {
        class_2487 block = this.PROVIDER.randomElement(this.random, group);
        config.method_10566(key, (class_2520)block);
    }

    void addRandomIntProvider(class_2487 config, String key, int lbound, int bound) {
        config.method_10566(key, NbtUtils.randomIntProvider(this.random, lbound, bound, true));
    }

    abstract class_2487 feature();

    abstract void placement();

    void placement_everylayer_biome(int count) {
        this.addCountEveryLayer(count);
        this.addBiome();
    }

    void placement_uniform(int count) {
        this.addCount(count);
        this.addInSquare();
        this.addHeightRange(RandomisedFeature.fullHeightRange());
    }

    void placement_floating(int chance, int a, int b) {
        this.addRarityFilter(chance);
        if (a == b) {
            ++a;
        }
        this.addHeightRange(RandomisedFeature.uniformHeightRange(Math.min(a, b), Math.max(a, b)));
        this.addBlockPredicateFilter(RandomisedFeature.not(RandomisedFeature.ofType("solid")));
        this.addBiome();
    }

    class_2487 feature(class_2487 config) {
        class_2487 res = new class_2487();
        res.method_10582("type", this.id);
        res.method_10566("config", (class_2520)config);
        return res;
    }

    static class_2487 singleRule(String type, String name_param, class_2520 b) {
        class_2487 res = RandomisedFeature.ofType(type);
        res.method_10566(name_param, b);
        return res;
    }

    static class_2487 ofType(String type) {
        class_2487 res = new class_2487();
        res.method_10582("type", "minecraft:" + type);
        return res;
    }

    void addSingleRule(String name, String name_param, class_2520 b) {
        this.placement_data.add((Object)RandomisedFeature.singleRule(name, name_param, b));
    }

    void addEmptyRule(String name) {
        this.placement_data.add((Object)RandomisedFeature.ofType(name));
    }

    void addBlockPredicateFilter(class_2487 predicate) {
        this.addSingleRule("block_predicate_filter", "predicate", (class_2520)predicate);
    }

    void addCount(int b) {
        this.addSingleRule("count", "count", (class_2520)class_2497.method_23247((int)b));
    }

    void addCountEveryLayer(int b) {
        this.addSingleRule("count_on_every_layer", "count", (class_2520)class_2497.method_23247((int)b));
    }

    void addRarityFilter(int b) {
        this.addSingleRule("rarity_filter", "chance", (class_2520)class_2497.method_23247((int)b));
    }

    void addWaterDepthFilter(int b) {
        this.addSingleRule("surface_water_depth_filter", "max_water_depth", (class_2520)class_2497.method_23247((int)b));
    }

    void addInSquare() {
        this.addEmptyRule("in_square");
    }

    void addBiome() {
        this.addEmptyRule("biome");
    }

    void addHeightmap(String s) {
        this.addSingleRule("heightmap", "heightmap", (class_2520)class_2519.method_23256((String)s));
    }

    void addHeightRange(class_2487 heightProvider) {
        this.addSingleRule("height_range", "height", (class_2520)heightProvider);
    }

    static class_2487 fullHeightRange() {
        class_2487 res = RandomisedFeature.ofType("uniform");
        class_2487 max_inclusive = new class_2487();
        class_2487 min_inclusive = new class_2487();
        max_inclusive.method_10569("below_top", 0);
        min_inclusive.method_10569("above_bottom", 0);
        res.method_10566("max_inclusive", (class_2520)max_inclusive);
        res.method_10566("min_inclusive", (class_2520)min_inclusive);
        return res;
    }

    static class_2487 uniformHeightRange(int min, int max) {
        return RandomisedFeature.heightRange(min, max, "uniform");
    }

    static class_2487 heightRange(int min, int max, String type) {
        class_2487 res = RandomisedFeature.ofType(type);
        class_2487 max_inclusive = new class_2487();
        class_2487 min_inclusive = new class_2487();
        max_inclusive.method_10569("absolute", max);
        min_inclusive.method_10569("absolute", min);
        res.method_10566("max_inclusive", (class_2520)max_inclusive);
        res.method_10566("min_inclusive", (class_2520)min_inclusive);
        return res;
    }

    static class_2487 matchingBlocks(String block) {
        return RandomisedFeature.singleRule("matching_blocks", "blocks", (class_2520)class_2519.method_23256((String)block));
    }

    static class_2487 matchingFluids(String s) {
        return RandomisedFeature.singleRule("matching_fluids", "fluids", (class_2520)class_2519.method_23256((String)s));
    }

    static class_2487 matchingWater() {
        return RandomisedFeature.matchingFluids("minecraft:water");
    }

    static class_2487 matchingWaterOffset(class_2499 offset) {
        class_2487 res = RandomisedFeature.matchingWater();
        res.method_10566("offset", (class_2520)offset);
        return res;
    }

    static class_2487 not(class_2487 predicate) {
        return RandomisedFeature.singleRule("not", "predicate", (class_2520)predicate);
    }

    static class_2499 offsetToNbt(List<Integer> offset) {
        class_2499 offsetnbt = new class_2499();
        offset.forEach(a -> offsetnbt.add((Object)class_2497.method_23247((int)a)));
        return offsetnbt;
    }
}

