/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.entity.custom;

import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import net.lerariemann.infinity.entity.custom.ChaosPawn;
import net.lerariemann.infinity.entity.custom.ChaosSkeleton;
import net.lerariemann.infinity.entity.custom.ChaosSlime;
import net.lerariemann.infinity.iridescence.Iridescence;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_270;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_4538;
import net.minecraft.class_4802;
import net.minecraft.class_5134;
import net.minecraft.class_5354;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractChessFigure
extends class_1588
implements class_5354 {
    protected int angerTime;
    @Nullable
    protected UUID angryAt;

    protected AbstractChessFigure(class_1299<? extends AbstractChessFigure> entityType, class_1937 world) {
        super(entityType, world);
    }

    public abstract boolean isBlackOrWhite();

    protected void method_5959() {
        this.initRegularGoals();
        this.initChessGoals();
        this.initAttackType();
    }

    protected void initAttackType() {
        this.field_6201.method_6277(2, (class_1352)new class_1366((class_1314)this, 1.0, false));
    }

    protected void initChessGoals() {
        this.field_6185.method_6277(1, (class_1352)new ChessRevengeGoal((class_1314)this, new Class[0]).method_6318(new Class[0]));
        this.field_6185.method_6277(3, new ChaosCleanseGoal<ChaosSlime>((class_1308)this, ChaosSlime.class, true));
        this.field_6185.method_6277(3, new ChaosCleanseGoal<ChaosSkeleton>((class_1308)this, ChaosSkeleton.class, true));
        this.field_6185.method_6277(3, (class_1352)new ChessUniversalAngerGoal(this));
    }

    protected void initRegularGoals() {
        this.field_6201.method_6277(0, (class_1352)new SwimWithVehicleGoal((class_1308)this));
        this.field_6201.method_6277(7, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
    }

    public void method_29514(int angerTime) {
        this.angerTime = angerTime;
    }

    public int method_29507() {
        return this.angerTime;
    }

    public void method_29513(@Nullable UUID angryAt) {
        this.angryAt = angryAt;
    }

    @Nullable
    public UUID method_29508() {
        return this.angryAt;
    }

    public void method_29509() {
        this.method_29514(class_4802.method_24505((int)20, (int)40).method_35008(this.field_5974));
    }

    public boolean isInBattle() {
        return this.isInBattle("battle");
    }

    public boolean isInBattle(String battleName) {
        class_270 t = this.method_5781();
        return t != null && t.method_1197().contains(battleName);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        this.method_29517(nbt);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.method_29512(this.method_37908(), nbt);
    }

    protected void method_5958() {
        this.method_29510((class_3218)this.method_37908(), false);
        super.method_5958();
    }

    public float method_6144(class_2338 pos, class_4538 world) {
        if (!this.isBlackOrWhite()) {
            return 0.0f;
        }
        if (Iridescence.isIridescence((class_1922)world, pos)) {
            return -1.0f;
        }
        return 0.0f;
    }

    protected class_3414 method_5994() {
        return this.isBlackOrWhite() ? class_3417.field_14726 : class_3417.field_26980;
    }

    protected class_3414 method_6011(class_1282 source) {
        return this.isBlackOrWhite() ? class_3417.field_15115 : class_3417.field_26982;
    }

    protected class_3414 method_6002() {
        return this.isBlackOrWhite() ? class_3417.field_14904 : class_3417.field_26979;
    }

    public boolean shouldPursueRegularGoals() {
        return !Iridescence.isUnderEffect((class_1309)this);
    }

    public boolean shouldPursueChessGoals() {
        return this.shouldPursueRegularGoals() && this.isBlackOrWhite();
    }

    public static boolean isAngerCompatible(AbstractChessFigure fig1, AbstractChessFigure fig2) {
        if (fig1 instanceof ChaosPawn) {
            ChaosPawn p1 = (ChaosPawn)fig1;
            if (fig2 instanceof ChaosPawn) {
                ChaosPawn p2 = (ChaosPawn)fig2;
                return p1.getCase() == p2.getCase();
            }
        }
        return fig1.isBlackOrWhite() ^ !fig2.isBlackOrWhite();
    }

    public static class ChessRevengeGoal
    extends class_1399 {
        public ChessRevengeGoal(class_1314 mob, Class<?> ... noRevengeTypes) {
            super(mob, (Class[])noRevengeTypes);
        }

        protected void method_6317() {
            AbstractChessFigure figure;
            class_1308 class_13082 = this.field_6660;
            if (class_13082 instanceof AbstractChessFigure && (figure = (AbstractChessFigure)class_13082).shouldPursueRegularGoals()) {
                double d = this.method_6326();
                class_238 box = class_238.method_29968((class_243)figure.method_19538()).method_1009(d, 10.0, d);
                List list = figure.method_37908().method_8390(AbstractChessFigure.class, box, class_1301.field_6155);
                for (AbstractChessFigure pawn2 : list) {
                    if (figure == pawn2 || pawn2.method_5968() != null || pawn2.method_5722((class_1297)figure.method_6065()) || Iridescence.isUnderEffect((class_1309)pawn2) || !AbstractChessFigure.isAngerCompatible(pawn2, figure)) continue;
                    this.method_6319((class_1308)pawn2, figure.method_6065());
                }
            }
        }
    }

    public static class ChaosCleanseGoal<T extends class_1309>
    extends class_1400<T> {
        public ChaosCleanseGoal(class_1308 mob, Class<T> targetClass, boolean checkVisibility) {
            super(mob, targetClass, checkVisibility);
        }

        public boolean method_6264() {
            AbstractChessFigure e;
            class_1308 class_13082 = this.field_6660;
            if (class_13082 instanceof AbstractChessFigure && !(e = (AbstractChessFigure)class_13082).shouldPursueChessGoals()) {
                return false;
            }
            return super.method_6264();
        }
    }

    public static class ChessUniversalAngerGoal
    extends class_1352 {
        private final AbstractChessFigure mob;
        private int lastAttackedTime;

        public ChessUniversalAngerGoal(AbstractChessFigure mob) {
            this.mob = mob;
        }

        public boolean method_6264() {
            return this.mob.method_37908().method_8450().method_8355(class_1928.field_25402) && this.canStartUniversalAnger();
        }

        private boolean canStartUniversalAnger() {
            return this.mob.method_6065() != null && this.mob.method_6065().method_5864() == class_1299.field_6097 && this.mob.method_6117() > this.lastAttackedTime && this.mob.shouldPursueRegularGoals();
        }

        public void method_6269() {
            this.lastAttackedTime = this.mob.method_6117();
            this.mob.method_29921();
            this.getOthersInRange().stream().filter(entity -> {
                if (entity == this.mob) {
                    return false;
                }
                if (Iridescence.isUnderEffect((class_1309)entity)) {
                    return false;
                }
                if (entity instanceof AbstractChessFigure) {
                    return AbstractChessFigure.isAngerCompatible(this.mob, entity);
                }
                return true;
            }).map(entity -> entity).forEach(class_5354::method_29921);
            super.method_6269();
        }

        private List<? extends AbstractChessFigure> getOthersInRange() {
            double d = this.mob.method_26825(class_5134.field_23717);
            class_238 box = class_238.method_29968((class_243)this.mob.method_19538()).method_1009(d, 10.0, d);
            return this.mob.method_37908().method_8390(((Object)((Object)this.mob)).getClass(), box, class_1301.field_6155);
        }
    }

    public static class SwimWithVehicleGoal
    extends class_1352 {
        private final class_1308 mob;

        public SwimWithVehicleGoal(class_1308 mob) {
            this.mob = mob;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18407));
            mob.method_5942().method_6354(true);
        }

        public void method_6269() {
            class_1297 class_12972 = this.mob.method_49694();
            if (class_12972 instanceof class_1308) {
                class_1308 vehicle = (class_1308)class_12972;
                vehicle.method_5942().method_6354(true);
            }
        }

        public boolean method_6264() {
            class_1297 class_12972 = this.mob.method_49694();
            if (class_12972 instanceof class_1308) {
                class_1308 vehicle = (class_1308)class_12972;
                return SwimWithVehicleGoal.shouldMobSwim(vehicle);
            }
            return SwimWithVehicleGoal.shouldMobSwim(this.mob);
        }

        public static boolean shouldMobSwim(class_1308 mob) {
            return mob.method_5799() && mob.method_5861(class_3486.field_15517) > mob.method_29241() || mob.method_5771();
        }

        public boolean method_38846() {
            return true;
        }

        public void method_6268() {
            if (this.mob.method_6051().method_43057() < 0.8f) {
                class_1297 class_12972 = this.mob.method_49694();
                if (class_12972 instanceof class_1308) {
                    class_1308 vehicle = (class_1308)class_12972;
                    vehicle.method_5993().method_6233();
                }
                this.mob.method_5993().method_6233();
            }
        }
    }
}

