/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.entity.custom;

import java.util.Optional;
import net.lerariemann.infinity.block.custom.AntBlock;
import net.lerariemann.infinity.entity.custom.AbstractChessFigure;
import net.lerariemann.infinity.util.core.NbtUtils;
import net.lerariemann.infinity.util.var.BishopBattle;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3726;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import org.jetbrains.annotations.Nullable;

public class AntEntity
extends AbstractChessFigure {
    @Nullable
    protected class_2338 lastChangedPos;
    private class_2350 direction = class_2350.field_11034;
    private boolean dropsLoot = true;

    public AntEntity(class_1299<? extends AbstractChessFigure> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Override
    public boolean isBlackOrWhite() {
        return true;
    }

    public boolean method_27071() {
        return this.dropsLoot;
    }

    public void addToBattle(BishopBattle battle) {
        battle.addEntity((class_1309)this);
        this.dropsLoot = false;
    }

    @Override
    protected class_3414 method_5994() {
        return null;
    }

    @Override
    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_14593;
    }

    @Override
    protected class_3414 method_6002() {
        return class_3417.field_14673;
    }

    @Override
    protected void method_5959() {
        this.field_6185.method_6277(2, new AntBattleGoal<class_1657>((class_1308)this, class_1657.class, true));
        this.field_6201.method_6277(3, (class_1352)new AntBlockRecolorGoal(this));
        super.method_5959();
    }

    @Override
    protected void initRegularGoals() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(5, (class_1352)new WanderConditionalGoal(this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new LookAtEntityConditionalGoal(this, class_1657.class, 6.0f));
        this.field_6201.method_6277(7, (class_1352)new LookAroundConditionalGoal(this));
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23719, (double)0.1f).method_26868(class_5134.field_23716, 6.0);
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.dropsLoot = NbtUtils.test(nbt, "dropsLoot", true);
        switch (nbt.method_10558("direction")) {
            case "N": {
                class_2350 class_23502 = class_2350.field_11043;
                break;
            }
            case "W": {
                class_2350 class_23502 = class_2350.field_11039;
                break;
            }
            case "S": {
                class_2350 class_23502 = class_2350.field_11035;
                break;
            }
            default: {
                class_2350 class_23502 = this.direction = class_2350.field_11034;
            }
        }
        if (nbt.method_10545("last_changed_pos")) {
            class_2487 pos = nbt.method_10562("last_changed_pos");
            this.lastChangedPos = new class_2338(pos.method_10550("x"), pos.method_10550("y"), pos.method_10550("z"));
        }
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("dropsLoot", this.dropsLoot);
        nbt.method_10582("direction", switch (this.direction) {
            case class_2350.field_11043 -> "N";
            case class_2350.field_11039 -> "W";
            case class_2350.field_11035 -> "S";
            default -> "E";
        });
        if (this.lastChangedPos != null) {
            class_2487 pos = new class_2487();
            pos.method_10569("x", this.lastChangedPos.method_10263());
            pos.method_10569("y", this.lastChangedPos.method_10264());
            pos.method_10569("z", this.lastChangedPos.method_10260());
            nbt.method_10566("last_changed_pos", (class_2520)pos);
        }
    }

    @Override
    public boolean shouldPursueRegularGoals() {
        class_1937 w = this.method_37908();
        Optional bp = this.field_44784;
        return (bp.isEmpty() || this.isInBattle() || !AntBlock.isSafeToRecolor(w, (class_2338)bp.get())) && super.shouldPursueRegularGoals();
    }

    public boolean method_5931(class_1657 player) {
        return !this.isInBattle();
    }

    public boolean method_26319(class_3610 state) {
        return state.method_15767(class_3486.field_15517);
    }

    public static class_265 getWaterCollisionShape(int level) {
        return class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)level, (double)16.0);
    }

    public void method_6007() {
        super.method_6007();
        if (!this.field_5953 && this.field_5964.getDouble((Object)class_3486.field_15517) > 0.0) {
            class_3726 shapeContext = class_3726.method_16195((class_1297)this);
            if (shapeContext.method_16192(AntEntity.getWaterCollisionShape(15), this.method_24515(), true) && !this.method_37908().method_8316(this.method_24515().method_10084()).method_15767(class_3486.field_15517)) {
                this.method_24830(true);
            } else {
                this.method_18799(this.method_18798().method_1021(0.5).method_1031(0.0, 0.05, 0.0));
            }
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (!this.method_5782() && player.method_5998(hand).method_7960()) {
            this.putPlayerOnBack(player);
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        return super.method_5992(player, hand);
    }

    protected void putPlayerOnBack(class_1657 player) {
        if (!this.method_37908().field_9236) {
            player.method_36456(this.method_36454());
            player.method_36457(this.method_36455());
            player.method_5804((class_1297)this);
        }
    }

    protected class_243 method_49482(class_1657 controllingPlayer, class_243 movementInput) {
        float f = controllingPlayer.field_6250;
        return new class_243((double)(controllingPlayer.field_6212 * 0.5f), 0.0, f < 0.0f ? (double)(f * 0.25f) : (double)f);
    }

    protected float method_49485(class_1657 controllingPlayer) {
        return (float)this.method_26825(class_5134.field_23719) * 0.8f;
    }

    @Nullable
    public class_1309 method_5642() {
        class_1297 class_12972 = this.method_31483();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            return player;
        }
        return super.method_5642();
    }

    protected void method_5865(class_1297 passenger, class_1297.class_4738 positionUpdater) {
        super.method_5865(passenger, positionUpdater);
        if (passenger instanceof class_1309) {
            ((class_1309)passenger).field_6283 = this.field_6283;
        }
    }

    protected void method_49481(class_1657 controllingPlayer, class_243 movementInput) {
        super.method_49481(controllingPlayer, movementInput);
        this.method_5710(controllingPlayer.method_36454(), controllingPlayer.method_36455() * 0.5f);
        this.field_6283 = this.field_6241 = this.method_36454();
        this.field_5982 = this.field_6241;
    }

    public static class AntBattleGoal<T extends class_1309>
    extends class_1400<T> {
        public AntBattleGoal(class_1308 mob, Class<T> targetClass, boolean checkVisibility) {
            super(mob, targetClass, checkVisibility);
        }

        public boolean method_6264() {
            AbstractChessFigure e;
            class_1308 class_13082 = this.field_6660;
            if (class_13082 instanceof AbstractChessFigure && !(e = (AbstractChessFigure)class_13082).isInBattle()) {
                return false;
            }
            return super.method_6264();
        }
    }

    public static class AntBlockRecolorGoal
    extends class_1352 {
        private final AntEntity mob;
        @Nullable
        private class_2338 targetPos;

        public AntBlockRecolorGoal(AntEntity mob) {
            this.mob = mob;
        }

        public boolean method_6264() {
            if (this.mob.shouldPursueRegularGoals()) {
                return false;
            }
            Optional bp = this.mob.field_44784;
            if (bp.isEmpty() || ((class_2338)bp.get()).equals((Object)this.mob.lastChangedPos)) {
                return false;
            }
            this.mob.lastChangedPos = (class_2338)bp.get();
            class_2680 down = this.mob.method_37908().method_8320((class_2338)bp.get());
            AntBlock.Clockwiseness cw = AntBlock.getCW(down.method_26204());
            if (cw == null) {
                return false;
            }
            class_2350 direction = this.mob.direction;
            class_2350 direction2 = cw.equals((Object)AntBlock.Clockwiseness.CW) ? direction.method_10170() : direction.method_10160();
            class_2248 newBlock = AntBlock.recolor(down.method_26204(), cw.equals((Object)AntBlock.Clockwiseness.CCW));
            if (newBlock == null) {
                return false;
            }
            this.targetPos = this.mob.method_24515().method_10093(direction2);
            this.mob.method_37908().method_8652((class_2338)bp.get(), newBlock.method_34725(down), 19);
            this.mob.direction = direction2;
            return true;
        }

        public boolean method_6266() {
            return false;
        }

        public void method_6269() {
            if (this.targetPos == null) {
                return;
            }
            class_243 v = this.targetPos.method_46558();
            this.mob.method_6082(v.field_1352, v.field_1351, v.field_1350, false);
            this.mob.method_36456(this.mob.direction.method_10144());
        }
    }

    public static class WanderConditionalGoal
    extends class_1394 {
        private final AntEntity mob1;

        public WanderConditionalGoal(AntEntity pathAwareEntity, double d) {
            super((class_1314)pathAwareEntity, d);
            this.mob1 = pathAwareEntity;
        }

        public boolean method_6264() {
            return super.method_6264() && this.mob1.shouldPursueRegularGoals();
        }
    }

    public static class LookAtEntityConditionalGoal
    extends class_1361 {
        private final AntEntity mob1;

        public LookAtEntityConditionalGoal(AntEntity mob, Class<? extends class_1309> targetType, float range) {
            super((class_1308)mob, targetType, range);
            this.mob1 = mob;
        }

        public boolean method_6264() {
            return super.method_6264() && this.mob1.shouldPursueRegularGoals();
        }
    }

    public static class LookAroundConditionalGoal
    extends class_1376 {
        private final AntEntity mob1;

        public LookAroundConditionalGoal(AntEntity mob) {
            super((class_1308)mob);
            this.mob1 = mob;
        }

        public boolean method_6264() {
            return super.method_6264() && this.mob1.shouldPursueRegularGoals();
        }
    }
}

