/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.entity.custom;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.access.MobEntityAccess;
import net.lerariemann.infinity.entity.custom.AbstractChessFigure;
import net.lerariemann.infinity.iridescence.Iridescence;
import net.lerariemann.infinity.util.core.RandomProvider;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1345;
import net.minecraft.class_1352;
import net.minecraft.class_1588;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class ChaosPawn
extends AbstractChessFigure {
    public static final class_2940<class_2487> colors = class_2945.method_12791(ChaosPawn.class, (class_2941)class_2943.field_13318);
    public static final class_2940<Integer> special_case = class_2945.method_12791(ChaosPawn.class, (class_2941)class_2943.field_13327);

    public ChaosPawn(class_1299<? extends ChaosPawn> entityType, class_1937 world) {
        super(entityType, world);
    }

    public void setColors(class_2487 i) {
        this.field_6011.method_12778(colors, (Object)i);
    }

    public class_2487 getColors() {
        return (class_2487)this.field_6011.method_12789(colors);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23721, 5.0).method_26868(class_5134.field_23717, 35.0).method_26868(class_5134.field_23719, 0.25);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(colors, (Object)new class_2487());
        this.field_6011.method_12784(special_case, (Object)-1);
    }

    @Override
    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(5, (class_1352)new class_1345((class_1308)this));
    }

    public void method_5983() {
        super.method_5983();
        this.setAllColors(((class_1959)this.method_37908().method_23753(this.method_24515()).comp_349()).method_8711(this.method_23317(), this.method_23321()));
    }

    public class_2561 method_23315() {
        int i = this.getCase();
        return switch (i) {
            case 0 -> class_2561.method_43471((String)"entity.infinity.pawn_black");
            case 1 -> class_2561.method_43471((String)"entity.infinity.pawn_white");
            default -> super.method_23315();
        };
    }

    public int getCase() {
        return (Integer)this.field_6011.method_12789(special_case);
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10566("colors", (class_2520)this.getColors());
        nbt.method_10569("case", this.getCase());
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setColors(nbt.method_10562("colors"));
        this.field_6011.method_12778(special_case, (Object)nbt.method_10550("case"));
    }

    public class_2960 method_5991() {
        return switch (this.getCase()) {
            case 0 -> new class_2960("infinity:entities/chaos_pawn_black");
            case 1 -> new class_2960("infinity:entities/chaos_pawn_white");
            default -> {
                boolean bl = RandomProvider.rule("pawnsCanDropIllegalItems");
                if (bl) {
                    yield new class_2960("");
                }
                yield new class_2960(InfinityMod.provider.randomName(this.field_5974, "loot_tables"));
            }
        };
    }

    public static class_2487 getColorSetup(Supplier<Integer> colorSupplier) {
        class_2487 c = new class_2487();
        Arrays.stream(new String[]{"body", "left_arm", "right_arm", "left_leg", "right_leg"}).forEach(s -> c.method_10569(s, ((Integer)colorSupplier.get()).intValue()));
        int head = colorSupplier.get();
        c.method_10569("head", head);
        c.method_10569("hat", 0xFFFFFF ^ head);
        return c;
    }

    public void setAllColors(int color) {
        this.setColors(ChaosPawn.getColorSetup(() -> color));
    }

    @Override
    public boolean isBlackOrWhite() {
        return (Integer)this.field_6011.method_12789(special_case) != -1 && !Iridescence.isUnderEffect((class_1309)this);
    }

    public void initFromBlock(class_2680 state) {
        if (state.method_27852(class_2246.field_10446) || state.method_27852(class_2246.field_10107)) {
            this.chess(true);
        } else if (state.method_27852(class_2246.field_10146) || state.method_27852(class_2246.field_10458)) {
            this.chess(false);
        } else {
            this.unchess();
        }
    }

    public void chess(boolean white) {
        this.field_6011.method_12778(special_case, (Object)(white ? 1 : 0));
        this.setAllColors(white ? 0xFFFFFF : 0);
    }

    public void unchess() {
        this.field_6011.method_12778(special_case, (Object)-1);
        this.setColors(ChaosPawn.getColorSetup(() -> this.field_5974.method_43048(0x1000000)));
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        this.initFromBlock(world.method_8320(this.method_24515().method_10074()));
        double i = this.field_5974.method_43058() * 40.0;
        Objects.requireNonNull(this.method_5996(class_5134.field_23716)).method_6192(i);
        this.method_6033((float)i);
        int a = (int)(0.1 * i);
        if (a > 0) {
            this.method_24834(class_1304.field_6169, ((class_1792)class_7923.field_41178.method_10223(new class_2960(InfinityMod.provider.randomName(i, "items")))).method_7854().method_46651(a));
            ((MobEntityAccess)((Object)this)).infinity$setPersistent(false);
        }
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    protected void method_6099(class_1282 source, int lootingMultiplier, boolean allowDrops) {
        super.method_6099(source, lootingMultiplier, allowDrops);
        if (!this.isBlackOrWhite() && RandomProvider.rule("pawnsCanDropIllegalItems")) {
            String s = InfinityMod.provider.randomName(this.field_5974, "items");
            double i = Objects.requireNonNull(this.method_5996(class_5134.field_23716)).method_6201() / 10.0;
            class_1799 stack = ((class_1792)class_7923.field_41178.method_10223(new class_2960(s))).method_7854().method_46651((int)(i * i));
            this.method_5775(stack);
        }
    }
}

