/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.features;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1936;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_4651;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6017;
import org.jetbrains.annotations.Nullable;

public class RandomColumnsFeature
extends class_3031<Config> {
    private static final ImmutableList<class_2248> CANNOT_REPLACE_BLOCKS = ImmutableList.of((Object)class_2246.field_10164, (Object)class_2246.field_9987, (Object)class_2246.field_10382, (Object)class_2246.field_10613, (Object)class_2246.field_10034, (Object)class_2246.field_10260);

    public RandomColumnsFeature(Codec<Config> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<Config> context) {
        int i = context.method_33653().method_16398();
        class_2338 blockPos = context.method_33655();
        class_5281 structureWorldAccess = context.method_33652();
        class_5819 random = context.method_33654();
        Config randomColumnsFeatureConfig = (Config)context.method_33656();
        if (!RandomColumnsFeature.canPlaceAt((class_1936)structureWorldAccess, i, blockPos.method_25503())) {
            return false;
        }
        int j = randomColumnsFeatureConfig.height().method_35008(random);
        boolean bl = random.method_43057() < 0.9f;
        int k = Math.min(j, bl ? 5 : 8);
        int l = bl ? 50 : 15;
        boolean bl2 = false;
        for (class_2338 blockPos2 : class_2338.method_27156((class_5819)random, (int)l, (int)(blockPos.method_10263() - k), (int)blockPos.method_10264(), (int)(blockPos.method_10260() - k), (int)(blockPos.method_10263() + k), (int)blockPos.method_10264(), (int)(blockPos.method_10260() + k))) {
            int m = j - blockPos2.method_19455((class_2382)blockPos);
            if (m < 0) continue;
            class_2680 state = ((Config)context.method_33656()).block().method_23455(random, blockPos2);
            bl2 |= this.placeBasaltColumn((class_1936)structureWorldAccess, i, blockPos2, m, randomColumnsFeatureConfig.reach().method_35008(random), state);
        }
        return bl2;
    }

    private boolean placeBasaltColumn(class_1936 world, int seaLevel, class_2338 pos, int height, int reach, class_2680 state) {
        boolean bl = false;
        block0: for (class_2338 blockPos : class_2338.method_10094((int)(pos.method_10263() - reach), (int)pos.method_10264(), (int)(pos.method_10260() - reach), (int)(pos.method_10263() + reach), (int)pos.method_10264(), (int)(pos.method_10260() + reach))) {
            class_2338 blockPos2;
            int i = blockPos.method_19455((class_2382)pos);
            class_2338 class_23382 = blockPos2 = RandomColumnsFeature.isAirOrOcean(world, seaLevel, blockPos) ? RandomColumnsFeature.moveDownToGround(world, seaLevel, blockPos.method_25503(), i) : RandomColumnsFeature.moveUpToAir(world, blockPos.method_25503(), i);
            if (blockPos2 == null) continue;
            class_2338.class_2339 mutable = blockPos2.method_25503();
            for (int j = height - i / 2; j >= 0; --j) {
                if (RandomColumnsFeature.isAirOrOcean(world, seaLevel, (class_2338)mutable)) {
                    this.method_13153((class_1945)world, (class_2338)mutable, state);
                    mutable.method_10098(class_2350.field_11036);
                    bl = true;
                    continue;
                }
                if (!world.method_8320((class_2338)mutable).method_27852(state.method_26204())) continue block0;
                mutable.method_10098(class_2350.field_11036);
            }
        }
        return bl;
    }

    @Nullable
    private static class_2338 moveDownToGround(class_1936 world, int seaLevel, class_2338.class_2339 mutablePos, int distance) {
        while (mutablePos.method_10264() > world.method_31607() + 1 && distance > 0) {
            --distance;
            if (RandomColumnsFeature.canPlaceAt(world, seaLevel, mutablePos)) {
                return mutablePos;
            }
            mutablePos.method_10098(class_2350.field_11033);
        }
        return null;
    }

    private static boolean canPlaceAt(class_1936 world, int seaLevel, class_2338.class_2339 mutablePos) {
        if (RandomColumnsFeature.isAirOrOcean(world, seaLevel, (class_2338)mutablePos)) {
            class_2680 blockState = world.method_8320((class_2338)mutablePos.method_10098(class_2350.field_11033));
            mutablePos.method_10098(class_2350.field_11036);
            return !blockState.method_26215() && !CANNOT_REPLACE_BLOCKS.contains((Object)blockState.method_26204());
        }
        return false;
    }

    @Nullable
    private static class_2338 moveUpToAir(class_1936 world, class_2338.class_2339 mutablePos, int distance) {
        while (mutablePos.method_10264() < world.method_31600() && distance > 0) {
            --distance;
            class_2680 blockState = world.method_8320((class_2338)mutablePos);
            if (CANNOT_REPLACE_BLOCKS.contains((Object)blockState.method_26204())) {
                return null;
            }
            if (blockState.method_26215()) {
                return mutablePos;
            }
            mutablePos.method_10098(class_2350.field_11036);
        }
        return null;
    }

    private static boolean isAirOrOcean(class_1936 world, int seaLevel, class_2338 pos) {
        class_2680 blockState = world.method_8320(pos);
        return blockState.method_26215() || blockState.method_26204() instanceof class_2404 && pos.method_10264() <= seaLevel;
    }

    public record Config(class_6017 reach, class_6017 height, class_4651 block) implements class_3037
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6017.method_35004((int)0, (int)3).fieldOf("reach").forGetter(a -> a.reach), (App)class_6017.method_35004((int)1, (int)15).fieldOf("height").forGetter(a -> a.height), (App)class_4651.field_24937.fieldOf("block_provider").forGetter(a -> a.block)).apply((Applicative)instance, Config::new));
    }
}

