/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.features;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1945;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3481;
import net.minecraft.class_4651;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public abstract class RandomMushroomFeature
extends class_3031<Config> {
    public RandomMushroomFeature(Codec<Config> codec) {
        super(codec);
    }

    protected void generateStem(class_1936 world, class_5819 random, class_2338 pos, Config config, int height, class_2338.class_2339 mutablePos) {
        for (int i = 0; i < height; ++i) {
            mutablePos.method_10101((class_2382)pos).method_10104(class_2350.field_11036, i);
            if (world.method_8320((class_2338)mutablePos).method_26216((class_1922)world, (class_2338)mutablePos)) continue;
            this.method_13153((class_1945)world, (class_2338)mutablePos, config.stemProvider().method_23455(random, pos));
        }
    }

    protected int getHeight(class_5819 random, int h) {
        int i = random.method_43048(3) + h - 1;
        if (random.method_43048(12) == 0) {
            i *= 2;
        }
        return i;
    }

    protected boolean canGenerate(class_1936 world, class_2338 pos, int height, class_2338.class_2339 mutablePos, Config config) {
        int i = pos.method_10264();
        if (i < world.method_31607() + 1 || i + height + 1 >= world.method_31600()) {
            return false;
        }
        class_2680 blockState = world.method_8320(pos.method_10074());
        if (!blockState.method_26204().equals(config.validBaseBlock().method_26204())) {
            return false;
        }
        for (int j = 0; j <= height; ++j) {
            int k = this.getCapSize(-1, -1, config.foliageRadius(), j);
            for (int l = -k; l <= k; ++l) {
                for (int m = -k; m <= k; ++m) {
                    class_2680 blockState2 = world.method_8320((class_2338)mutablePos.method_25504((class_2382)pos, l, j, m));
                    if (blockState2.method_26215() || blockState2.method_26164(class_3481.field_15503)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean method_13151(class_5821<Config> context) {
        class_2338.class_2339 mutable;
        class_5281 structureWorldAccess = context.method_33652();
        class_2338 blockPos = context.method_33655();
        class_5819 random = context.method_33654();
        Config hugeMushroomFeatureConfig = (Config)context.method_33656();
        int i = this.getHeight(random, ((Config)context.method_33656()).height());
        if (!this.canGenerate((class_1936)structureWorldAccess, blockPos, i, mutable = new class_2338.class_2339(), hugeMushroomFeatureConfig)) {
            return false;
        }
        this.generateCap((class_1936)structureWorldAccess, random, blockPos, i, mutable, hugeMushroomFeatureConfig);
        this.generateStem((class_1936)structureWorldAccess, random, blockPos, hugeMushroomFeatureConfig, i, mutable);
        return true;
    }

    protected abstract int getCapSize(int var1, int var2, int var3, int var4);

    protected abstract void generateCap(class_1936 var1, class_5819 var2, class_2338 var3, int var4, class_2338.class_2339 var5, Config var6);

    public record Config(class_4651 capProvider, class_4651 stemProvider, class_2680 validBaseBlock, int foliageRadius, int height) implements class_3037
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_4651.field_24937.fieldOf("cap_provider").forGetter(a -> a.capProvider), (App)class_4651.field_24937.fieldOf("stem_provider").forGetter(a -> a.stemProvider), (App)class_2680.field_24734.fieldOf("valid_base_block").forGetter(a -> a.validBaseBlock), (App)Codec.INT.fieldOf("foliage_radius").orElse((Object)2).forGetter(a -> a.foliageRadius), (App)Codec.INT.fieldOf("height").orElse((Object)5).forGetter(a -> a.height)).apply((Applicative)instance, Config::new));
    }
}

