/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.iridescence;

import dev.architectury.registry.registries.RegistrySupplier;
import java.awt.Color;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.entity.custom.ChaosCreeper;
import net.lerariemann.infinity.entity.custom.ChaosPawn;
import net.lerariemann.infinity.registry.core.ModEntities;
import net.lerariemann.infinity.registry.core.ModStatusEffects;
import net.lerariemann.infinity.registry.var.ModCriteria;
import net.lerariemann.infinity.registry.var.ModPayloads;
import net.lerariemann.infinity.registry.var.ModStats;
import net.lerariemann.infinity.registry.var.ModTags;
import net.lerariemann.infinity.util.InfinityMethods;
import net.lerariemann.infinity.util.PlatformMethods;
import net.lerariemann.infinity.util.core.CommonIO;
import net.lerariemann.infinity.util.loading.ShaderLoader;
import net.lerariemann.infinity.util.teleport.WarpLogic;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1422;
import net.minecraft.class_1621;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3730;
import net.minecraft.class_4051;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public interface Iridescence {
    public static final class_2960 TEXTURE = InfinityMethods.getId("block/iridescence");
    public static final class_2960 FLOWING_TEXTURE = InfinityMethods.getId("block/iridescence");
    public static final class_2960 OVERLAY_TEXTURE = InfinityMethods.getId("block/iridescence_overlay");
    public static final List<class_1767> dyeColors = List.of(class_1767.field_7964, class_1767.field_7946, class_1767.field_7947, class_1767.field_7961, class_1767.field_7942, class_1767.field_7955, class_1767.field_7951, class_1767.field_7966, class_1767.field_7945, class_1767.field_7958, class_1767.field_7954);
    public static final int ticksInHour = 1200;
    public static final Map<class_1299<? extends class_1308>, RegistrySupplier<? extends class_1299<? extends class_1308>>> convertibles = Map.ofEntries(Map.entry(class_1299.field_6137, ModEntities.CHAOS_SKELETON), Map.entry(class_1299.field_6046, ModEntities.CHAOS_CREEPER), Map.entry(class_1299.field_6069, ModEntities.CHAOS_SLIME));

    public static boolean isInfinite(class_1937 world) {
        return switch (world.method_27983().method_29177().toString()) {
            case "infinity:chaos", "infinity:colors" -> true;
            default -> false;
        };
    }

    public static boolean isIridescence(class_3610 st) {
        return st.method_39360((class_3611)PlatformMethods.getIridescenceStill().get()) || st.method_39360((class_3611)PlatformMethods.getIridescenceFlowing().get());
    }

    public static boolean isIridescence(class_1922 world, class_2338 pos) {
        return Iridescence.isIridescence(world.method_8316(pos));
    }

    public static boolean isIridescentItem(class_1799 stack) {
        return stack.method_31573(ModTags.IRIDESCENT_ITEMS);
    }

    public static boolean isUnderEffect(class_1309 entity) {
        return entity.method_6059((class_1291)ModStatusEffects.IRIDESCENT_EFFECT.comp_349());
    }

    public static int getPosBasedColor(class_2338 pos) {
        return Color.HSBtoRGB((float)InfinityMethods.sample(pos), 1.0f, 1.0f) & 0xFFFFFF;
    }

    public static int getTimeBasedColor() {
        long timeMS = LocalTime.now().toNanoOfDay() / 1000000L;
        int hue = (int)(timeMS % 24000L);
        return Color.HSBtoRGB((float)((double)hue / 24000.0), 1.0f, 1.0f) & 0xFFFFFF;
    }

    public static class_2248 getRandomColorBlock(class_1936 world, String str) {
        return (class_2248)class_7923.field_41175.method_10223(new class_2960(dyeColors.get(world.method_8409().method_43048(dyeColors.size())).method_7792() + "_" + str));
    }

    public static class_2248 getRandomColorBlock(double d, String str) {
        return (class_2248)class_7923.field_41175.method_10223(new class_2960(dyeColors.get((int)(d * (double)dyeColors.size())).method_7792() + "_" + str));
    }

    public static int getAmplifierOnApply(class_1309 entity, int original) {
        class_1293 cooldown = entity.method_6112((class_1291)ModStatusEffects.IRIDESCENT_COOLDOWN.comp_349());
        if (cooldown == null) {
            return original;
        }
        if (cooldown.method_5578() < 1 && original > 0) {
            return original / 2;
        }
        return -1;
    }

    public static int getFullEffectLength(int amplifier) {
        return Iridescence.getOnsetLength(amplifier) + Iridescence.getEffectLength(amplifier);
    }

    public static int getEffectLength(int amplifier) {
        return Iridescence.getComeupLength() + Iridescence.getPeakLength(amplifier) + Iridescence.getOffsetLength(amplifier);
    }

    public static int getOnsetLength(int amplifier) {
        return 1200 * Math.max(20, 60 - 5 * amplifier) / 120;
    }

    public static int getComeupLength() {
        return 1200;
    }

    public static int getPeakLength(int amplifier) {
        return 1200 * (4 + amplifier);
    }

    public static int getOffsetLength(int amplifier) {
        return 1200 * (4 + amplifier) / 2;
    }

    public static int getAfterglowDuration() {
        int minDuration = 24000;
        return (int)Math.floor((double)minDuration * Math.pow(2.0, InfinityMod.random.nextDouble(-1.0, 1.0)));
    }

    public static int getCooldownDuration() {
        return 168000;
    }

    public static void updateAtomics(int duration, int amplifier) {
        ShaderLoader.iridLevel.set(amplifier);
        ShaderLoader.iridProgress.set(switch (Iridescence.getPhase(duration, amplifier).ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> 0.0;
            case 1 -> (double)(Iridescence.getEffectLength(amplifier) - duration) / (1.0 * (double)Iridescence.getComeupLength());
            case 2 -> 1.0;
            case 3 -> (double)duration / (1.0 * (double)Iridescence.getOffsetLength(amplifier));
        });
    }

    public static Phase getPhase(class_1309 entity) {
        class_1293 effect = entity.method_6112((class_1291)ModStatusEffects.IRIDESCENT_EFFECT.comp_349());
        if (effect == null) {
            return Phase.INITIAL;
        }
        return Iridescence.getPhase(effect.method_5584(), effect.method_5578());
    }

    public static Phase getPhase(int duration, int amplifier) {
        int time_passed = Iridescence.getEffectLength(amplifier) - duration;
        if (time_passed < 0) {
            return Phase.INITIAL;
        }
        return time_passed < Iridescence.getComeupLength() ? Phase.UPWARDS : (duration <= Iridescence.getOffsetLength(amplifier) || amplifier == 0 ? Phase.DOWNWARDS : Phase.PLATEAU);
    }

    public static boolean shouldWarp(int duration, int amplifier) {
        return Iridescence.getPhase(duration, amplifier) == Phase.PLATEAU && duration % 1200 == 0;
    }

    public static boolean shouldReturn(int duration, int amplifier) {
        return amplifier > 0 && duration == Iridescence.getOffsetLength(amplifier);
    }

    public static boolean shouldRequestShaderLoad(int duration, int amplifier) {
        int time_passed = Iridescence.getEffectLength(amplifier) - duration;
        return time_passed == 0;
    }

    public static void loadShader(class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (class_2960)ModPayloads.SHADER_RELOAD, (class_2540)ModPayloads.buildPacket(player.method_51469(), true));
    }

    public static void unloadShader(class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (class_2960)ModPayloads.SHADER_RELOAD, (class_2540)ModPayloads.buildPacket(player.method_51469(), false));
    }

    public static boolean shouldApplyShader(@Nullable class_1657 player) {
        if (player == null) {
            return false;
        }
        class_1293 effect = player.method_6112((class_1291)ModStatusEffects.IRIDESCENT_EFFECT.comp_349());
        return effect != null && effect.method_5584() > 20 && Iridescence.getPhase(effect.method_5584(), effect.method_5578()) != Phase.INITIAL;
    }

    public static void tryBeginJourney(class_1309 entity, int amplifier, boolean willingly) {
        if ((amplifier = Iridescence.getAmplifierOnApply(entity, amplifier)) >= 0) {
            entity.method_6092(new class_1293((class_1291)ModStatusEffects.IRIDESCENT_EFFECT.comp_349(), Iridescence.getFullEffectLength(amplifier), amplifier, true, true));
            entity.method_6016((class_1291)ModStatusEffects.IRIDESCENT_COOLDOWN.comp_349());
            int cooldownDuration = Iridescence.getCooldownDuration();
            if (cooldownDuration > 0) {
                entity.method_6092(new class_1293((class_1291)ModStatusEffects.IRIDESCENT_COOLDOWN.comp_349(), cooldownDuration, amplifier > 0 ? 1 : 0, true, false));
            }
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                ModCriteria.IRIDESCENT.trigger(player, willingly, amplifier);
            }
        }
    }

    public static void saveCookie(class_3222 player) {
        class_2487 compound = new class_2487();
        compound.method_10549("x", player.method_19538().field_1352);
        compound.method_10549("y", player.method_19538().field_1351);
        compound.method_10549("z", player.method_19538().field_1350);
        compound.method_10582("dim", player.method_51469().method_27983().method_29177().toString());
        CommonIO.write(compound, InfinityMod.provider.savingPath, player.method_5845() + ".json");
    }

    public static void endJourney(class_3222 player, boolean isEarlyCancel, int amplifier) {
        if (!isEarlyCancel) {
            player.method_7339(ModStats.IRIDESCENCE, 1);
            if (amplifier != 0) {
                player.method_6092(new class_1293((class_1291)ModStatusEffects.AFTERGLOW.comp_349(), Iridescence.getAfterglowDuration(), 0, true, true));
            }
        }
        Path cookie = InfinityMod.provider.savingPath.resolve(player.method_5845() + ".json");
        try {
            class_2487 comp = CommonIO.read(cookie);
            player.method_14251(player.field_13995.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(comp.method_10558("dim")))), comp.method_10574("x"), comp.method_10574("y"), comp.method_10574("z"), player.method_36454(), player.method_36455());
        }
        catch (Exception e) {
            WarpLogic.respawnAlive(player);
        }
        try {
            Files.deleteIfExists(cookie);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class_2960 getIdForWarp(class_3222 player) {
        class_3218 w = player.method_51469().method_8503().method_30002();
        return InfinityMethods.getRandomId(new Random(w.method_8412() + w.method_8510() / 1200L));
    }

    public static boolean isConvertible(class_1308 entity) {
        ChaosPawn pawn;
        return convertibles.containsKey(entity.method_5864()) || entity instanceof ChaosPawn && (pawn = (ChaosPawn)entity).isBlackOrWhite();
    }

    public static void tryApplyEffect(class_1308 ent) {
        if (!ent.method_6059((class_1291)ModStatusEffects.IRIDESCENT_EFFECT.comp_349())) {
            if (ent instanceof class_1422) {
                ent.method_6092(new class_1293((class_1291)ModStatusEffects.IRIDESCENT_EFFECT.comp_349(), 1200, 0, true, false));
            } else if (Iridescence.isConvertible(ent)) {
                ent.method_6092(new class_1293((class_1291)ModStatusEffects.IRIDESCENT_EFFECT.comp_349(), 1200, 0, true, true));
            }
        }
    }

    public static void endConversion(class_1308 currEntity) {
        class_1308 newEntity;
        class_1299 type = currEntity.method_5864();
        if (!convertibles.containsKey(type)) {
            return;
        }
        class_1299 typeNew = (class_1299)convertibles.get(type).get();
        if (typeNew != null && (newEntity = (class_1308)typeNew.method_5883(currEntity.method_37908())) != null) {
            currEntity.method_31472();
            ModEntities.copy(currEntity, newEntity);
            if (newEntity instanceof ChaosCreeper) {
                ChaosCreeper creeper = (ChaosCreeper)newEntity;
                class_6880 b = creeper.method_37908().method_23753(creeper.method_24515());
                creeper.setBiome(b.method_40230().map(key -> key.method_29177().toString()).orElse("[unregistered]"));
                creeper.setColor(((class_1959)b.comp_349()).method_8698());
                creeper.setRandomCharge();
            } else {
                class_1937 class_19372 = currEntity.method_37908();
                if (class_19372 instanceof class_3218) {
                    class_3218 w = (class_3218)class_19372;
                    newEntity.method_5943((class_5425)w, w.method_8404(currEntity.method_24515()), class_3730.field_16468, null, null);
                }
            }
            if (currEntity instanceof class_1621) {
                class_1621 e1 = (class_1621)currEntity;
                if (newEntity instanceof class_1621) {
                    class_1621 e2 = (class_1621)newEntity;
                    e2.method_7161(e1.method_7152(), true);
                }
            }
            currEntity.method_37908().method_8649((class_1297)newEntity);
            newEntity.method_5783(class_3417.field_15168, 1.0f, 1.0f);
            Iridescence.convTriggers((class_1309)currEntity);
        }
    }

    public static void convTriggers(class_1309 entity) {
        Iridescence.triggerConversion(entity.method_37908().method_18459(entity.method_23317(), entity.method_23318(), entity.method_23321(), 50.0, false), entity);
        entity.method_37908().method_18464(class_4051.field_18092, entity, class_238.method_30048((class_243)entity.method_19538(), (double)10.0, (double)10.0, (double)10.0)).forEach(p -> Iridescence.triggerConversion(p, entity));
    }

    public static void triggerConversion(class_1657 player, class_1309 entity) {
        if (player instanceof class_3222) {
            class_3222 np = (class_3222)player;
            ModCriteria.CONVERT_MOB.trigger(np, entity);
        }
    }

    public static enum Phase {
        INITIAL,
        UPWARDS,
        PLATEAU,
        DOWNWARDS;

    }
}

