/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.iridescence;

import java.util.Objects;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.entity.custom.ChaosPawn;
import net.lerariemann.infinity.iridescence.Iridescence;
import net.lerariemann.infinity.registry.core.ModStatusEffects;
import net.lerariemann.infinity.util.core.RandomProvider;
import net.lerariemann.infinity.util.loading.ShaderLoader;
import net.lerariemann.infinity.util.teleport.WarpLogic;
import net.minecraft.class_1289;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_4081;
import net.minecraft.class_5131;
import net.minecraft.class_5354;

public class IridescentEffect
extends class_1291
implements ModStatusEffects.SpecialEffect {
    public IridescentEffect(class_4081 category, int color) {
        super(category, color);
    }

    public void method_5555(class_1309 entity, class_5131 attributes, int amplifier) {
        class_3222 player;
        super.method_5555(entity, attributes, amplifier);
        if (entity.method_6059((class_1291)ModStatusEffects.IRIDESCENT_SETUP.comp_349())) {
            entity.method_6016((class_1291)ModStatusEffects.IRIDESCENT_SETUP.comp_349());
        }
        if (entity instanceof class_5354) {
            class_5354 ang = (class_5354)entity;
            ang.method_29922();
        }
        if (entity instanceof class_3222 && Iridescence.shouldApplyShader((class_1657)(player = (class_3222)entity))) {
            Iridescence.loadShader(player);
        }
    }

    @Override
    public void onRemoved(class_1309 entity) {
        class_1309 class_13092 = Objects.requireNonNull(entity);
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                Iridescence.unloadShader(serverPlayer);
                player.method_5684(false);
                if (Iridescence.getPhase(entity) == Iridescence.Phase.PLATEAU) {
                    Iridescence.endJourney(serverPlayer, true, 0);
                }
            }
        } else if (entity instanceof ChaosPawn) {
            ChaosPawn pawn = (ChaosPawn)entity;
            if (pawn.method_6051().method_43056()) {
                pawn.unchess();
                pawn.method_5783(class_3417.field_15168, 1.0f, 1.0f);
                Iridescence.convTriggers((class_1309)pawn);
            }
        } else if (entity instanceof class_1308) {
            class_1308 currEntity = (class_1308)entity;
            Iridescence.endConversion(currEntity);
        }
    }

    @Override
    public void tryApplySpecial(class_1309 entity, int duration, int amplifier) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                if (Iridescence.shouldWarp(duration, amplifier)) {
                    if (Iridescence.getPhase(duration + 1200, amplifier) != Iridescence.Phase.PLATEAU) {
                        if (RandomProvider.rule("iridSafeMode")) {
                            player.method_5684(true);
                        }
                        Iridescence.saveCookie(serverPlayer);
                    }
                    class_2960 id = Iridescence.getIdForWarp(serverPlayer);
                    WarpLogic.requestWarp(serverPlayer, id, false);
                }
                if (Iridescence.shouldReturn(duration, amplifier)) {
                    player.method_5684(false);
                    Iridescence.endJourney(serverPlayer, false, amplifier);
                }
                if (Iridescence.shouldRequestShaderLoad(duration, amplifier)) {
                    Iridescence.loadShader(serverPlayer);
                }
                if (amplifier == 0 && duration == 2) {
                    player.method_6092(new class_1293((class_1291)ModStatusEffects.AFTERGLOW.comp_349(), Iridescence.getAfterglowDuration() / 2, 0, true, true));
                }
            } else {
                Iridescence.updateAtomics(duration, amplifier);
                if (amplifier == 0) {
                    return;
                }
                double prog = ShaderLoader.iridProgress.get();
                if (prog > 0.5 && InfinityMod.random.nextDouble() < 0.015 * (2.0 * prog - 1.0) * (double)amplifier) {
                    entity.method_5783(class_3417.field_26980, 1.0f, 1.0f + InfinityMod.random.nextFloat());
                }
            }
        }
    }

    public static class Setup
    extends class_1289 {
        public Setup(class_4081 category, int color) {
            super(category, color);
        }

        public void method_5555(class_1309 entity, class_5131 attributes, int amplifier) {
            super.method_5555(entity, attributes, amplifier);
            Iridescence.tryBeginJourney(entity, amplifier, true);
        }
    }
}

