/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.item;

import java.awt.Color;
import java.util.concurrent.atomic.AtomicBoolean;
import net.lerariemann.infinity.block.custom.AltarBlock;
import net.lerariemann.infinity.block.entity.ChromaticBlockEntity;
import net.lerariemann.infinity.block.entity.InfinityPortalBlockEntity;
import net.lerariemann.infinity.item.PortalDataHolder;
import net.lerariemann.infinity.registry.core.ModBlocks;
import net.lerariemann.infinity.registry.core.ModComponentTypes;
import net.lerariemann.infinity.registry.var.ModTags;
import net.lerariemann.infinity.util.BackportMethods;
import net.lerariemann.infinity.util.var.ColorLogic;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;

public class ChromaticItem
extends class_1792
implements PortalDataHolder {
    public ChromaticItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public static void playDing(class_1657 player, float pitch) {
        player.method_5783(class_3417.field_14627, 0.5f, pitch);
    }

    static class_2487 ofColor(int color) {
        class_2487 compound = new class_2487();
        compound.method_10569(ModComponentTypes.COLOR, color);
        return compound;
    }

    static class_2487 ofHue(int hue) {
        class_2487 compound = new class_2487();
        compound.method_10569(ModComponentTypes.COLOR, Color.HSBtoRGB((float)hue / 360.0f, 1.0f, 1.0f) & 0xFFFFFF);
        return compound;
    }

    static class_2487 ofDye(class_1767 dyeColor) {
        class_2487 compound = new class_2487();
        compound.method_10569(ModComponentTypes.COLOR, ColorLogic.getChromaticColor(dyeColor));
        compound.method_10582(ModComponentTypes.DYE_COLOR, dyeColor.method_7792());
        return compound;
    }

    public class_1269 method_7884(class_1838 context) {
        class_1657 player = context.method_8036();
        if (player == null) {
            return super.method_7884(context);
        }
        return this.useOnBlock(player, context.method_20287(), context.method_8045(), context.method_8037(), context.method_8041()) ? class_1269.field_5812 : super.method_7884(context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean useOnBlock(class_1657 player, class_1268 hand, class_1937 world, class_2338 pos, class_1799 currStack) {
        class_2586 dyeColor2;
        class_2680 oldState = world.method_8320(pos);
        int currColor = BackportMethods.getOrDefaultInt(currStack, ModComponentTypes.COLOR, 0xFFFFFF);
        if (player.method_5715()) {
            class_1799 newStack = currStack.method_7972();
            int i = -1;
            class_2586 class_25862 = world.method_8321(pos);
            if (class_25862 instanceof ChromaticBlockEntity) {
                ChromaticBlockEntity cbe = (ChromaticBlockEntity)class_25862;
                i = cbe.getTint();
            } else {
                class_25862 = world.method_8321(pos);
                if (class_25862 instanceof InfinityPortalBlockEntity) {
                    InfinityPortalBlockEntity cbe = (InfinityPortalBlockEntity)class_25862;
                    i = cbe.getTint();
                } else if (oldState.method_27852((class_2248)ModBlocks.ALTAR.get())) {
                    int altarState = (Integer)oldState.method_11654((class_2769)AltarBlock.COLOR);
                    if (altarState == 0) {
                        i = ColorLogic.getChromaticColor(class_1767.field_7967);
                    } else {
                        int hue = (altarState - 1) * 30;
                        if (ColorLogic.matchesPureHue(currColor, hue)) return false;
                        newStack.method_7980(ChromaticItem.ofHue(hue));
                    }
                } else {
                    class_1767 dyeColor2 = ColorLogic.getColorByState(oldState);
                    if (dyeColor2 == null || dyeColor2.method_7792().equals(BackportMethods.getOrDefaultString(newStack, ModComponentTypes.DYE_COLOR, "null"))) return false;
                    newStack.method_7980(ChromaticItem.ofDye(dyeColor2));
                }
            }
            if (i > 0) {
                if (i == currColor) return false;
                newStack.method_7980(ChromaticItem.ofColor(i));
            }
            player.method_6122(hand, newStack);
            ChromaticItem.playDing(player, 0.5f);
            return true;
        }
        if (oldState.method_26164(ModTags.IRIDESCENT_BLOCKS)) {
            return false;
        }
        boolean bl = BackportMethods.contains(currStack, ModComponentTypes.DYE_COLOR);
        class_2680 state = bl ? ColorLogic.recolor(BackportMethods.getOrDefaultString(currStack, ModComponentTypes.DYE_COLOR, null), oldState) : ColorLogic.recolor("infinity:chromatic", oldState);
        if (state == null) {
            return false;
        }
        world.method_8501(pos, state);
        AtomicBoolean cancel = new AtomicBoolean(false);
        if (!bl && (dyeColor2 = world.method_8321(pos)) instanceof ChromaticBlockEntity) {
            ChromaticBlockEntity cbe = (ChromaticBlockEntity)dyeColor2;
            int hue = BackportMethods.getOrDefaultInt(currStack, ModComponentTypes.HUE, -1);
            if (hue > 0) {
                cbe.setColor(hue, 255, 255, cancel);
            } else {
                cbe.setColor(currColor, cancel);
            }
        }
        if (cancel.get()) return false;
        ChromaticItem.playDing(player, 1.0f);
        return true;
    }

    public class_2561 method_7848() {
        return class_2561.method_43471((String)this.method_7876()).method_10862(class_2583.field_24360.method_36139(9524443));
    }
}

