/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.item;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.lerariemann.infinity.block.entity.InfinityPortalBlockEntity;
import net.lerariemann.infinity.item.PortalDataHolder;
import net.lerariemann.infinity.registry.core.ModBlocks;
import net.lerariemann.infinity.registry.core.ModComponentTypes;
import net.lerariemann.infinity.util.BackportMethods;
import net.lerariemann.infinity.util.ClientMethods;
import net.lerariemann.infinity.util.InfinityMethods;
import net.lerariemann.infinity.util.teleport.InfinityPortal;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2423;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_5459;

public class F4Item
extends class_1792
implements PortalDataHolder {
    static final class_2680 OBSIDIAN = class_2246.field_10540.method_9564();

    public F4Item(class_1792.class_1793 settings) {
        super(settings);
    }

    public static class_5250 getDimensionTooltip(class_2960 dimension) {
        if (dimension == null) {
            return class_2561.method_43471((String)class_2246.field_10316.method_9539());
        }
        String name = dimension.toString();
        class_5250 text = InfinityMethods.getDimensionNameAsText(dimension);
        if (name.contains("infinity:generated_") || name.equals("infinity:random")) {
            return text;
        }
        return class_2561.method_43469((String)"tooltip.infinity.f4", (Object[])new Object[]{text});
    }

    public static int getCharge(class_1799 f4) {
        return BackportMethods.getOrDefaultInt(f4, ModComponentTypes.F4_CHARGE, 0);
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, world, tooltip, type);
        class_2960 dimension = BackportMethods.getDimensionIdentifier(stack);
        class_5250 mutableText = F4Item.getDimensionTooltip(dimension);
        tooltip.add((class_2561)mutableText.method_27692(class_124.field_1080));
        class_5250 mutableText2 = class_2561.method_43469((String)"tooltip.infinity.f4.charges", (Object[])new Object[]{F4Item.getCharge(stack)});
        tooltip.add((class_2561)mutableText2.method_27692(class_124.field_1080));
    }

    public static class_1799 placePortal(class_1937 world, class_1657 player, class_1799 stack, class_2338 lowerCenter, int size_x, int size_y) {
        boolean doNotRenderPortal;
        int useCharges;
        class_2350.class_2351 dir2 = player.method_5735().method_35833(class_2350.class_2351.field_11052).method_10166();
        int charges = BackportMethods.getOrDefaultInt(stack, ModComponentTypes.F4_CHARGE, 0);
        int n = useCharges = player.method_7337() ? 0 : 2 * (2 + size_x + size_y);
        if (charges < useCharges) {
            if (!world.method_8608()) {
                player.method_43496((class_2561)class_2561.method_43469((String)"error.infinity.f4.no_charges", (Object[])new Object[]{useCharges}));
            }
            return null;
        }
        class_2338 lowerLeft = lowerCenter.method_30513(dir2, -(size_x / 2));
        class_2960 id = BackportMethods.getDimensionIdentifier(stack);
        boolean bl = doNotRenderPortal = world.field_9236 && (id == null || !id.method_12832().contains("generated_"));
        if (PortalDataHolder.isDestinationRandom(id)) {
            id = InfinityMethods.getRandomId(world.field_9229);
        }
        int obsNotReplaced = 0;
        for (int x = -1; x <= size_x; ++x) {
            if (!world.method_8501(lowerLeft.method_30513(dir2, x).method_10086(size_y), OBSIDIAN)) {
                ++obsNotReplaced;
            }
            if (world.method_8501(lowerLeft.method_30513(dir2, x).method_10074(), OBSIDIAN)) continue;
            ++obsNotReplaced;
        }
        for (int y = 0; y < size_y; ++y) {
            if (!world.method_8501(lowerLeft.method_30513(dir2, -1).method_10079(class_2350.field_11036, y), OBSIDIAN)) {
                ++obsNotReplaced;
            }
            if (!world.method_8501(lowerLeft.method_30513(dir2, size_x).method_10079(class_2350.field_11036, y), OBSIDIAN)) {
                ++obsNotReplaced;
            }
            if (doNotRenderPortal) continue;
            for (int x = 0; x < size_x; ++x) {
                class_2586 class_25862;
                class_2338 pos = lowerLeft.method_30513(dir2, x).method_10079(class_2350.field_11036, y);
                world.method_8501(pos, (class_2680)(id == null ? class_2246.field_10316 : (class_2248)ModBlocks.PORTAL.get()).method_9564().method_11657((class_2769)class_2423.field_11310, (Comparable)dir2));
                if (id == null || !((class_25862 = world.method_8321(pos)) instanceof InfinityPortalBlockEntity)) continue;
                InfinityPortalBlockEntity ipbe = (InfinityPortalBlockEntity)class_25862;
                ipbe.setData(world.method_8503(), id);
            }
        }
        world.method_8396(player, player.method_24515(), class_3417.field_17265, class_3419.field_15245, 1.0f, 0.75f);
        return BackportMethods.apply(stack, ModComponentTypes.F4_CHARGE, charges - (useCharges -= obsNotReplaced));
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        if (world.field_9236) {
            ClientMethods.setF4Screen(player);
        }
        return class_1271.method_22427((Object)player.method_5998(hand));
    }

    public static class_1271<class_1799> deploy(class_1937 world, class_1657 player, class_1268 hand) {
        int i;
        int lowerY;
        class_2350 dir = player.method_5735();
        class_2350.class_2351 dir2 = dir.method_35833(class_2350.class_2351.field_11052).method_10166();
        class_2338 lowerCenter = player.method_24515().method_10079(dir, 4);
        class_1799 stack = player.method_5998(hand);
        int size_x = BackportMethods.getOrDefaultInt(stack, ModComponentTypes.SIZE_X, 3);
        int size_y = BackportMethods.getOrDefaultInt(stack, ModComponentTypes.SIZE_Y, 3);
        if (size_y % 2 == 0) {
            double d;
            double d2 = d = dir2.equals((Object)class_2350.class_2351.field_11048) ? player.method_19538().field_1352 : player.method_19538().field_1350;
            if (d % 1.0 > 0.5) {
                lowerCenter = lowerCenter.method_30513(dir2, 1);
            }
        }
        if (world.method_31601(lowerY = lowerCenter.method_10264())) {
            return class_1271.method_22430((Object)stack);
        }
        boolean positionFound = true;
        for (i = 0; i <= 8 && !world.method_31601(lowerY + i + size_y); ++i) {
            positionFound = true;
            block1: for (int j = 0; j <= size_y + 1 && positionFound; ++j) {
                for (int k = -1; k <= size_x; ++k) {
                    class_2680 bs = world.method_8320(lowerCenter.method_10086(i + j - 1).method_30513(dir2, k - size_x / 2));
                    if (bs.method_45474()) continue;
                    if (bs.method_27852(class_2246.field_10540)) {
                        if (j == 0 || j == size_y + 1 || k == -1 || k == size_x) continue;
                        i += j - 1;
                    } else {
                        i += j;
                    }
                    positionFound = false;
                    continue block1;
                }
            }
            if (positionFound) break;
        }
        if (!positionFound) {
            return class_1271.method_22430((Object)stack);
        }
        class_1799 newStack = F4Item.placePortal(world, player, stack.method_7972(), lowerCenter.method_10086(i), size_x, size_y);
        if (newStack == null) {
            return class_1271.method_22430((Object)stack);
        }
        return class_1271.method_22428((Object)(player.method_7337() ? stack : newStack));
    }

    public static boolean isPortal(class_2680 state) {
        return state.method_27852(class_2246.field_10316) || state.method_27852((class_2248)ModBlocks.PORTAL.get());
    }

    public class_1269 method_7884(class_1838 context) {
        class_2338 pos;
        class_1657 player = context.method_8036();
        if (player == null) {
            return class_1269.field_5814;
        }
        class_1799 stack = context.method_8041();
        class_1937 world = context.method_8045();
        class_2680 bs = world.method_8320(pos = context.method_8037());
        if (bs.method_45474()) {
            pos = pos.method_10074();
            bs = world.method_8320(pos);
        }
        class_1268 hand = context.method_20287();
        if (F4Item.isPortal(bs)) {
            class_1799 newStack = F4Item.useOnPortalBlock(world, pos, stack.method_7972());
            if (!player.method_7337()) {
                player.method_6122(hand, newStack);
            }
            return class_1269.field_21466;
        }
        pos = pos.method_10086(bs.method_27852(class_2246.field_10540) ? 1 : 2);
        class_2350.class_2351 dir2 = player.method_5735().method_10166().equals((Object)class_2350.class_2351.field_11048) ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048;
        int size_x = BackportMethods.getOrDefaultInt(stack, ModComponentTypes.SIZE_X, 3);
        int size_y = BackportMethods.getOrDefaultInt(stack, ModComponentTypes.SIZE_Y, 3);
        for (int j = -1; j <= size_y; ++j) {
            for (int k = -1; k <= size_x; ++k) {
                bs = world.method_8320(pos.method_10086(j).method_30513(dir2, k - size_x / 2));
                if (bs.method_27852(class_2246.field_10540) && (j == -1 || j == size_y || k == -1 || k == size_x) || bs.method_45474()) continue;
                return class_1269.field_5814;
            }
        }
        class_1799 newStack = F4Item.placePortal(world, player, context.method_8041().method_7972(), pos, size_x, size_y);
        if (newStack == null) {
            return class_1269.field_5814;
        }
        if (!player.method_7337()) {
            player.method_6122(hand, newStack);
        }
        return class_1269.field_21466;
    }

    public static boolean checkIfValidAxis(class_2350.class_2351 axisFound, class_2350.class_2351 axisBeingChecked, class_2350.class_2351 forceAxis) {
        if (forceAxis == null) {
            return axisBeingChecked.method_10178() || axisFound.equals((Object)axisBeingChecked);
        }
        return axisFound.equals((Object)forceAxis);
    }

    public static boolean checkNeighbors(class_1937 world, class_2338 bp, Collection<class_2350> primaryOffsets, Collection<class_2350> secondaryOffsets, int max, class_2350.class_2351 forcePrimaryAxis) {
        int i = 0;
        boolean checkCorners = !secondaryOffsets.isEmpty();
        for (class_2350 dir : primaryOffsets) {
            class_2350.class_2351 axisFound;
            class_2680 bs = world.method_8320(bp.method_10093(dir));
            class_2350.class_2351 axis = dir.method_10166();
            if (F4Item.isPortal(bs) && F4Item.checkIfValidAxis(axisFound = (class_2350.class_2351)bs.method_11654((class_2769)class_2741.field_12529), axis, forcePrimaryAxis) && ++i > max) {
                return true;
            }
            if (!checkCorners || !bs.method_27852(class_2246.field_10540)) continue;
            class_2350.class_2351 forceAxis = axis.method_10179() ? axis : null;
            return F4Item.checkNeighbors(world, bp.method_10093(dir), secondaryOffsets, Set.of(), 0, forceAxis);
        }
        return false;
    }

    public static void checkObsidianRemovalSides(class_1937 world, class_2338 bp, Set<class_2338> toRemove, Set<class_2338> toLeave, class_2350 direction) {
        if (world.method_8320(bp).method_27852(class_2246.field_10540)) {
            Set<class_2350> secondaryOffsets;
            boolean bl = direction.method_10166().method_10178();
            Set<class_2350> primaryOffsets = bl ? Set.of(direction) : Set.of(direction, direction.method_35833(class_2350.class_2351.field_11052), direction.method_35834(class_2350.class_2351.field_11052));
            Set<class_2350> set = secondaryOffsets = bl ? Set.of(class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039) : Set.of(class_2350.field_11036, class_2350.field_11033);
            if (F4Item.checkNeighbors(world, bp, primaryOffsets, secondaryOffsets, 0, null)) {
                toLeave.add(bp);
                return;
            }
            toRemove.add(bp);
        }
    }

    public static class_1799 useOnPortalBlock(class_1937 world, class_2338 origin, class_1799 stack) {
        class_2350.class_2351 axis = (class_2350.class_2351)world.method_8320(origin).method_11654((class_2769)class_2423.field_11310);
        class_2350 positive = axis.equals((Object)class_2350.class_2351.field_11048) ? class_2350.field_11034 : class_2350.field_11035;
        class_5459.class_5460 portal = InfinityPortal.getRect(world, origin);
        HashSet<class_2338> toRemove = new HashSet<class_2338>();
        HashSet<class_2338> toLeave = new HashSet<class_2338>();
        for (int i = -1; i <= portal.field_25937; ++i) {
            F4Item.checkObsidianRemovalSides(world, portal.field_25936.method_30513(axis, i).method_10086(-1), toRemove, toLeave, class_2350.field_11033);
            F4Item.checkObsidianRemovalSides(world, portal.field_25936.method_30513(axis, i).method_10086(portal.field_25938), toRemove, toLeave, class_2350.field_11036);
        }
        for (int j = -1; j <= portal.field_25938; ++j) {
            F4Item.checkObsidianRemovalSides(world, portal.field_25936.method_30513(axis, -1).method_10086(j), toRemove, toLeave, positive.method_10153());
            F4Item.checkObsidianRemovalSides(world, portal.field_25936.method_30513(axis, portal.field_25937).method_10086(j), toRemove, toLeave, positive);
        }
        int obsidian = 0;
        for (class_2338 bp : toRemove) {
            if (toLeave.contains(bp)) continue;
            world.method_30092(bp, class_2246.field_10124.method_9564(), 3, 0);
            ++obsidian;
        }
        for (int i = 0; i < portal.field_25937; ++i) {
            for (int j = 0; j < portal.field_25938; ++j) {
                world.method_30092(portal.field_25936.method_30513(axis, i).method_10086(j), class_2246.field_10124.method_9564(), 3, 0);
            }
        }
        world.method_8396(null, origin, class_3417.field_15081, class_3419.field_15245, 1.0f, 0.75f);
        return BackportMethods.apply(stack, ModComponentTypes.F4_CHARGE, F4Item.getCharge(stack) + obsidian);
    }
}

