/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.mixin.core;

import com.google.common.collect.ImmutableList;
import dev.architectury.platform.Platform;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.access.MinecraftServerAccess;
import net.lerariemann.infinity.compat.GravityChangerCompat;
import net.lerariemann.infinity.util.PlatformMethods;
import net.minecraft.class_1937;
import net.minecraft.class_2780;
import net.minecraft.class_32;
import net.minecraft.class_3218;
import net.minecraft.class_3738;
import net.minecraft.class_3949;
import net.minecraft.class_3950;
import net.minecraft.class_4543;
import net.minecraft.class_5219;
import net.minecraft.class_5268;
import net.minecraft.class_5304;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_8565;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerMixin
implements MinecraftServerAccess {
    @Final
    @Shadow
    private Map<class_5321<class_1937>, class_3218> field_4589;
    @Final
    @Shadow
    private Executor field_17200;
    @Final
    @Shadow
    protected class_32.class_5143 field_23784;
    @Final
    @Shadow
    protected class_5219 field_24372;
    @Final
    @Shadow
    private class_3950 field_17439;
    @Unique
    public Map<class_5321<class_1937>, class_3218> infinity$worldsToAdd;
    @Unique
    public boolean infinity$needsInvocation;

    @Shadow
    public class_3218 method_3847(class_5321<class_1937> key) {
        return null;
    }

    @Shadow
    protected class_3738 method_16209(Runnable runnable) {
        return null;
    }

    @Shadow
    public abstract class_5455.class_6890 method_30611();

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void injected(CallbackInfo info) {
        this.infinity$worldsToAdd = new HashMap<class_5321<class_1937>, class_3218>();
        this.infinity$needsInvocation = !Files.exists(InfinityMod.invocationLock, new LinkOption[0]);
        InfinityMod.LOGGER.info("Invocation {}", (Object)(this.infinity$needsInvocation ? "needed..." : "not needed"));
        if (!this.infinity$needsInvocation) {
            this.infinity$setDimensionProvider();
        }
    }

    @Override
    public boolean infinity$needsInvocation() {
        return this.infinity$needsInvocation;
    }

    @Override
    public void infinity$onInvocation() {
        this.infinity$needsInvocation = false;
        try {
            Path p = InfinityMod.invocationLock;
            if (!Files.exists(p, new LinkOption[0])) {
                Files.createDirectories(p.getParent(), new FileAttribute[0]);
                Files.copy(InfinityMod.rootConfigPathInJar.resolve(".util/invocation.lock"), p, StandardCopyOption.REPLACE_EXISTING);
            }
            this.infinity$setDimensionProvider();
            InfinityMod.LOGGER.info("Invocation complete");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void infinity$setDimensionProvider() {
        InfinityMod.updateProvider((MinecraftServer)this);
    }

    @Override
    public void infinity$addWorld(class_5321<class_1937> key, class_5363 options) {
        class_5268 serverWorldProperties = this.field_24372.method_27859();
        class_3218 world = new class_3218((MinecraftServer)this, this.field_17200, this.field_23784, serverWorldProperties, key, options, this.field_17439.create(11), this.field_24372.method_45556(), class_4543.method_27984((long)this.field_24372.method_28057().method_28028()), (List)ImmutableList.of(), false, this.method_3847((class_5321<class_1937>)class_1937.field_25179).method_52168());
        this.method_3847((class_5321<class_1937>)class_1937.field_25179).method_8621().method_11983((class_2780)new class_2780.class_3976(world.method_8621()));
        this.infinity$worldsToAdd.put(key, world);
        ((MinecraftServer)this).method_18858((Runnable)this.method_16209(() -> {
            this.field_4589.put(key, world);
            this.infinity$worldsToAdd.clear();
        }));
        if (Platform.isModLoaded((String)"gravity_changer_q")) {
            GravityChangerCompat.changeMavity(world);
        }
        PlatformMethods.onWorldLoad(this, world);
    }

    @Override
    public boolean infinity$hasToAdd(class_5321<class_1937> key) {
        return this.infinity$worldsToAdd.containsKey(key);
    }

    @Redirect(method={"createWorlds"}, at=@At(value="NEW", target="(Lnet/minecraft/server/MinecraftServer;Ljava/util/concurrent/Executor;Lnet/minecraft/world/level/storage/LevelStorage$Session;Lnet/minecraft/world/level/ServerWorldProperties;Lnet/minecraft/registry/RegistryKey;Lnet/minecraft/world/dimension/DimensionOptions;Lnet/minecraft/server/WorldGenerationProgressListener;ZJLjava/util/List;ZLnet/minecraft/util/math/random/RandomSequencesState;)Lnet/minecraft/server/world/ServerWorld;"))
    public class_3218 create(MinecraftServer server, Executor workerExecutor, class_32.class_5143 session, class_5268 properties, class_5321<class_1937> worldKey, class_5363 dimensionOptions, class_3949 worldGenerationProgressListener, boolean debugWorld, long seed, List<class_5304> spawners, boolean shouldTickTime, class_8565 randomSequencesState) {
        class_5268 prop = worldKey.method_29177().toString().contains("infinity") ? this.field_24372.method_27859() : properties;
        return new class_3218(server, workerExecutor, session, prop, worldKey, dimensionOptions, worldGenerationProgressListener, debugWorld, seed, spawners, shouldTickTime, randomSequencesState);
    }
}

