/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.options;

import java.io.File;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.lerariemann.infinity.access.InfinityOptionsAccess;
import net.lerariemann.infinity.options.EffectGiver;
import net.lerariemann.infinity.options.IridescentMap;
import net.lerariemann.infinity.options.PitchShifter;
import net.lerariemann.infinity.util.core.CommonIO;
import net.lerariemann.infinity.util.core.NbtUtils;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5218;
import net.minecraft.class_5819;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.joml.Vector3f;

public class InfinityOptions {
    public class_2487 data;
    public PitchShifter shifter;
    public EffectGiver effect;
    public IridescentMap iridMap;
    public static class_2487 defaultShader = new class_2487();

    public InfinityOptions(class_2487 data) {
        this.data = data;
        this.shifter = PitchShifter.decode(NbtUtils.test(data, "pitch_shift", new class_2487()));
        this.effect = EffectGiver.of(NbtUtils.test(data, "effect", new class_2487()));
        this.iridMap = IridescentMap.decode(NbtUtils.test(data, "iridescent_map", new class_2487()));
    }

    public class_2487 data() {
        return this.data;
    }

    public static InfinityOptions empty() {
        return new InfinityOptions(new class_2487());
    }

    public static class_2487 readData(MinecraftServer server, class_2960 worldId) {
        if (worldId.method_12836().equals("infinity")) {
            String name = worldId.method_12832();
            File f = server.method_27050(class_5218.field_24186).resolve(name + "/data/infinity/options.json").toFile();
            if (f.exists()) {
                return CommonIO.read(f);
            }
        }
        return new class_2487();
    }

    public static InfinityOptions generate(MinecraftServer server, class_2960 worldId) {
        return new InfinityOptions(InfinityOptions.readData(server, worldId));
    }

    public static InfinityOptions access(class_1937 world) {
        return ((InfinityOptionsAccess)world).infinity$getOptions();
    }

    @Environment(value=EnvType.CLIENT)
    public static InfinityOptions ofClient() {
        return InfinityOptions.ofClient(class_310.method_1551());
    }

    @Environment(value=EnvType.CLIENT)
    public static InfinityOptions ofClient(class_310 client) {
        return ((InfinityOptionsAccess)client).infinity$getOptions();
    }

    public static InfinityOptions nullSafe(InfinityOptions options) {
        return options != null ? options : InfinityOptions.empty();
    }

    public boolean isEmpty() {
        return this.data.method_33133();
    }

    public class_2487 getShader() {
        LogManager.getLogger().info((Object)defaultShader);
        return NbtUtils.test(this.data, "shader", defaultShader);
    }

    public double getTimeScale() {
        return NbtUtils.test(this.data, "time_scale", 1.0);
    }

    public double getMavity() {
        return NbtUtils.test(this.data, "mavity", 1.0);
    }

    public Function<Float, Float> getSoundPitch() {
        return this.shifter.applier();
    }

    public boolean isHaunted() {
        return NbtUtils.test(this.data, "haunted", false);
    }

    public int getHauntingTicks(class_5819 random) {
        if (!this.isHaunted()) {
            return -2;
        }
        if (this.data.method_10545("haunting_ticks")) {
            return this.data.method_10550("haunting_ticks");
        }
        return random.method_39332(NbtUtils.test(this.data, "min_haunting_ticks", 20), NbtUtils.test(this.data, "max_haunting_ticks", 200));
    }

    public String getSkyType() {
        return NbtUtils.test(this.data, "sky_type", "empty");
    }

    public float getHorizonShadingRatio() {
        return NbtUtils.test(this.data, "horizon_shading_ratio", 1.0f);
    }

    public boolean endSkyLike() {
        return NbtUtils.test(this.data, "end_sky_like", false);
    }

    public boolean hasDawn() {
        return NbtUtils.test(this.data, "dawn", !this.getSkyType().equals("rainbow"));
    }

    public float getSolarSize() {
        return NbtUtils.test(this.data, "solar_size", 30.0f);
    }

    public float getSolarTilt() {
        return NbtUtils.test(this.data, "solar_tilt", -90.0f);
    }

    public Vector3f getSolarTint() {
        int color = NbtUtils.test(this.data, "solar_tint", 0xFFFFFF);
        return new Vector3f((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
    }

    public class_2960 getSolarTexture() {
        return new class_2960(NbtUtils.test(this.data, "solar_texture", "textures/environment/sun.png"));
    }

    public int getNumStars() {
        return NbtUtils.test(this.data, "num_stars", 1500);
    }

    public float getStarSizeBase() {
        return NbtUtils.test(this.data, "star_size_base", 0.15f);
    }

    public float getStarSizeModifier() {
        return NbtUtils.test(this.data, "star_size_modifier", 0.1f);
    }

    public float getStellarTiltY() {
        return NbtUtils.test(this.data, "stellar_tilt_y", -90.0f);
    }

    public float getStellarTiltZ() {
        return NbtUtils.test(this.data, "stellar_tilt_z", 0.0f);
    }

    public float getStellarVelocity() {
        return NbtUtils.test(this.data, "stellar_velocity", 1.0f);
    }

    public float getDayStarBrightness() {
        return NbtUtils.test(this.data, "star_brightness_day", 0.0f);
    }

    public float getNightStarBrightness() {
        return NbtUtils.test(this.data, "star_brightness_night", 0.5f);
    }

    public Vector3f getStellarColor() {
        int color = NbtUtils.test(this.data, "stellar_color", 0xFFFFFF);
        return new Vector3f((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
    }

    public boolean isMoonCustom() {
        return this.data.method_10545("lunar_texture");
    }

    public int getNumMoons() {
        return this.data.method_10545("moons") ? this.data.method_10554("moons", 10).size() : 1;
    }

    public boolean lunarTest(String key, int i) {
        return this.data.method_10545("moons") && ((class_2487)this.data.method_10554("moons", 10).method_10534(i)).method_10545(key);
    }

    public float fullLunarTest(String key, int i, float def) {
        return this.lunarTest(key, i) ? ((class_2487)this.data.method_10554("moons", 10).method_10534(i)).method_10583(key) : def;
    }

    public float getLunarSize(int i) {
        return this.fullLunarTest("lunar_size", i, 20.0f);
    }

    public float getLunarTiltY(int i) {
        return this.fullLunarTest("lunar_tilt_y", i, -90.0f);
    }

    public float getLunarTiltZ(int i) {
        return this.fullLunarTest("lunar_tilt_z", i, 0.0f);
    }

    public Vector3f getLunarTint(int i) {
        int color = this.lunarTest("lunar_tint", i) ? ((class_2487)this.data.method_10554("moons", 10).method_10534(i)).method_10550("lunar_tint") : 0xFFFFFF;
        return new Vector3f((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
    }

    public class_2960 getLunarTexture(int i) {
        return new class_2960(this.lunarTest("lunar_texture", i) ? ((class_2487)this.data.method_10554("moons", 10).method_10534(i)).method_10558("lunar_texture") : "textures/environment/moon_phases.png");
    }

    public float getLunarVelocity(int i) {
        return this.fullLunarTest("lunar_velocity", i, 1.0f);
    }

    public float getLunarOffset(int i) {
        return this.fullLunarTest("lunar_offset", i, 0.0f);
    }
}

