/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.options;

import java.awt.Color;
import java.util.Random;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.options.InfinityOptions;
import net.lerariemann.infinity.util.InfinityMethods;
import net.lerariemann.infinity.util.core.NbtUtils;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;

public interface PortalColorApplier {
    public static PortalColorApplier of(class_2960 id, MinecraftServer server) {
        return PortalColorApplier.of(id, InfinityOptions.readData(server, id));
    }

    public static PortalColorApplier of(class_2960 id, class_2487 defaultData) {
        class_2487 data = InfinityMod.provider.easterizer.optionmap.get(id.method_12832());
        if (data == null) {
            data = defaultData;
        }
        return PortalColorApplier.of(data, (int)InfinityMethods.getNumericFromId(id));
    }

    public static PortalColorApplier of(class_2487 data, int defaultColor) {
        if (!data.method_10545("portal_color")) {
            return new Simple(defaultColor);
        }
        if (data.method_10573("portal_color", 3)) {
            return new Simple(data.method_10550("portal_color"));
        }
        class_2487 applierData = data.method_10562("portal_color");
        return switch (applierData.method_10558("type")) {
            case "simple" -> new Simple(applierData.method_10550("value"));
            case "checker" -> new Checker(applierData.method_10554("values", 3));
            case "random_hue" -> new RandomHue(applierData);
            case "random" -> RandomColor.INSTANCE;
            default -> new Simple(defaultColor);
        };
    }

    public int apply(class_2338 var1);

    public record Simple(int value) implements PortalColorApplier
    {
        @Override
        public int apply(class_2338 pos) {
            return this.value;
        }
    }

    public record Checker(class_2499 values) implements PortalColorApplier
    {
        @Override
        public int apply(class_2338 pos) {
            int mod = InfinityMethods.properMod(pos.method_10263() + pos.method_10264() + pos.method_10260(), this.values.size());
            return this.values.method_10600(mod);
        }
    }

    public record RandomHue(float saturation, float brightness, float detail) implements PortalColorApplier
    {
        public RandomHue(class_2487 applierData) {
            this(NbtUtils.test(applierData, "saturation", 1.0f), NbtUtils.test(applierData, "brightness", 1.0f), NbtUtils.test(applierData, "detail", 12.0f));
        }

        @Override
        public int apply(class_2338 pos) {
            float hue = (float)(pos.method_10263() + pos.method_10264() + pos.method_10260()) / this.detail;
            return Color.HSBtoRGB(hue - (float)((int)hue), this.saturation, this.brightness) & 0xFFFFFF;
        }
    }

    public static enum RandomColor implements PortalColorApplier
    {
        INSTANCE;


        @Override
        public int apply(class_2338 pos) {
            return new Random(pos.hashCode()).nextInt();
        }
    }
}

