/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.options;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.dimensions.RandomDimension;
import net.lerariemann.infinity.util.core.CommonIO;
import net.lerariemann.infinity.util.core.RandomProvider;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class RandomInfinityOptions {
    class_2487 data = new class_2487();
    String path;

    public RandomInfinityOptions(RandomDimension parent, boolean isEasterDim) {
        class_2487 effect;
        this.path = parent.getStoragePath();
        RandomProvider prov = parent.PROVIDER;
        if (isEasterDim && prov.easterizer.optionmap.containsKey(parent.getName())) {
            this.data = prov.easterizer.optionmap.get(parent.getName());
        }
        if (isEasterDim) {
            return;
        }
        Random r = parent.random;
        class_2487 shader = new class_2487();
        if (prov.roll(r, "use_shaders")) {
            Object[] lst = RandomInfinityOptions.genMatrix(r);
            shader = CommonIO.readAndFormat(String.valueOf(InfinityMod.utilPath) + "/shader.json", lst);
        }
        this.data.method_10566("shader", (class_2520)shader);
        this.data.method_10548("solar_size", (float)(30.0 * r.nextExponential()));
        this.data.method_10548("solar_tilt", (float)(360.0 * r.nextDouble() - 180.0));
        int moons = r.nextInt(1, 9);
        class_2499 moonslist = new class_2499();
        for (int i = 0; i < moons; ++i) {
            class_2487 moon = new class_2487();
            moon.method_10548("lunar_size", (float)(20.0 * r.nextExponential()));
            moon.method_10548("lunar_offset", (float)r.nextDouble());
            moon.method_10548("lunar_velocity", (float)(r.nextDouble() * 4.0 - 2.0));
            moon.method_10548("lunar_tilt_y", (float)(r.nextDouble() * 180.0 - 90.0));
            moon.method_10548("lunar_tilt_z", (float)(r.nextDouble() * 180.0 - 90.0));
            moon.method_10569("lunar_tint", r.nextInt(0x1000000));
            moonslist.add((Object)moon);
        }
        this.data.method_10566("moons", (class_2520)moonslist);
        this.data.method_10569("num_stars", r.nextInt(1000, 4000));
        this.data.method_10548("star_size_base", (float)(0.1 + r.nextDouble() * 0.3));
        this.data.method_10548("star_size_modifier", (float)(0.03 * r.nextExponential()));
        this.data.method_10548("stellar_velocity", (float)(r.nextDouble() * 4.0 - 2.0));
        this.data.method_10548("stellar_tilt_y", (float)(r.nextDouble() * 180.0 - 90.0));
        this.data.method_10548("stellar_tilt_z", (float)(r.nextDouble() * 180.0 - 90.0));
        float a = r.nextFloat();
        float b = r.nextFloat();
        this.data.method_10548("star_brightness_day", Math.min(a, b));
        this.data.method_10548("star_brightness_night", Math.max(a, b));
        this.data.method_10549("time_scale", RandomInfinityOptions.timeScale(r));
        this.data.method_10549("mavity", prov.roll(r, "use_mavity") ? RandomInfinityOptions.mavity(r) : 1.0);
        if (prov.roll(r, "pitch_shift")) {
            this.data.method_10566("pitch_shift", (class_2520)RandomInfinityOptions.pitchShift(r));
        }
        if (prov.roll(r, "give_effect") && !(effect = RandomInfinityOptions.effect(r, prov)).method_33133()) {
            this.data.method_10566("effect", (class_2520)effect);
        }
        this.data.method_10566("iridescent_map", (class_2520)RandomInfinityOptions.iridMap(r));
    }

    public static double timeScale(Random r) {
        double d = r.nextDouble();
        if (d < 0.1) {
            return r.nextDouble();
        }
        if (d < 0.5) {
            return 1.0;
        }
        if (d < 0.95) {
            return r.nextExponential() * 3.0;
        }
        return r.nextExponential() * 30.0;
    }

    public static double mavity(Random r) {
        double d = r.nextDouble();
        if (d < 0.8) {
            return r.nextDouble();
        }
        return 1.0 / (0.95 * r.nextDouble() + 0.05);
    }

    public void save() {
        CommonIO.write(this.data, this.path, "options.json");
    }

    static Object[] genMatrix(Random r) {
        ArrayList<Float> points = new ArrayList<Float>();
        float scale = 2.0f + r.nextFloat();
        points.add(Float.valueOf(0.0f));
        points.add(Float.valueOf(scale));
        for (int i = 0; i < 8; ++i) {
            points.add(Float.valueOf(scale * r.nextFloat()));
        }
        Collections.sort(points);
        Object[] res = new Object[9];
        for (int i = 0; i < 9; ++i) {
            res[i] = Float.valueOf(((Float)points.get(i + 1)).floatValue() - ((Float)points.get(i)).floatValue());
        }
        return res;
    }

    public static class_2487 pitchShift(Random r) {
        class_2487 comp = new class_2487();
        int i = r.nextInt(0, 2);
        switch (i) {
            case 0: {
                comp.method_10582("type", "constant");
                comp.method_10548("value", r.nextFloat(0.5f, 2.0f));
                return comp;
            }
            case 1: {
                comp.method_10582("type", "add");
                comp.method_10548("value", r.nextFloat(-1.0f, 1.0f));
                return comp;
            }
        }
        return comp;
    }

    public static class_2487 effect(Random r, RandomProvider provider) {
        class_2487 res = new class_2487();
        class_2487 effect = provider.randomElement(r, "effects");
        if (effect.method_10577("Instant")) {
            return new class_2487();
        }
        int amplifier = Math.min(5, (int)(0.5 * r.nextExponential()));
        res.method_10582("id", effect.method_10558("Name"));
        res.method_10569("amplifier", amplifier);
        return res;
    }

    public static class_2487 iridMap(Random r) {
        class_2487 res = new class_2487();
        res.method_10582("type", switch (r.nextInt(4)) {
            case 0 -> "static";
            case 1 -> "linear";
            case 2 -> "circles";
            default -> "noise";
        });
        return res;
    }
}

