/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.options;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.lerariemann.infinity.options.InfinityOptions;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5294;
import net.minecraft.class_5636;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_758;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public record SkyRenderer(InfinityOptions options, class_310 client, class_638 world, class_4587 matrices, class_289 tessellator, float tickDelta, Matrix4f projectionMatrix, class_291 lightSkyBuffer, class_291 starsBuffer) {
    public SkyRenderer(InfinityOptions options, class_310 client, class_638 world, class_4587 matrices, float tickDelta, Matrix4f projectionMatrix, class_291 lightSkyBuffer, class_291 starsBuffer) {
        this(options, client, world, matrices, class_289.method_1348(), tickDelta, projectionMatrix, lightSkyBuffer, starsBuffer);
    }

    public static boolean testCameraCancels(class_4184 camera) {
        class_5636 cameraSubmersionType = camera.method_19334();
        return cameraSubmersionType == class_5636.field_27887 || cameraSubmersionType == class_5636.field_27885;
    }

    public void render(Runnable fogCallback) {
        if (this.testAndRenderNonOverworldySkies()) {
            return;
        }
        this.setupOverworldySky();
        this.renderAllCelestialBodies(fogCallback);
        this.finish();
    }

    public boolean testAndRenderNonOverworldySkies() {
        if (this.client.field_1687 != null && this.client.field_1687.method_28103().method_29992() == class_5294.class_5401.field_25641) {
            this.renderSkybox(new class_2960("textures/environment/end_sky.png"), 16.0f, 40, 255);
            return true;
        }
        if (this.options.endSkyLike()) {
            this.handleSkyBackground();
            return true;
        }
        return this.client.field_1687 != null && this.client.field_1687.method_28103().method_29992() != class_5294.class_5401.field_25640;
    }

    public void setupOverworldySky() {
        class_758.method_3212();
        RenderSystem.depthMask((boolean)false);
        this.handleSkyBackground();
        this.handleFog();
        this.matrices.method_22903();
    }

    public void handleSkyBackground() {
        String skyType = this.options.getSkyType();
        if (skyType.equals("rainbow")) {
            this.renderRainbowBackground();
        } else {
            class_243 vec3d = this.world.method_23777(this.client.field_1773.method_19418().method_19326(), this.tickDelta);
            this.renderSingleColorBackground((float)vec3d.field_1352, (float)vec3d.field_1351, (float)vec3d.field_1350, 1.0f);
        }
    }

    public void renderRainbowBackground() {
        float main = this.world.method_30274(this.tickDelta) * 2.0f;
        int color = Color.getHSBColor(main - (float)((int)main), 1.0f, 1.0f).getRGB();
        float f = class_3532.method_15363((float)(class_3532.method_15362((float)(this.world.method_30274(this.tickDelta) * ((float)Math.PI * 2))) * 2.0f + 0.5f), (float)0.0f, (float)1.0f);
        this.renderSingleColorBackground(f * (float)(color >> 16 & 0xFF) / 255.0f, f * (float)(color >> 8 & 0xFF) / 255.0f, f * (float)(color & 0xFF) / 255.0f, 1.0f);
    }

    public void renderSingleColorBackground(float f, float g, float h, float a) {
        RenderSystem.setShaderColor((float)f, (float)g, (float)h, (float)a);
        this.lightSkyBuffer.method_1353();
        this.lightSkyBuffer.method_34427(this.matrices.method_23760().method_23761(), this.projectionMatrix, RenderSystem.getShader());
        class_291.method_1354();
    }

    public void handleFog() {
        RenderSystem.enableBlend();
        float[] fs = this.world.method_28103().method_28109(this.world.method_30274(this.tickDelta), this.tickDelta);
        if (fs != null && this.options().hasDawn()) {
            this.handleSunriseFog(fs);
        }
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
    }

    public void handleSunriseFog(float[] fs) {
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.matrices.method_22903();
        this.matrices.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
        float i = class_3532.method_15374((float)this.world.method_8442(this.tickDelta)) < 0.0f ? 180.0f : 0.0f;
        this.matrices.method_22907(class_7833.field_40718.rotationDegrees(i - this.options.getSolarTilt()));
        Matrix4f matrix4f = this.matrices.method_23760().method_23761();
        class_287 bufferBuilder = this.tessellator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
        bufferBuilder.method_22918(matrix4f, 0.0f, 100.0f, 0.0f).method_22915(fs[0], fs[1], fs[2], fs[3]);
        for (int n = 0; n <= 16; ++n) {
            float o = (float)n * ((float)Math.PI * 2) / 16.0f;
            float p = class_3532.method_15374((float)o);
            float q = class_3532.method_15362((float)o);
            bufferBuilder.method_22918(matrix4f, p * 120.0f, q * 120.0f, -q * 40.0f * fs[3]).method_22915(fs[0], fs[1], fs[2], 0.0f);
        }
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        this.matrices.method_22909();
    }

    public void renderAllCelestialBodies(Runnable fogCallback) {
        float rain_alpha = 1.0f - this.world.method_8430(this.tickDelta);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)rain_alpha);
        this.renderSun();
        for (int i = 0; i < this.options.getNumMoons(); ++i) {
            this.renderMoon(i);
        }
        this.renderStars(fogCallback, rain_alpha);
    }

    public void finish() {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        this.matrices.method_22909();
        RenderSystem.depthMask((boolean)true);
    }

    public void rotate_with_velocity(float v, float offset) {
        this.matrices.method_22907(class_7833.field_40714.rotationDegrees((this.world.method_30274(this.tickDelta) + offset) * 360.0f * v));
    }

    public void renderSun() {
        this.renderSingleBody(this.options.getSolarSize(), this.options.getSolarTilt(), 0.0f, 1.0f, 0.0f, this.options.getSolarTint(), this.options.getSolarTexture(), true);
    }

    public void renderMoon(int i) {
        this.renderSingleBody(this.options.getLunarSize(i), this.options.getLunarTiltY(i), this.options.getLunarTiltZ(i), this.options.getLunarVelocity(i), this.options.getLunarOffset(i), this.options.getLunarTint(i), this.options.getLunarTexture(i), false);
    }

    public void renderSingleBody(float size, float tilt_y, float tilt_z, float velocity, float offset, Vector3f tint, class_2960 texture, boolean sun) {
        this.matrices.method_22907(class_7833.field_40716.rotationDegrees(tilt_y));
        this.matrices.method_22907(class_7833.field_40718.rotationDegrees(tilt_z));
        this.rotate_with_velocity(velocity, offset);
        if (sun) {
            this.renderSun(this.matrices.method_23760().method_23761(), texture, size, 100.0f, tint);
        } else {
            this.renderMoon(this.matrices.method_23760().method_23761(), texture, size, -100.0f, tint);
        }
        this.rotate_with_velocity(-1.0f * velocity, offset);
        this.matrices.method_22907(class_7833.field_40718.rotationDegrees(-tilt_z));
        this.matrices.method_22907(class_7833.field_40716.rotationDegrees(-tilt_y));
    }

    public void renderSun(Matrix4f matrix4f2, class_2960 texture, float k, float y, Vector3f tint) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        RenderSystem.setShaderColor((float)tint.x, (float)tint.y, (float)tint.z, (float)1.0f);
        class_287 bufferBuilder = this.tessellator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix4f2, -k, y, -k).method_22913(0.0f, 0.0f);
        bufferBuilder.method_22918(matrix4f2, k, y, -k).method_22913(1.0f, 0.0f);
        bufferBuilder.method_22918(matrix4f2, k, y, k).method_22913(1.0f, 1.0f);
        bufferBuilder.method_22918(matrix4f2, -k, y, k).method_22913(0.0f, 1.0f);
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
    }

    public void renderMoon(Matrix4f matrix4f2, class_2960 texture, float k, float y, Vector3f tint) {
        float q;
        float p;
        float o;
        float t;
        if (!this.options.isMoonCustom()) {
            int moon_phase = this.world.method_30273();
            int s = moon_phase % 4;
            int m = moon_phase / 4 % 2;
            t = (float)s / 4.0f;
            o = (float)m / 2.0f;
            p = (float)(s + 1) / 4.0f;
            q = (float)(m + 1) / 2.0f;
        } else {
            q = 1.0f;
            t = 1.0f;
            o = 0.0f;
            p = 0.0f;
        }
        this.renderMoon(matrix4f2, texture, k, y, tint, t, q, p, o);
    }

    public void renderMoon(Matrix4f matrix4f2, class_2960 texture, float k, float y, Vector3f tint, float t, float q, float p, float o) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        RenderSystem.setShaderColor((float)tint.x, (float)tint.y, (float)tint.z, (float)1.0f);
        class_287 bufferBuilder = this.tessellator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix4f2, -k, y, k).method_22913(p, q);
        bufferBuilder.method_22918(matrix4f2, k, y, k).method_22913(t, q);
        bufferBuilder.method_22918(matrix4f2, k, y, -k).method_22913(t, o);
        bufferBuilder.method_22918(matrix4f2, -k, y, -k).method_22913(p, o);
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
    }

    public void renderStars(Runnable fogCallback, float rain_alpha) {
        this.renderStars(this.options.getStellarTiltY(), this.options.getStellarTiltZ(), this.options.getStellarVelocity(), 0.0f, fogCallback, rain_alpha);
    }

    public void renderStars(float tilt_y, float tilt_z, float velocity, float offset, Runnable fogCallback, float rain_alpha) {
        this.matrices.method_22907(class_7833.field_40716.rotationDegrees(tilt_y));
        this.matrices.method_22907(class_7833.field_40718.rotationDegrees(tilt_z));
        this.rotate_with_velocity(velocity, offset);
        this.renderStars(this.matrices.method_23760().method_23761(), this.projectionMatrix, fogCallback, rain_alpha);
        this.rotate_with_velocity(-1.0f * velocity, offset);
        this.matrices.method_22907(class_7833.field_40718.rotationDegrees(-tilt_z));
        this.matrices.method_22907(class_7833.field_40716.rotationDegrees(-tilt_y));
    }

    public void renderStars(Matrix4f matrix4f2, Matrix4f projectionMatrix, Runnable fogCallback, float rain_alpha) {
        float u = this.world.method_23787(this.tickDelta) * rain_alpha;
        Vector3f color = this.options.getStellarColor();
        if (u > 0.0f) {
            RenderSystem.setShaderColor((float)(u * color.x), (float)(u * color.y), (float)(u * color.z), (float)u);
            class_758.method_23792();
            this.starsBuffer.method_1353();
            this.starsBuffer.method_34427(matrix4f2, projectionMatrix, class_757.method_34539());
            class_291.method_1354();
            fogCallback.run();
        }
    }

    public float getStarBrightness(float tickDelta) {
        float f = this.world.method_30274(tickDelta);
        float g = 1.0f - (class_3532.method_15362((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.25f);
        g = class_3532.method_15363((float)g, (float)0.0f, (float)1.0f);
        float day = this.options.getDayStarBrightness();
        float night = this.options.getNightStarBrightness();
        return day + g * g * (night - day);
    }

    public void renderSkybox(class_2960 texture, float copies, int brightness, int alpha) {
        this.renderSkybox(texture, copies, brightness, brightness, brightness, alpha);
    }

    public void renderSkybox(class_2960 texture, float copies, int r, int g, int b, int alpha) {
        RenderSystem.enableBlend();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        class_289 tessellator = class_289.method_1348();
        for (int i = 0; i < 6; ++i) {
            this.matrices.method_22903();
            if (i == 1) {
                this.matrices.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
            }
            if (i == 2) {
                this.matrices.method_22907(class_7833.field_40714.rotationDegrees(-90.0f));
            }
            if (i == 3) {
                this.matrices.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
            }
            if (i == 4) {
                this.matrices.method_22907(class_7833.field_40718.rotationDegrees(90.0f));
            }
            if (i == 5) {
                this.matrices.method_22907(class_7833.field_40718.rotationDegrees(-90.0f));
            }
            Matrix4f matrix4f = this.matrices.method_23760().method_23761();
            class_287 bufferBuilder = tessellator.method_1349();
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
            bufferBuilder.method_22918(matrix4f, -100.0f, -100.0f, -100.0f).method_22913(0.0f, 0.0f).method_1336(r, g, b, alpha);
            bufferBuilder.method_22918(matrix4f, -100.0f, -100.0f, 100.0f).method_22913(0.0f, copies).method_1336(r, g, b, alpha);
            bufferBuilder.method_22918(matrix4f, 100.0f, -100.0f, 100.0f).method_22913(copies, copies).method_1336(r, g, b, alpha);
            bufferBuilder.method_22918(matrix4f, 100.0f, -100.0f, -100.0f).method_22913(copies, 0.0f).method_1336(r, g, b, alpha);
            class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
            this.matrices.method_22909();
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
    }
}

