/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.registry.core;

import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.lerariemann.infinity.entity.client.AntModel;
import net.lerariemann.infinity.entity.client.AntRenderer;
import net.lerariemann.infinity.entity.client.BishopModel;
import net.lerariemann.infinity.entity.client.BishopRenderer;
import net.lerariemann.infinity.entity.client.ChaosCreeperRenderer;
import net.lerariemann.infinity.entity.client.ChaosPawnRenderer;
import net.lerariemann.infinity.entity.client.ChaosSkeletonRenderer;
import net.lerariemann.infinity.entity.client.ChaosSlimeRenderer;
import net.lerariemann.infinity.entity.custom.AbstractChessFigure;
import net.lerariemann.infinity.entity.custom.AntEntity;
import net.lerariemann.infinity.entity.custom.BishopEntity;
import net.lerariemann.infinity.entity.custom.ChaosCreeper;
import net.lerariemann.infinity.entity.custom.ChaosPawn;
import net.lerariemann.infinity.entity.custom.ChaosSkeleton;
import net.lerariemann.infinity.entity.custom.ChaosSlime;
import net.lerariemann.infinity.util.InfinityMethods;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1429;
import net.minecraft.class_1547;
import net.minecraft.class_1548;
import net.minecraft.class_1588;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5601;
import net.minecraft.class_5819;
import net.minecraft.class_7924;

public class ModEntities {
    public static final DeferredRegister<class_1299<?>> INFINITY_ENTITIES = DeferredRegister.create((String)"infinity", (class_5321)class_7924.field_41266);
    public static final RegistrySupplier<class_1299<ChaosSlime>> CHAOS_SLIME = INFINITY_ENTITIES.register("chaos_slime", () -> FabricEntityTypeBuilder.create((class_1311)class_1311.field_6302, ChaosSlime::new).dimensions(class_4048.method_18384((float)0.52f, (float)0.52f)).trackRangeBlocks(10).build());
    public static final RegistrySupplier<class_1299<ChaosSkeleton>> CHAOS_SKELETON = INFINITY_ENTITIES.register("chaos_skeleton", () -> class_1299.class_1300.method_5903(ChaosSkeleton::new, (class_1311)class_1311.field_6302).method_17687(0.6f, 1.99f).method_27299(8).method_5905("chaos_skeleton"));
    public static final RegistrySupplier<class_1299<ChaosCreeper>> CHAOS_CREEPER = INFINITY_ENTITIES.register("chaos_creeper", () -> class_1299.class_1300.method_5903(ChaosCreeper::new, (class_1311)class_1311.field_6302).method_17687(0.6f, 1.7f).method_27299(8).method_5905(ModEntities.type("chaos_creeper")));
    public static final RegistrySupplier<class_1299<ChaosPawn>> CHAOS_PAWN = INFINITY_ENTITIES.register("chaos_pawn", () -> class_1299.class_1300.method_5903(ChaosPawn::new, (class_1311)class_1311.field_6302).method_17687(0.6f, 2.0f).method_27299(10).method_5905("chaos_pawn"));
    public static final RegistrySupplier<class_1299<AntEntity>> ANT = INFINITY_ENTITIES.register("ant", () -> class_1299.class_1300.method_5903(AntEntity::new, (class_1311)class_1311.field_6294).method_17687(0.6f, 0.3f).method_27299(10).method_5905(ModEntities.type("ant")));
    public static final RegistrySupplier<class_1299<BishopEntity>> BISHOP = INFINITY_ENTITIES.register("bishop", () -> class_1299.class_1300.method_5903(BishopEntity::new, (class_1311)class_1311.field_6302).method_17687(0.6f, 2.7f).method_27299(10).method_5905(ModEntities.type("bishop")));

    public static void copy(class_1308 from, class_1308 e) {
        e.method_5808(from.method_23317(), from.method_23318(), from.method_23321(), from.method_36454(), from.method_36455());
        e.method_6033(from.method_6032());
        e.field_6283 = from.field_6283;
        if (from.method_16914()) {
            e.method_5665(from.method_5797());
            e.method_5880(from.method_5807());
        }
        if (from.method_5947()) {
            e.method_5971();
        }
        e.method_5684(from.method_5655());
        e.method_6122(class_1268.field_5808, from.method_5998(class_1268.field_5808));
        e.method_6122(class_1268.field_5810, from.method_5998(class_1268.field_5810));
    }

    public static void registerEntities() {
        INFINITY_ENTITIES.register();
        ModEntities.registerAttributes();
    }

    public static String type(String id) {
        return "infinity:" + id;
    }

    public static void registerAttributes() {
        EntityAttributeRegistry.register(CHAOS_SLIME, ChaosSlime::createAttributes);
        EntityAttributeRegistry.register(CHAOS_SKELETON, class_1547::method_26905);
        EntityAttributeRegistry.register(CHAOS_CREEPER, class_1548::method_26908);
        EntityAttributeRegistry.register(CHAOS_PAWN, ChaosPawn::createAttributes);
        EntityAttributeRegistry.register(ANT, AntEntity::createAttributes);
        EntityAttributeRegistry.register(BISHOP, BishopEntity::createAttributes);
    }

    public static <T extends class_1308> void registerSafe(class_1299<T> type, class_1317.class_1319 location, class_2902.class_2903 heightmapType, class_1317.class_4306<T> predicate) {
        if (!class_1317.field_6313.containsKey(type)) {
            class_1317.method_20637(type, (class_1317.class_1319)location, (class_2902.class_2903)heightmapType, predicate);
        }
    }

    public static void registerSpawnRestrictions() {
        class_1317.method_20637((class_1299)((class_1299)CHAOS_SLIME.get()), (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, ChaosSlime::canSpawn);
        class_1317.method_20637((class_1299)((class_1299)CHAOS_SKELETON.get()), (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, ModEntities::canChaosMonsterSpawn);
        class_1317.method_20637((class_1299)((class_1299)CHAOS_CREEPER.get()), (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, ModEntities::canChaosMonsterSpawn);
        class_1317.method_20637((class_1299)((class_1299)CHAOS_PAWN.get()), (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, ModEntities::canChessFigureSpawn);
        class_1317.method_20637((class_1299)((class_1299)ANT.get()), (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, ModEntities::canChessFigureSpawn);
        class_1317.method_20637((class_1299)((class_1299)BISHOP.get()), (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, ModEntities::canChessFigureSpawn);
        ModEntities.registerSafe(class_1299.field_42622, class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_1429::method_20663);
        ModEntities.registerSafe(class_1299.field_40116, class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_1429::method_20663);
        ModEntities.registerSafe(class_1299.field_23696, class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_1588::method_20680);
    }

    public static boolean canChaosMonsterSpawn(class_1299<? extends class_1588> type, class_5425 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return class_1588.method_20680(type, (class_5425)world, (class_3730)spawnReason, (class_2338)pos, (class_5819)random) && InfinityMethods.chaosMobsEnabled();
    }

    public static boolean canChessFigureSpawn(class_1299<? extends AbstractChessFigure> type, class_5425 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return class_1308.method_20636(type, (class_1936)world, (class_3730)spawnReason, (class_2338)pos, (class_5819)random) && world.method_8407() != class_1267.field_5801 && InfinityMethods.chaosMobsEnabled();
    }

    public static void registerEntityRenderers() {
        EntityModelLayerRegistry.register((class_5601)AntModel.MODEL_LAYER, AntModel::getTexturedModelData);
        EntityModelLayerRegistry.register((class_5601)BishopModel.MODEL_LAYER, BishopModel::getTexturedModelData);
        EntityRendererRegistry.register(CHAOS_SLIME, ChaosSlimeRenderer::new);
        EntityRendererRegistry.register(CHAOS_SKELETON, ChaosSkeletonRenderer::new);
        EntityRendererRegistry.register(CHAOS_CREEPER, ChaosCreeperRenderer::new);
        EntityRendererRegistry.register(CHAOS_PAWN, ChaosPawnRenderer::new);
        EntityRendererRegistry.register(ANT, AntRenderer::new);
        EntityRendererRegistry.register(BISHOP, BishopRenderer::new);
    }
}

