/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.registry.core;

import dev.architectury.registry.item.ItemPropertiesRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.lerariemann.infinity.block.custom.BiomeBottleBlock;
import net.lerariemann.infinity.item.function.BiomeBottleCombiningRecipe;
import net.lerariemann.infinity.item.function.ChromaticColoringRecipe;
import net.lerariemann.infinity.item.function.CollisionCraftingRecipe;
import net.lerariemann.infinity.item.function.F4RechargingRecipe;
import net.lerariemann.infinity.options.InfinityOptions;
import net.lerariemann.infinity.registry.core.ModItems;
import net.lerariemann.infinity.util.BackportMethods;
import net.lerariemann.infinity.util.InfinityMethods;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2347;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_5339;
import net.minecraft.class_5633;
import net.minecraft.class_638;
import net.minecraft.class_7924;
import net.minecraft.class_8181;
import org.jetbrains.annotations.Nullable;

public class ModItemFunctions {
    public static final DeferredRegister<class_5339> LOOT_FUNCTION_TYPES = DeferredRegister.create((String)"infinity", (class_5321)class_7924.field_41199);
    public static final DeferredRegister<class_1865<?>> RECIPE_SERIALIZERS = DeferredRegister.create((String)"infinity", (class_5321)class_7924.field_41216);
    public static final DeferredRegister<class_3956<?>> RECIPE_TYPES = DeferredRegister.create((String)"infinity", (class_5321)class_7924.field_41217);
    public static RegistrySupplier<class_1865<BiomeBottleCombiningRecipe>> BIOME_BOTTLE_COMBINING = RECIPE_SERIALIZERS.register("biome_bottle_combining", () -> new class_1866(BiomeBottleCombiningRecipe::new));
    public static RegistrySupplier<class_1865<F4RechargingRecipe>> F4_RECHARGING = RECIPE_SERIALIZERS.register("f4_recharging", () -> new class_1866(F4RechargingRecipe::new));
    public static RegistrySupplier<class_1865<ChromaticColoringRecipe>> CHROMATIC_COLORING = RECIPE_SERIALIZERS.register("chromatic_coloring", () -> new ChromaticColoringRecipe.Serializer(ChromaticColoringRecipe::new));
    public static RegistrySupplier<class_1865<CollisionCraftingRecipe>> PORTAL_CRAFTING = RECIPE_SERIALIZERS.register("collision_portal", () -> new CollisionCraftingRecipe.Serializer(CollisionCraftingRecipe.OfPortal::new));
    public static RegistrySupplier<class_1865<CollisionCraftingRecipe>> IRIDESCENCE_CRAFTING = RECIPE_SERIALIZERS.register("collision_iridescence", () -> new CollisionCraftingRecipe.Serializer(CollisionCraftingRecipe.OfIridescence::new));
    public static RegistrySupplier<class_3956<CollisionCraftingRecipe>> PORTAL_CRAFTING_TYPE = RECIPE_TYPES.register("collision_portal", () -> CollisionCraftingRecipe.Type.PORTAL);
    public static RegistrySupplier<class_3956<CollisionCraftingRecipe>> IRIDESCENCE_CRAFTING_TYPE = RECIPE_TYPES.register("collision_iridescence", () -> CollisionCraftingRecipe.Type.IRIDESCENCE);

    public static void registerItemFunctions() {
        LOOT_FUNCTION_TYPES.register();
        RECIPE_SERIALIZERS.register();
        RECIPE_TYPES.register();
    }

    public static void registerDispenserBehaviour() {
        class_2315.method_10009((class_1935)((class_1935)ModItems.IRIDESCENCE_BUCKET.get()), (class_2357)new class_2347(){

            public class_1799 method_10135(class_2342 pointer, class_1799 stack) {
                class_5633 fluidModificationItem = (class_5633)stack.method_7909();
                class_2338 blockPos = pointer.method_10122().method_10093((class_2350)pointer.method_10120().method_11654((class_2769)class_2315.field_10918));
                class_3218 world = pointer.method_10207();
                if (fluidModificationItem.method_7731(null, (class_1937)world, blockPos, null)) {
                    fluidModificationItem.method_7728(null, (class_1937)world, stack, blockPos);
                    return stack.getRecipeRemainder();
                }
                return new class_2347().dispense(pointer, stack);
            }
        });
    }

    public static void checkCollisionRecipes(class_3218 w, class_1542 itemEntity, class_3956<CollisionCraftingRecipe> recipeType, class_2487 compound) {
        if (itemEntity.method_31481()) {
            return;
        }
        final class_1799 itemStack = itemEntity.method_6983();
        Optional match = w.method_8433().method_8132(recipeType, (class_1263)new class_8181(){

            public class_1799 method_5438(int slot) {
                return itemStack;
            }

            public class_1799 method_5434(int slot, int amount) {
                return null;
            }

            public void method_5447(int slot, class_1799 stack) {
            }

            public void method_5431() {
            }

            public boolean method_5443(class_1657 player) {
                return false;
            }
        }, (class_1937)w);
        if (match.isEmpty()) {
            return;
        }
        class_1799 resStack = ((CollisionCraftingRecipe)match.get()).method_8110(w.method_30349());
        resStack.method_7980(compound);
        class_243 v = itemEntity.method_18798();
        class_1542 result = new class_1542((class_1937)w, itemEntity.method_23317(), itemEntity.method_23318(), itemEntity.method_23321(), resStack.method_46651(itemEntity.method_6983().method_7947()), -v.field_1352, -v.field_1351, -v.field_1350);
        w.method_8649((class_1297)result);
        itemEntity.method_5650(class_1297.class_5529.field_27002);
    }

    @Deprecated
    @Environment(value=EnvType.CLIENT)
    public static float iridPredicate(@Nullable class_1799 stack, class_638 world, @Nullable class_1309 entity, int seed) {
        if (entity == null) {
            return 0.0f;
        }
        return (float)InfinityOptions.access((class_1937)world).iridMap.getColor(entity.method_24515()) / 100.0f;
    }

    @Environment(value=EnvType.CLIENT)
    public static void registerModelPredicates() {
        ItemPropertiesRegistry.register((class_1935)((class_1935)ModItems.TRANSFINITE_KEY.get()), (class_2960)InfinityMethods.getId("key"), (stack, world, entity, seed) -> {
            String id = stack.method_7969() != null ? stack.method_7969().method_10558("key_destination") : "minecraft:random";
            if (id == null) {
                return 0.0f;
            }
            if (id.contains("infinity:generated_")) {
                return 0.01f;
            }
            return switch (id) {
                case "minecraft:random" -> 0.02f;
                case "minecraft:the_end" -> 0.03f;
                case "infinity:pride" -> 0.04f;
                default -> 0.0f;
            };
        });
        ItemPropertiesRegistry.register((class_1935)((class_1935)ModItems.BIOME_BOTTLE_ITEM.get()), (class_2960)InfinityMethods.getId("bottle"), (stack, world, entity, seed) -> {
            int charge = BiomeBottleBlock.getCharge(stack);
            return class_3532.method_15363((float)((float)charge / 1000.0f), (float)0.0f, (float)1.0f);
        });
        ItemPropertiesRegistry.register((class_1935)((class_1935)ModItems.IRIDESCENT_CARPET.get()), (class_2960)InfinityMethods.getId("iridescent"), ModItemFunctions::iridPredicate);
        ItemPropertiesRegistry.register((class_1935)((class_1935)ModItems.IRIDESCENT_WOOL.get()), (class_2960)InfinityMethods.getId("iridescent"), ModItemFunctions::iridPredicate);
        ItemPropertiesRegistry.register((class_1935)((class_1935)ModItems.F4.get()), (class_2960)InfinityMethods.getId("f4"), (stack, world, entity, seed) -> {
            class_2960 id = BackportMethods.getDimensionIdentifier(stack);
            if (id == null) {
                return 0.0f;
            }
            if (id.toString().equals("infinity:random")) {
                return 0.02f;
            }
            return 0.01f;
        });
    }
}

