/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.registry.core;

import dev.architectury.core.item.ArchitecturyBucketItem;
import dev.architectury.core.item.ArchitecturySpawnEggItem;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.item.BiomeBottleItem;
import net.lerariemann.infinity.item.ChromaticBlockItem;
import net.lerariemann.infinity.item.ChromaticItem;
import net.lerariemann.infinity.item.F4Item;
import net.lerariemann.infinity.item.GlintItem;
import net.lerariemann.infinity.item.HomeItem;
import net.lerariemann.infinity.item.IridescentPotionItem;
import net.lerariemann.infinity.item.StarOfLangItem;
import net.lerariemann.infinity.item.TransfiniteKeyItem;
import net.lerariemann.infinity.registry.core.ModBlocks;
import net.lerariemann.infinity.registry.core.ModEntities;
import net.lerariemann.infinity.util.InfinityMethods;
import net.lerariemann.infinity.util.PlatformMethods;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_2248;
import net.minecraft.class_4174;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7924;

public class ModItems {
    public static final DeferredRegister<class_1792> ITEMS = DeferredRegister.create((String)"infinity", (class_5321)class_7924.field_41197);
    public static final RegistrySupplier<class_1792> PORTAL_ITEM = ITEMS.register(ModBlocks.PORTAL.getId(), () -> new class_1747((class_2248)ModBlocks.PORTAL.get(), new class_1792.class_1793()));
    public static final RegistrySupplier<class_1792> COSMIC_ALTAR_ITEM = ModItems.registerBlockItemAfter(ModBlocks.COSMIC_ALTAR, (class_5321<class_1761>)class_7706.field_40197, class_1802.field_16312, class_1747::new);
    public static final RegistrySupplier<class_1792> ALTAR_ITEM = ModItems.registerBlockItemAfter(ModBlocks.ALTAR, (class_5321<class_1761>)class_7706.field_40197, class_1802.field_16312, class_1747::new);
    public static final RegistrySupplier<class_1792> ANT_ITEM = ModItems.registerBlockItemAfter(ModBlocks.ANT, (class_5321<class_1761>)class_7706.field_40197, class_1802.field_23256, class_1747::new);
    public static final RegistrySupplier<class_1792> BOOK_BOX_ITEM = ModItems.registerBlockItemAfter(ModBlocks.BOOK_BOX, (class_5321<class_1761>)class_7706.field_40197, class_1802.field_40215, class_1747::new);
    public static final RegistrySupplier<class_1792> CURSOR_ITEM = ModItems.registerBlockItemAfter(ModBlocks.CURSOR, (class_5321<class_1761>)class_7706.field_41059, class_1802.field_8853, class_1747::new);
    public static final RegistrySupplier<class_1792> NETHERITE_SLAB_ITEM = ModItems.registerBlockItemAfter(ModBlocks.NETHERITE_SLAB, (class_5321<class_1761>)class_7706.field_40195, class_1802.field_22018, class_1747::new);
    public static final RegistrySupplier<class_1792> NETHERITE_STAIRS_ITEM = ModItems.registerBlockItemAfter(ModBlocks.NETHERITE_STAIRS, (class_5321<class_1761>)class_7706.field_40195, class_1802.field_22018, class_1747::new);
    public static final RegistrySupplier<class_1792> NOTES_BLOCK_ITEM = ModItems.registerBlockItemAfter(ModBlocks.NOTES_BLOCK, (class_5321<class_1761>)class_7706.field_40197, class_1802.field_8643, class_1747::new);
    public static final RegistrySupplier<class_1792> TIME_BOMB_ITEM = ModItems.registerBlockItemAfter(ModBlocks.TIME_BOMB, (class_5321<class_1761>)class_7706.field_40197, class_1802.field_8668, class_1747::new);
    public static final RegistrySupplier<class_1792> IRIDESCENT_WOOL = ModItems.registerBlockItemAfter(ModBlocks.IRIDESCENT_WOOL, (class_5321<class_1761>)class_7706.field_41059, class_1802.field_19050, class_1747::new);
    public static final RegistrySupplier<class_1792> IRIDESCENT_CARPET = ModItems.registerBlockItemAfter(ModBlocks.IRIDESCENT_CARPET, (class_5321<class_1761>)class_7706.field_41059, class_1802.field_8580, class_1747::new);
    public static final RegistrySupplier<ChromaticBlockItem> CHROMATIC_WOOL = ModItems.registerBlockItemAfter(ModBlocks.CHROMATIC_WOOL, (class_5321<class_1761>)class_7706.field_41059, class_1802.field_19050, new class_1792.class_1793(), ChromaticBlockItem::new);
    public static final RegistrySupplier<ChromaticBlockItem> CHROMATIC_CARPET = ModItems.registerBlockItemAfter(ModBlocks.CHROMATIC_CARPET, (class_5321<class_1761>)class_7706.field_41059, class_1802.field_8580, new class_1792.class_1793(), ChromaticBlockItem::new);
    public static final RegistrySupplier<class_1792> BIOME_BOTTLE_ITEM = ModItems.registerBlockItemAfter(ModBlocks.BIOME_BOTTLE, (class_5321<class_1761>)class_7706.field_41062, class_1802.field_8287, BiomeBottleItem::new);
    public static final RegistrySupplier<class_1792> CHAOS_CREEPER_SPAWN_EGG = ITEMS.register("chaos_creeper_spawn_egg", () -> new ArchitecturySpawnEggItem(ModEntities.CHAOS_CREEPER, 9551193, 7907327, ModItems.createSpawnEggSettings()));
    public static final RegistrySupplier<class_1792> CHAOS_SKELETON_SPAWN_EGG = ITEMS.register("chaos_skeleton_spawn_egg", () -> new ArchitecturySpawnEggItem(ModEntities.CHAOS_SKELETON, 15978425, 8889187, ModItems.createSpawnEggSettings()));
    public static final RegistrySupplier<class_1792> CHAOS_SLIME_SPAWN_EGG = ITEMS.register("chaos_slime_spawn_egg", () -> new ArchitecturySpawnEggItem(ModEntities.CHAOS_SLIME, 0xFF66FF, 0xAA77DD, ModItems.createSpawnEggSettings()));
    public static final RegistrySupplier<class_1792> CHAOS_PAWN_SPAWN_EGG = ITEMS.register("chaos_pawn_spawn_egg", () -> new ArchitecturySpawnEggItem(ModEntities.CHAOS_PAWN, 0x222222, 0xFFFFFF, ModItems.createSpawnEggSettings()));
    public static final RegistrySupplier<class_1792> ANT_SPAWN_EGG = ITEMS.register("ant_spawn_egg", () -> new ArchitecturySpawnEggItem(ModEntities.ANT, 0x444444, 0xFFFFFF, ModItems.createSpawnEggSettings()));
    public static final RegistrySupplier<class_1792> BISHOP_SPAWN_EGG = ITEMS.register("bishop_spawn_egg", () -> new ArchitecturySpawnEggItem(ModEntities.BISHOP, 0, 0xFFFFFF, ModItems.createSpawnEggSettings()));
    public static final RegistrySupplier<class_1792> IRIDESCENCE_BUCKET = ITEMS.register("iridescence_bucket", () -> new ArchitecturyBucketItem(PlatformMethods.getIridescenceStill(), new class_1792.class_1793().method_7896(class_1802.field_8550).method_7889(1)));
    public static final RegistrySupplier<class_1792> FOOTPRINT = ModItems.registerItemAfter("footprint", (class_5321<class_1761>)class_7706.field_41062, class_1802.field_38974, class_1792::new);
    public static final RegistrySupplier<TransfiniteKeyItem> TRANSFINITE_KEY = ModItems.registerItemAfter("key", (class_5321<class_1761>)class_7706.field_41062, class_1802.field_27063, TransfiniteKeyItem::new);
    public static final RegistrySupplier<HomeItem> HOME_ITEM = ModItems.registerItemAfter("fine_item", (class_5321<class_1761>)class_7706.field_41062, class_1802.field_8103, HomeItem::new, new class_1792.class_1793().method_19265(new class_4174.class_4175().method_19240().method_19242()));
    public static final RegistrySupplier<ChromaticItem> CHROMATIC_MATTER = ModItems.registerItemAfter("chromatic_matter", (class_5321<class_1761>)class_7706.field_41062, class_1802.field_38974, ChromaticItem::new, new class_1792.class_1793());
    public static final RegistrySupplier<class_1792> WHITE_MATTER = ModItems.registerItemAfter("white_matter", (class_5321<class_1761>)class_7706.field_41062, class_1802.field_38974, class_1792::new);
    public static final RegistrySupplier<class_1792> BLACK_MATTER = ModItems.registerItemAfter("black_matter", (class_5321<class_1761>)class_7706.field_41062, class_1802.field_38974, class_1792::new);
    public static final RegistrySupplier<class_1792> IRIDESCENT_STAR = ModItems.registerItemAfter("iridescent_star", (class_5321<class_1761>)class_7706.field_41062, class_1802.field_8137, GlintItem::new, new class_1792.class_1793().method_7894(class_1814.field_8907));
    public static final RegistrySupplier<? extends StarOfLangItem> STAR_OF_LANG = ModItems.registerItemAfter("star_of_lang", (class_5321<class_1761>)class_7706.field_41062, class_1802.field_8137, PlatformMethods.getStarOfLangConstructor(), new class_1792.class_1793());
    public static final RegistrySupplier<F4Item> F4 = ModItems.registerItemAfter("f4", (class_5321<class_1761>)class_7706.field_41060, class_1802.field_8674, F4Item::new, new class_1792.class_1793().method_7894(class_1814.field_8907));
    public static final RegistrySupplier<class_1792> IRIDESCENT_POTION = ModItems.registerItemAfter("iridescent_potion", (class_5321<class_1761>)class_7706.field_41061, class_1802.field_20417, s -> new IridescentPotionItem((class_1792.class_1793)s, 4), new class_1792.class_1793());
    public static final RegistrySupplier<class_1792> CHROMATIC_POTION = ModItems.registerItemAfter("chromatic_potion", (class_5321<class_1761>)class_7706.field_41061, class_1802.field_20417, s -> new IridescentPotionItem((class_1792.class_1793)s, 0), new class_1792.class_1793());

    public static <T extends class_1792> RegistrySupplier<T> register(String item, class_1792.class_1793 settings, Function<class_1792.class_1793, T> constructor) {
        return ITEMS.register(item, () -> (class_1792)constructor.apply(settings));
    }

    public static <T extends class_1792> RegistrySupplier<T> registerItemAfter(String id, class_5321<class_1761> group, class_1792 item, Function<class_1792.class_1793, T> constructor, class_1792.class_1793 settings) {
        RegistrySupplier<T> registeredItem = ModItems.register(id, ModItems.addFallbackTab(settings, group), constructor);
        PlatformMethods.addAfter(registeredItem, group, item);
        return registeredItem;
    }

    public static <T extends class_1792> RegistrySupplier<T> registerItemAfter(String id, class_5321<class_1761> group, class_1792 item, Function<class_1792.class_1793, T> constructor) {
        return ModItems.registerItemAfter(id, group, item, constructor, new class_1792.class_1793());
    }

    public static <T extends class_1792> RegistrySupplier<T> registerBlockItem(RegistrySupplier<class_2248> block, class_1792.class_1793 settings, BiFunction<class_2248, class_1792.class_1793, T> constructor) {
        return ITEMS.register(block.getId(), () -> (class_1792)constructor.apply((class_2248)block.get(), settings));
    }

    public static <T extends class_1792> RegistrySupplier<T> registerBlockItemAfter(RegistrySupplier<class_2248> block, class_5321<class_1761> group, class_1792 item, class_1792.class_1793 settings, BiFunction<class_2248, class_1792.class_1793, T> constructor) {
        RegistrySupplier<T> registeredItem = ModItems.registerBlockItem(block, ModItems.addFallbackTab(settings, group), constructor);
        PlatformMethods.addAfter(registeredItem, group, item);
        return registeredItem;
    }

    public static <T extends class_1792> RegistrySupplier<T> registerBlockItemAfter(RegistrySupplier<class_2248> block, class_5321<class_1761> group, class_1792 item, BiFunction<class_2248, class_1792.class_1793, T> constructor) {
        return ModItems.registerBlockItemAfter(block, group, item, new class_1792.class_1793(), constructor);
    }

    public static class_1792.class_1793 addFallbackTab(class_1792.class_1793 settings, class_5321<class_1761> group) {
        if (!InfinityMethods.isFabricApiLoaded("fabric-item-group-api-v1")) {
            return settings.arch$tab(group);
        }
        return settings;
    }

    public static class_1792.class_1793 createSpawnEggSettings() {
        return new class_1792.class_1793().arch$tab(class_7706.field_40205);
    }

    public static void registerModItems() {
        PlatformMethods.addAfter(IRIDESCENCE_BUCKET, (class_5321<class_1761>)class_7706.field_41060, class_1802.field_8103);
        InfinityMod.LOGGER.debug("Registering items for infinity");
        ITEMS.register();
    }
}

