/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.registry.var;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.lerariemann.infinity.block.entity.BiomeBottleBlockEntity;
import net.lerariemann.infinity.registry.var.ModStats;
import net.lerariemann.infinity.util.InfinityMethods;
import net.minecraft.class_1309;
import net.minecraft.class_174;
import net.minecraft.class_179;
import net.minecraft.class_195;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5257;
import net.minecraft.class_5258;
import net.minecraft.class_5267;
import net.minecraft.class_7923;

public class ModCriteria {
    public static DimensionOpenedCriterion DIMS_OPENED;
    public static DimensionClosedCriterion DIMS_CLOSED;
    public static WhoRemainsCriterion WHO_REMAINS;
    public static IridescentCriterion IRIDESCENT;
    public static BiomeBottleCriterion BIOME_BOTTLE;
    public static ConvertMobCriterion CONVERT_MOB;

    public static void registerCriteria() {
        DIMS_OPENED = (DimensionOpenedCriterion)class_174.method_767((class_179)new DimensionOpenedCriterion());
        DIMS_CLOSED = (DimensionClosedCriterion)class_174.method_767((class_179)new DimensionClosedCriterion());
        WHO_REMAINS = (WhoRemainsCriterion)class_174.method_767((class_179)new WhoRemainsCriterion());
        IRIDESCENT = (IridescentCriterion)class_174.method_767((class_179)new IridescentCriterion());
        BIOME_BOTTLE = (BiomeBottleCriterion)class_174.method_767((class_179)new BiomeBottleCriterion());
        CONVERT_MOB = (ConvertMobCriterion)class_174.method_767((class_179)new ConvertMobCriterion());
    }

    public static class DimensionOpenedCriterion
    extends class_4558<ScoredConditions> {
        static final class_2960 ID = InfinityMethods.getId("dims_open");

        public class_2960 method_794() {
            return ID;
        }

        public ScoredConditions conditionsFromJson(JsonObject jsonObject, class_5258 lootContextPredicate, class_5257 advancementEntityPredicateDeserializer) {
            int score = jsonObject.getAsJsonPrimitive("amount").getAsInt();
            return new ScoredConditions(lootContextPredicate, score, this.method_794());
        }

        public void trigger(class_3222 player) {
            this.method_22510(player, conditions -> conditions.test(player.method_14248().method_15025(ModStats.DIMS_OPENED_STAT)));
        }
    }

    public static class DimensionClosedCriterion
    extends class_4558<ScoredConditions> {
        static final class_2960 ID = InfinityMethods.getId("dims_closed");

        public class_2960 method_794() {
            return ID;
        }

        public ScoredConditions conditionsFromJson(JsonObject jsonObject, class_5258 lootContextPredicate, class_5257 advancementEntityPredicateDeserializer) {
            int score = jsonObject.getAsJsonPrimitive("amount").getAsInt();
            return new ScoredConditions(lootContextPredicate, score, this.method_794());
        }

        public void trigger(class_3222 player) {
            this.method_22510(player, conditions -> conditions.test(player.method_14248().method_15025(ModStats.WORLDS_DESTROYED_STAT)));
        }
    }

    public static class WhoRemainsCriterion
    extends class_4558<EmptyConditions> {
        static final class_2960 ID = InfinityMethods.getId("who_remains");

        public class_2960 method_794() {
            return ID;
        }

        public EmptyConditions conditionsFromJson(JsonObject jsonObject, class_5258 lootContextPredicate, class_5257 advancementEntityPredicateDeserializer) {
            return new EmptyConditions(lootContextPredicate, ID);
        }

        public void trigger(class_3222 player) {
            this.method_22510(player, conditions -> true);
        }
    }

    public static class IridescentCriterion
    extends class_4558<EmptyConditions> {
        static final class_2960 ID = InfinityMethods.getId("iridescence");

        public void trigger(class_3222 player, boolean willing, int level) {
            this.method_22510(player, conditions -> true);
        }

        protected EmptyConditions conditionsFromJson(JsonObject obj, class_5258 lootContextPredicate, class_5257 predicateDeserializer) {
            return new EmptyConditions(lootContextPredicate, ID);
        }

        public class_2960 method_794() {
            return ID;
        }
    }

    public static class BiomeBottleCriterion
    extends class_4558<ScoredConditions> {
        static final class_2960 ID = InfinityMethods.getId("bottle");

        public class_2960 method_794() {
            return ID;
        }

        public ScoredConditions conditionsFromJson(JsonObject jsonObject, class_5258 lootContextPredicate, class_5257 advancementEntityPredicateDeserializer) {
            int score = jsonObject.getAsJsonPrimitive("amount").getAsInt();
            return new ScoredConditions(lootContextPredicate, score, this.method_794());
        }

        public void trigger(class_3222 player, BiomeBottleBlockEntity be) {
            this.method_22510(player, conditions -> conditions.test(be.charge));
        }
    }

    public static class ConvertMobCriterion
    extends class_4558<DataConditions> {
        static final class_2960 ID = InfinityMethods.getId("convert_mob");

        public void trigger(class_3222 player, class_1309 e) {
            this.method_22510(player, conditions -> conditions.test(Integer.parseInt(class_7923.field_41177.method_10221((Object)e.method_5864()).toString())));
        }

        protected DataConditions conditionsFromJson(JsonObject obj, class_5258 playerPredicate, class_5257 predicateDeserializer) {
            return null;
        }

        public class_2960 method_794() {
            return ID;
        }
    }

    public static class DataConditions
    extends class_195 {
        private final int score;

        public DataConditions(class_5258 player, int score, class_2960 ID) {
            super(ID, player);
            this.score = score;
        }

        public boolean test(int stat) {
            return stat == this.score;
        }

        public static ScoredConditions create(int i, class_2960 ID) {
            return new ScoredConditions(class_5258.field_24388, i, ID);
        }

        public JsonObject method_807(class_5267 predicateSerializer) {
            JsonObject jsonObject = super.method_807(predicateSerializer);
            jsonObject.add("amount", (JsonElement)new JsonPrimitive((Number)this.score));
            return jsonObject;
        }
    }

    public static class ScoredConditions
    extends class_195 {
        private final int score;

        public ScoredConditions(class_5258 player, int score, class_2960 ID) {
            super(ID, player);
            this.score = score;
        }

        public boolean test(int stat) {
            return stat >= this.score;
        }

        public static ScoredConditions create(int i, class_2960 ID) {
            return new ScoredConditions(class_5258.field_24388, i, ID);
        }

        public JsonObject method_807(class_5267 predicateSerializer) {
            JsonObject jsonObject = super.method_807(predicateSerializer);
            jsonObject.add("amount", (JsonElement)new JsonPrimitive((Number)this.score));
            return jsonObject;
        }
    }

    public static class EmptyConditions
    extends class_195 {
        public EmptyConditions(class_5258 player, class_2960 ID) {
            super(ID, player);
        }

        public static EmptyConditions create(class_2960 ID) {
            return new EmptyConditions(class_5258.field_24388, ID);
        }

        public JsonObject method_807(class_5267 predicateSerializer) {
            return super.method_807(predicateSerializer);
        }
    }
}

