/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.registry.var;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.registry.registries.DeferredRegister;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.lerariemann.infinity.util.InfinityMethods;
import net.minecraft.class_5216;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6910;
import net.minecraft.class_7243;
import net.minecraft.class_7924;

public class ModDensityFunctionTypes {
    static class_5216 sampler;
    static class_5216 sampler2;
    public static final DeferredRegister<Codec<? extends class_6910>> DENSITY_FUNCTION_TYPES;

    public static <T extends class_6910> void register(String name, class_7243<T> holder) {
        DENSITY_FUNCTION_TYPES.register(name, () -> holder.comp_640());
    }

    public static void registerFunctions() {
        sampler = class_5216.method_31927((class_5819)new class_5820(0L), (int)-5, (double[])InfinityMethods.genOctaves(8));
        sampler2 = class_5216.method_31927((class_5819)new class_5820(0L), (int)-6, (double[])InfinityMethods.genOctaves(8));
        for (NonbinaryOperation.Type enum_ : NonbinaryOperation.Type.values()) {
            ModDensityFunctionTypes.register(enum_.name, enum_.codecHolder);
        }
        ModDensityFunctionTypes.register("coordinate", Coordinate.CODEC_HOLDER);
        ModDensityFunctionTypes.register("menger", Menger.CODEC_HOLDER);
        ModDensityFunctionTypes.register("skygrid", Skygrid.CODEC_HOLDER);
        ModDensityFunctionTypes.register("library", Library.CODEC_HOLDER);
        ModDensityFunctionTypes.register("classic", Classic.CODEC_HOLDER);
        DENSITY_FUNCTION_TYPES.register();
    }

    static {
        DENSITY_FUNCTION_TYPES = DeferredRegister.create((String)"infinity", (class_5321)class_7924.field_41264);
    }

    static final class NonbinaryOperation
    extends Record
    implements Nonbinary {
        private final Type type;
        private final class_6910 input;
        private final double minValue;
        private final double maxValue;

        NonbinaryOperation(Type type, class_6910 input, double minValue, double maxValue) {
            this.type = type;
            this.input = input;
            this.minValue = minValue;
            this.maxValue = maxValue;
        }

        public static NonbinaryOperation create(Type type, class_6910 input) {
            double d = input.comp_377();
            double e = NonbinaryOperation.apply(type, d);
            double f = NonbinaryOperation.apply(type, input.comp_378());
            return new NonbinaryOperation(type, input, e, f);
        }

        private static double apply(Type type, double density) {
            return switch (type.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> Math.sin(density);
                case 1 -> Math.cos(density);
                case 2 -> Math.sqrt(density);
                case 3 -> {
                    if (Math.abs(density) < 0.001) {
                        yield 1000.0 * Math.signum(density);
                    }
                    yield 1.0 / density;
                }
                case 5 -> Math.exp(density);
                case 4 -> Math.log(density);
            };
        }

        @Override
        public double apply(double density) {
            return NonbinaryOperation.apply(this.type, density);
        }

        public NonbinaryOperation apply(class_6910.class_6915 densityFunctionVisitor) {
            return NonbinaryOperation.create(this.type, this.input.method_40469(densityFunctionVisitor));
        }

        public class_7243<? extends class_6910> method_41062() {
            return this.type.codecHolder;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{NonbinaryOperation.class, "type;input;minValue;maxValue", "type", "input", "minValue", "maxValue"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{NonbinaryOperation.class, "type;input;minValue;maxValue", "type", "input", "minValue", "maxValue"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{NonbinaryOperation.class, "type;input;minValue;maxValue", "type", "input", "minValue", "maxValue"}, this, o);
        }

        public Type type() {
            return this.type;
        }

        @Override
        public class_6910 input() {
            return this.input;
        }

        public double comp_377() {
            return this.minValue;
        }

        public double comp_378() {
            return this.maxValue;
        }

        static enum Type {
            SIN("sin"),
            COS("cos"),
            SQRT("sqrt"),
            INVERT("invert"),
            LN("ln"),
            EXP("exp");

            private final String name;
            final class_7243<NonbinaryOperation> codecHolder = class_7243.method_42116((MapCodec)class_6910.field_37059.fieldOf("argument").xmap(input -> NonbinaryOperation.create(this, input), NonbinaryOperation::input));

            private Type(String name) {
                this.name = name;
            }
        }
    }

    record Coordinate(double scale, int axis) implements class_6910.class_6913
    {
        public static final class_7243<Coordinate> CODEC_HOLDER = class_7243.method_42116((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.DOUBLE.fieldOf("scale").orElse((Object)1.0).forGetter(a -> a.scale), (App)Codec.INT.fieldOf("axis").forGetter(a -> a.axis)).apply((Applicative)instance, Coordinate::new)));

        public double method_40464(class_6910.class_6912 pos) {
            if (this.axis == -1 || this.scale == 0.0) {
                return this.apply(pos);
            }
            double d = this.apply(pos) * this.scale;
            d -= Math.floor(d);
            return (d - 0.5) * 2.0 * Math.PI;
        }

        public double comp_377() {
            return -Math.PI;
        }

        public double comp_378() {
            return Math.PI;
        }

        public class_7243<? extends class_6910> method_41062() {
            return CODEC_HOLDER;
        }

        public double apply(class_6910.class_6912 pos) {
            return switch (this.axis) {
                case 1 -> pos.comp_371();
                case 2 -> pos.comp_372();
                case 3 -> pos.comp_373();
                case 0 -> Coordinate.r(pos);
                case -1 -> Math.acos((double)pos.comp_371() / Coordinate.r(pos)) * (double)(pos.comp_373() < 0 ? -1 : 1);
                default -> 0.0;
            };
        }

        static double r(class_6910.class_6912 pos) {
            double res = Math.sqrt(pos.comp_371() * pos.comp_371() + pos.comp_373() * pos.comp_373());
            return Math.max(res, 0.01);
        }
    }

    record Menger(double scale, int max_y) implements class_6910.class_6913
    {
        public static final class_7243<Menger> CODEC_HOLDER = class_7243.method_42116((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.DOUBLE.fieldOf("scale").orElse((Object)1.0).forGetter(a -> a.scale), (App)Codec.INT.fieldOf("max_y").orElse((Object)0).forGetter(a -> a.max_y)).apply((Applicative)instance, Menger::new)));

        public double method_40464(class_6910.class_6912 pos) {
            int x = pos.comp_371();
            int y = pos.comp_372();
            int z = pos.comp_373();
            return y > this.max_y || this.check(x, z) || this.check(x, y) || this.check(y, z) ? -this.scale : this.scale;
        }

        public double comp_377() {
            return -this.scale;
        }

        public double comp_378() {
            return this.scale;
        }

        public class_7243<? extends class_6910> method_41062() {
            return CODEC_HOLDER;
        }

        public boolean check(int a, int b) {
            int a1 = Math.abs(a);
            for (int b1 = Math.abs(b); a1 > 0 && b1 > 0; a1 /= 3, b1 /= 3) {
                if (a1 % 3 != 1 || b1 % 3 != 1) continue;
                return true;
            }
            return false;
        }
    }

    record Skygrid(double scale, int size, int separation) implements class_6910.class_6913
    {
        public static final class_7243<Skygrid> CODEC_HOLDER = class_7243.method_42116((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.DOUBLE.fieldOf("scale").orElse((Object)1.0).forGetter(a -> a.scale), (App)Codec.INT.fieldOf("size").orElse((Object)1).forGetter(a -> a.size), (App)Codec.INT.fieldOf("separation").orElse((Object)3).forGetter(a -> a.separation)).apply((Applicative)instance, Skygrid::new)));

        public double method_40464(class_6910.class_6912 pos) {
            int n = this.separation + this.size;
            int x = Math.abs(pos.comp_371());
            int y = Math.abs(pos.comp_372());
            int z = Math.abs(pos.comp_373());
            return x % n < this.size && y % n < this.size && z % n < this.size ? this.scale : -this.scale;
        }

        public double comp_377() {
            return -this.scale;
        }

        public double comp_378() {
            return this.scale;
        }

        public class_7243<? extends class_6910> method_41062() {
            return CODEC_HOLDER;
        }
    }

    public static enum Library implements TileableStructure
    {
        INSTANCE;

        static final class_7243<Library> CODEC_HOLDER;

        @Override
        public int size(int axis) {
            return axis == 1 ? 16 : 15;
        }

        @Override
        public boolean testBlock(int x, int y, int z) {
            int max_xz = Math.max(Math.abs(7 - x), Math.abs(7 - z));
            int min_xz = Math.min(Math.abs(7 - x), Math.abs(7 - z));
            if (max_xz == 7) {
                return y >= 3 || y == 0 || min_xz > 1;
            }
            if (max_xz < 2) {
                return true;
            }
            if (max_xz == 2 && min_xz == 1) {
                return true;
            }
            return y == 0;
        }

        public class_7243<? extends class_6910> method_41062() {
            return CODEC_HOLDER;
        }

        static {
            CODEC_HOLDER = class_7243.method_42116((MapCodec)MapCodec.unit((Object)INSTANCE));
        }
    }

    public record Classic(int sealevel) implements class_6910.class_6913
    {
        public static final class_7243<Classic> CODEC_HOLDER = class_7243.method_42116((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("sealevel").orElse((Object)64).forGetter(a -> a.sealevel)).apply((Applicative)instance, Classic::new)));

        public double method_40464(class_6910.class_6912 pos) {
            return pos.comp_372() < this.sample(pos.comp_371(), pos.comp_373()) ? 1.0 : -1.0;
        }

        int sample(int x, int z) {
            double heightResult;
            double heightLow = sampler.method_27406((double)x * 1.3, 0.0, (double)z * 1.3) * 6.0 - 6.0;
            double heightHigh = sampler.method_27406((double)x * 1.3, 200.0, (double)z * 1.3) * 7.2 + 6.0;
            if (sampler2.method_27406((double)x, 0.0, (double)z) > 0.0) {
                heightHigh = heightLow;
            }
            if ((heightResult = Math.max(heightLow, heightHigh) / 2.0) < 0.0) {
                heightResult *= 0.8;
            }
            return this.sealevel + (int)heightResult;
        }

        public double comp_377() {
            return -1.0;
        }

        public double comp_378() {
            return 1.0;
        }

        public class_7243<? extends class_6910> method_41062() {
            return CODEC_HOLDER;
        }
    }

    static interface TileableStructure
    extends class_6910.class_6913 {
        public int size(int var1);

        public boolean testBlock(int var1, int var2, int var3);

        default public int normalize(int x, int axis) {
            int a = Math.abs(x < 0 ? x + 1 : x) % this.size(axis);
            return x < 0 ? this.size(axis) - 1 - a : a;
        }

        default public double method_40464(class_6910.class_6912 pos) {
            int z;
            int y;
            int x = this.normalize(pos.comp_371(), 0);
            return this.testBlock(x, y = this.normalize(pos.comp_372(), 1), z = this.normalize(pos.comp_373(), 2)) ? 1.0 : -1.0;
        }

        default public double comp_377() {
            return -1.0;
        }

        default public double comp_378() {
            return 1.0;
        }
    }

    static interface Nonbinary
    extends class_6910 {
        public class_6910 input();

        default public double method_40464(class_6910.class_6912 pos) {
            return this.apply(this.input().method_40464(pos));
        }

        default public void method_40470(double[] densities, class_6910.class_6911 applier) {
            this.input().method_40470(densities, applier);
            for (int i = 0; i < densities.length; ++i) {
                densities[i] = this.apply(densities[i]);
            }
        }

        public double apply(double var1);
    }
}

