/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.registry.var;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.registry.registries.DeferredRegister;
import net.lerariemann.infinity.iridescence.Iridescence;
import net.lerariemann.infinity.registry.core.ModBlocks;
import net.lerariemann.infinity.util.InfinityMethods;
import net.lerariemann.infinity.util.core.RandomProvider;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2399;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_6686;
import net.minecraft.class_7243;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class ModMaterialRules {
    public static final DeferredRegister<Codec<? extends class_6686.class_6708>> MATERIAL_RULES = DeferredRegister.create((String)"infinity", (class_5321)class_7924.field_41205);

    static int normalize(int x, int size) {
        int a = Math.abs(x < 0 ? x + 1 : x) % size;
        return x < 0 ? size - 1 - a : a;
    }

    public static <R extends class_6686.class_6708, T extends class_7243<R>> void register(String name, T holder) {
        MATERIAL_RULES.register(name, () -> holder.comp_640());
    }

    public static void registerRules() {
        ModMaterialRules.register("chaos", RandomBlockMaterialRule.CODEC);
        ModMaterialRules.register("colored_chaos", RandomColoredBlock.Rule.CODEC);
        ModMaterialRules.register("library", Library.Rule.CODEC);
        ModMaterialRules.register("backrooms", Backrooms.Rule.CODEC);
        ModMaterialRules.register("nexus", Nexus.Rule.CODEC);
        ModMaterialRules.register("perfection", Perfection.Rule.CODEC);
        MATERIAL_RULES.register();
    }

    public static enum RandomBlockMaterialRule implements class_6686.class_6708
    {
        INSTANCE;

        static final class_7243<RandomBlockMaterialRule> CODEC;
        static RandomProvider PROVIDER;

        public static void setProvider(RandomProvider p) {
            PROVIDER = p;
        }

        public class_7243<? extends class_6686.class_6708> method_39061() {
            return CODEC;
        }

        public class_6686.class_6715 apply(class_6686.class_6694 materialRuleContext) {
            return new RandomBlockStateRule(PROVIDER);
        }

        static {
            CODEC = class_7243.method_42116((MapCodec)MapCodec.unit((Object)((Object)INSTANCE)));
        }
    }

    public record RandomColoredBlock(String str) implements class_6686.class_6715
    {
        public class_2680 tryApply(int i, int j, int k) {
            class_2680 st;
            double d = InfinityMethods.sampler.method_27406((double)i, (double)j, (double)k);
            if ((st = Iridescence.getRandomColorBlock(d -= Math.floor(d), this.str).method_9564()).method_28498((class_2769)class_2741.field_12514)) {
                st = (class_2680)st.method_11657((class_2769)class_2741.field_12514, (Comparable)Boolean.TRUE);
            }
            return st;
        }

        record Rule(String str) implements class_6686.class_6708
        {
            static final class_7243<Rule> CODEC = class_7243.method_42116((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("block_type").orElse((Object)"concrete").forGetter(a -> a.str)).apply((Applicative)instance, Rule::new)));

            public class_7243<? extends class_6686.class_6708> method_39061() {
                return CODEC;
            }

            public class_6686.class_6715 apply(class_6686.class_6694 materialRuleContext) {
                return new RandomColoredBlock(this.str);
            }
        }
    }

    public static class Library
    implements class_6686.class_6715 {
        static final class_2680 floor = class_2246.field_10119.method_9564();
        static final class_2680 wall = ((class_2248)ModBlocks.BOOK_BOX.get()).method_9564();
        static final class_2680 decor = class_2246.field_10171.method_9564();
        static final class_2680 glass = class_2246.field_10137.method_9564();
        static final class_2680 column = class_2246.field_10161.method_9564();
        static final class_2680 air = class_2246.field_10124.method_9564();

        int normalize(int x, int size) {
            int a = Math.abs(x < 0 ? x + 1 : x) % size;
            return x < 0 ? size - 1 - a : a;
        }

        public class_2680 tryApply(int i, int j, int k) {
            int x = this.normalize(i, 15);
            int y = this.normalize(j, 16);
            int z = this.normalize(k, 15);
            int max_xz = Math.max(Math.abs(7 - x), Math.abs(7 - z));
            int min_xz = Math.min(Math.abs(7 - x), Math.abs(7 - z));
            if (max_xz == 7) {
                if (min_xz < 2) {
                    if (y == 0) {
                        return floor;
                    }
                    if (y < 4) {
                        return air;
                    }
                }
                return wall;
            }
            if (max_xz < 2) {
                return (x + z) % 2 == 1 ? wall : column;
            }
            if (max_xz == 2 && min_xz == 1) {
                if (j == 0) {
                    return floor;
                }
                class_2350 d = x == 5 ? class_2350.field_11039 : (x == 9 ? class_2350.field_11034 : (z == 5 ? class_2350.field_11043 : class_2350.field_11035));
                return (class_2680)class_2246.field_9983.method_9564().method_11657((class_2769)class_2399.field_11253, (Comparable)d);
            }
            if (y == 0) {
                if (max_xz == 4) {
                    if (min_xz == 4) {
                        return decor;
                    }
                    if (min_xz == 0 && j > 0) {
                        return glass;
                    }
                }
                return floor;
            }
            return air;
        }

        static enum Rule implements class_6686.class_6708
        {
            INSTANCE;

            static final class_7243<Rule> CODEC;

            public class_7243<? extends class_6686.class_6708> method_39061() {
                return CODEC;
            }

            public class_6686.class_6715 apply(class_6686.class_6694 materialRuleContext) {
                return new Library();
            }

            static {
                CODEC = class_7243.method_42116((MapCodec)MapCodec.unit((Object)((Object)INSTANCE)));
            }
        }
    }

    public static class Backrooms
    implements class_6686.class_6715 {
        static final class_2680 floor = class_2246.field_10556.method_9564();
        static final class_2680 wall = class_2246.field_10467.method_9564();
        static final class_2680 light = class_2246.field_37572.method_9564();
        static final class_2680 ceiling = class_2246.field_10467.method_9564();
        static final class_2680 air = class_2246.field_10124.method_9564();
        static final class_2680 filler = class_2246.field_10540.method_9564();

        int normalize(int x, int size) {
            int a = Math.abs(x < 0 ? x + 1 : x) % size;
            return x < 0 ? size - 1 - a : a;
        }

        int anti_normalize(int x, int size) {
            return Math.abs(x < 0 ? x + 1 : x) / size;
        }

        /*
         * Unable to fully structure code
         */
        public class_2680 tryApply(int i, int j, int k) {
            size_xz = 15;
            halfsize_xz = 7;
            x = this.normalize(i, size_xz);
            y = this.normalize(j - 1, 16);
            z = this.normalize(k, size_xz);
            xrel = Math.abs(halfsize_xz - x);
            zrel = Math.abs(halfsize_xz - z);
            max_xz = Math.max(xrel, zrel);
            min_xz = Math.min(xrel, zrel);
            v0 = isXMax = max_xz == xrel;
            if (max_xz < 3 || min_xz > 3 || y > 6) ** GOTO lbl-1000
            v1 = 2 * this.anti_normalize(i, size_xz) - class_3532.method_17822((double)i) * class_3532.method_17822((double)(halfsize_xz - x)) * (isXMax != false ? 1 : 0);
            v2 = this.anti_normalize(j - 1, 16);
            v3 = 2 * this.anti_normalize(k, size_xz);
            v4 = class_3532.method_17822((double)k) * class_3532.method_17822((double)(halfsize_xz - z));
            v5 = isXMax != false ? 0 : 1;
            if ((double)(class_3532.method_15371((int)v1, (int)v2, (int)(v3 - v4 * v5)) & 15L) / 15.0 > 0.3) {
                v6 = true;
            } else lbl-1000:
            // 2 sources

            {
                v6 = isOpen = false;
            }
            if (isOpen || min_xz <= 3 && y <= 6 && (i == 0 || k == 0)) {
                if (min_xz == 3) {
                    return Backrooms.wall;
                }
                if (y == 0) {
                    return Backrooms.floor;
                }
                if (y == 6) {
                    if (min_xz == 0 && max_xz % 3 == 0) {
                        return Backrooms.light;
                    }
                    return Backrooms.ceiling;
                }
                return Backrooms.air;
            }
            if (max_xz <= 3 && y <= 6) {
                if (max_xz == 3) {
                    return Backrooms.wall;
                }
                if (y == 0) {
                    return Backrooms.floor;
                }
                if (y == 6) {
                    if (max_xz == 0) {
                        return Backrooms.light;
                    }
                    return Backrooms.ceiling;
                }
                return Backrooms.air;
            }
            return Backrooms.filler;
        }

        static enum Rule implements class_6686.class_6708
        {
            INSTANCE;

            static final class_7243<Rule> CODEC;

            public class_7243<? extends class_6686.class_6708> method_39061() {
                return CODEC;
            }

            public class_6686.class_6715 apply(class_6686.class_6694 materialRuleContext) {
                return new Backrooms();
            }

            static {
                CODEC = class_7243.method_42116((MapCodec)MapCodec.unit((Object)((Object)INSTANCE)));
            }
        }
    }

    public static class Nexus
    implements class_6686.class_6715 {
        static final class_2680 floor = class_2246.field_10360.method_9564();
        static final class_2680 wall = class_2246.field_10161.method_9564();
        static final class_2680 column1 = class_2246.field_10431.method_9564();
        static final class_2680 column2 = (class_2680)class_2246.field_10431.method_9564().method_11657((class_2769)class_2741.field_12496, (Comparable)class_2350.class_2351.field_11048);
        static final class_2680 stair1 = (class_2680)class_2246.field_10563.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11043);
        static final class_2680 stair2 = (class_2680)class_2246.field_10563.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11035);
        static final class_2680 stair3 = (class_2680)((class_2680)class_2246.field_10563.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11043)).method_11657((class_2769)class_2741.field_12518, (Comparable)class_2760.field_12619);
        static final class_2680 stair4 = (class_2680)((class_2680)class_2246.field_10563.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11035)).method_11657((class_2769)class_2741.field_12518, (Comparable)class_2760.field_12619);
        static final class_2680 light1 = (class_2680)class_2246.field_10009.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11035);
        static final class_2680 light2 = (class_2680)class_2246.field_10009.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11043);
        static final class_2680 light3 = class_2246.field_10171.method_9564();
        static final class_2680 air = class_2246.field_10124.method_9564();

        public class_2680 tryApply(int i, int j, int k) {
            int x = ModMaterialRules.normalize(i, 8);
            int y = j - 50;
            int z = ModMaterialRules.normalize(k, 16);
            if (y == -2) {
                return class_2246.field_9987.method_9564();
            }
            switch (y) {
                case -1: 
                case 9: {
                    if (!(z != 10 && z != 6 || x != 0 && x != 4)) {
                        return light3;
                    }
                    return y == -1 ? floor : wall;
                }
                case 0: {
                    return switch (z) {
                        case 0, 1, 2, 14, 15 -> wall;
                        case 3 -> stair1;
                        case 13 -> stair2;
                        default -> air;
                    };
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    if (z == 0) {
                        return wall;
                    }
                    if (z == 1 || z == 15) {
                        if (x == 5 || x == 7) {
                            return column1;
                        }
                        if (x == 6) {
                            if (y != 3) {
                                return wall;
                            }
                            return z == 1 ? light1 : light2;
                        }
                    }
                    return air;
                }
                case 6: {
                    if (z == 0) {
                        return wall;
                    }
                    return z == 1 || z == 15 ? column2 : air;
                }
                case 7: {
                    return switch (z) {
                        case 2 -> stair3;
                        case 14 -> stair4;
                        case 0, 1, 15 -> wall;
                        default -> air;
                    };
                }
                case 8: {
                    return switch (z) {
                        case 0, 1, 2, 3, 13, 14, 15 -> wall;
                        case 4 -> stair3;
                        case 12 -> stair4;
                        default -> air;
                    };
                }
            }
            return air;
        }

        static enum Rule implements class_6686.class_6708
        {
            INSTANCE;

            static final class_7243<Rule> CODEC;

            public class_7243<? extends class_6686.class_6708> method_39061() {
                return CODEC;
            }

            public class_6686.class_6715 apply(class_6686.class_6694 materialRuleContext) {
                return new Nexus();
            }

            static {
                CODEC = class_7243.method_42116((MapCodec)MapCodec.unit((Object)((Object)INSTANCE)));
            }
        }
    }

    public static class Perfection
    implements class_6686.class_6715 {
        static final class_2680 cobblestone = class_2246.field_10445.method_9564();
        static final class_2680 lightNorth = (class_2680)class_2246.field_10099.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11043);
        static final class_2680 lightSouth = (class_2680)class_2246.field_10099.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11035);
        static final class_2680 lightEast = (class_2680)class_2246.field_10099.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11034);
        static final class_2680 lightWest = (class_2680)class_2246.field_10099.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11039);
        static final class_2680 glass = class_2246.field_10033.method_9564();
        static final class_2680 air = class_2246.field_10124.method_9564();

        public class_2680 tryApply(int i, int j, int k) {
            int x = ModMaterialRules.normalize(i, 10);
            int y = j - 50;
            int z = ModMaterialRules.normalize(k, 10);
            if (y == -2) {
                return class_2246.field_9987.method_9564();
            }
            switch (y) {
                case -1: {
                    return cobblestone;
                }
                case 4: {
                    if (!(z != 7 && z != 6 && z != 0 && z != 9 || x != 0 && x != 9 && x != 2 && x != 3)) {
                        return glass;
                    }
                    return cobblestone;
                }
                case 3: {
                    if (z == 2 || z == 3 || z == 4) {
                        return cobblestone;
                    }
                    if (z == 1) {
                        if (x == 1) {
                            return lightNorth;
                        }
                    } else if (z == 5 && x == 1) {
                        return lightSouth;
                    }
                    if (x == 7 || x == 6 || x == 5) {
                        return cobblestone;
                    }
                    if (x == 8) {
                        if (z == 8) {
                            return lightEast;
                        }
                    } else if (x == 4 && z == 8) {
                        return lightWest;
                    }
                    return air;
                }
                case 0: 
                case 1: 
                case 2: {
                    if (x == 7 || x == 6 || x == 5) {
                        if (z == 7 || z == 8 || z == 9) {
                            return air;
                        }
                        return cobblestone;
                    }
                    if (z == 2 || z == 3 || z == 4 || z == 12 || z == 13 || z == 14) {
                        if (x == 0 || x == 2 || x == 1) {
                            return air;
                        }
                        return cobblestone;
                    }
                    return air;
                }
            }
            return air;
        }

        static enum Rule implements class_6686.class_6708
        {
            INSTANCE;

            static final class_7243<Rule> CODEC;

            public class_7243<? extends class_6686.class_6708> method_39061() {
                return CODEC;
            }

            public class_6686.class_6715 apply(class_6686.class_6694 materialRuleContext) {
                return new Perfection();
            }

            static {
                CODEC = class_7243.method_42116((MapCodec)MapCodec.unit((Object)((Object)INSTANCE)));
            }
        }
    }

    public record RandomBlockStateRule(RandomProvider prov) implements class_6686.class_6715
    {
        public class_2680 tryApply(int i, int j, int k) {
            class_2680 st;
            long seed = class_3532.method_15371((int)i, (int)j, (int)k);
            double d = (double)(seed & 0xFFFL) / 4095.0;
            if ((st = ((class_2248)class_7923.field_41175.method_10223(new class_2960(this.prov.randomName(d -= Math.floor(d), "full_blocks_worldgen")))).method_9564()).method_28498((class_2769)class_2741.field_12514)) {
                st = (class_2680)st.method_11657((class_2769)class_2741.field_12514, (Comparable)Boolean.TRUE);
            }
            return st;
        }
    }
}

