/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.registry.var;

import dev.architectury.platform.Platform;
import java.nio.file.Path;
import java.util.ArrayList;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.lerariemann.infinity.access.InfinityOptionsAccess;
import net.lerariemann.infinity.access.WorldRendererAccess;
import net.lerariemann.infinity.iridescence.Iridescence;
import net.lerariemann.infinity.item.F4Item;
import net.lerariemann.infinity.options.InfinityOptions;
import net.lerariemann.infinity.registry.core.ModComponentTypes;
import net.lerariemann.infinity.registry.core.ModItems;
import net.lerariemann.infinity.util.InfinityMethods;
import net.lerariemann.infinity.util.PlatformMethods;
import net.lerariemann.infinity.util.core.CommonIO;
import net.lerariemann.infinity.util.loading.DimensionGrabber;
import net.lerariemann.infinity.util.loading.ShaderLoader;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_634;

public class ModPayloads {
    public static final class_2960 WORLD_ADD = InfinityMethods.getId("reload_worlds");
    public static final class_2960 SHADER_RELOAD = InfinityMethods.getId("reload_shader");
    public static final class_2960 STARS_RELOAD = InfinityMethods.getId("reload_stars");
    public static final class_2960 UPDATE_F4 = InfinityMethods.getId("update_f4");
    public static final class_2960 DEPLOY_F4 = InfinityMethods.getId("deploy_f4");
    public static final class_2960 UPLOAD_JUKEBOXES = InfinityMethods.getId("upload_jukeboxes");
    public static boolean resourcesReloaded = Path.of(String.valueOf(Platform.getGameFolder()) + "/resourcepacks/infinity/assets/infinity/shaders", new String[0]).toFile().exists();

    public static class_2540 buildPacket(class_3218 destination, class_3222 player) {
        return ModPayloads.buildPacket(destination, Iridescence.shouldApplyShader((class_1657)player));
    }

    public static class_2540 buildPacket(class_3218 destination, boolean bl) {
        class_2540 buf = PlatformMethods.createPacketByteBufs();
        buf.writeBoolean(bl);
        if (destination == null) {
            buf.method_10794(new class_2487());
        } else {
            buf.method_10794(((InfinityOptionsAccess)destination).infinity$getOptions().data());
        }
        return buf;
    }

    public static void sendReloadPacket(class_3222 player, class_3218 world) {
        ServerPlayNetworking.send((class_3222)player, (class_2960)SHADER_RELOAD, (class_2540)ModPayloads.buildPacket(world, player));
    }

    public static void receiveShader(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        if (buf.readBoolean()) {
            client.execute(() -> ShaderLoader.reloadShaders(client, true, true));
            return;
        }
        InfinityOptions options = new InfinityOptions(buf.method_10798());
        ((InfinityOptionsAccess)client).infinity$setOptions(options);
        class_2487 shader = options.getShader();
        boolean bl = shader.method_33133();
        if (bl) {
            client.execute(() -> ShaderLoader.reloadShaders(client, false, false));
        } else {
            client.execute(() -> {
                CommonIO.write(shader, ShaderLoader.shaderDir(client), "current.json");
                ShaderLoader.reloadShaders(client, true, false);
                if (!resourcesReloaded) {
                    client.method_1521();
                    resourcesReloaded = true;
                }
            });
        }
    }

    public static void receiveStars(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        ((WorldRendererAccess)client.field_1769).infinity$setNeedsStars(true);
    }

    public static void registerC2SPacketsReceivers() {
        ServerPlayNetworking.registerGlobalReceiver(F4UpdatingValuesPacket.type, (packet, player, responseSender) -> {
            class_1799 st = player.method_31548().method_5438(packet.slot).method_7972();
            if (st.method_31574((class_1792)ModItems.F4.get())) {
                class_2487 nbt = st.method_7969();
                if (nbt == null) {
                    nbt = new class_2487();
                }
                nbt.method_10569(ModComponentTypes.SIZE_X, packet.width);
                nbt.method_10569(ModComponentTypes.SIZE_Y, packet.height);
                st.method_7980(nbt);
                player.method_31548().method_5447(packet.slot, st);
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(F4DeployingPacket.type, (packet, player, responseSender) -> {
            class_1271<class_1799> result = F4Item.deploy((class_1937)player.method_51469(), (class_1657)player, class_1268.field_5808);
            player.method_6122(class_1268.field_5808, (class_1799)result.method_5466());
        });
    }

    public static void registerS2CPacketsReceivers() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)WORLD_ADD, (client, handler, buf, responseSender) -> {
            class_2960 id = buf.method_10810();
            class_2487 optiondata = buf.method_10798();
            int i = buf.readInt();
            ArrayList<class_2960> biomeids = new ArrayList<class_2960>();
            ArrayList<class_2487> biomes = new ArrayList<class_2487>();
            for (int j = 0; j < i; ++j) {
                biomeids.add(buf.method_10810());
                biomes.add(buf.method_10798());
            }
            client.execute(() -> new DimensionGrabber(client.method_1562().method_29091()).grab_for_client(id, optiondata, biomeids, biomes));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SHADER_RELOAD, ModPayloads::receiveShader);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)STARS_RELOAD, ModPayloads::receiveStars);
    }

    public static class F4UpdatingValuesPacket
    implements FabricPacket {
        int slot;
        int width;
        int height;
        public static PacketType<F4UpdatingValuesPacket> type = PacketType.create((class_2960)UPDATE_F4, buf -> new F4UpdatingValuesPacket(buf.readInt(), buf.readInt(), buf.readInt()));

        public F4UpdatingValuesPacket(int s, int w, int h) {
            this.slot = s;
            this.width = w;
            this.height = h;
        }

        public void write(class_2540 buf) {
            buf.writeInt(this.slot);
            buf.writeInt(this.width);
            buf.writeInt(this.height);
        }

        public PacketType<?> getType() {
            return type;
        }
    }

    public static class F4DeployingPacket
    implements FabricPacket {
        public static PacketType<F4DeployingPacket> type = PacketType.create((class_2960)DEPLOY_F4, buf -> new F4DeployingPacket());

        public void write(class_2540 buf) {
        }

        public PacketType<?> getType() {
            return type;
        }
    }
}

