/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.lerariemann.infinity.registry.core.ModStructureTypes;
import net.lerariemann.infinity.structure.LetterPiece;
import net.lerariemann.infinity.util.var.TextData;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2902;
import net.minecraft.class_3195;
import net.minecraft.class_3443;
import net.minecraft.class_4651;
import net.minecraft.class_5819;
import net.minecraft.class_5868;
import net.minecraft.class_6122;
import net.minecraft.class_6626;
import net.minecraft.class_7151;

public class TextStructure
extends class_3195 {
    public static final MapCodec<TextStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TextStructure.method_42697((RecordCodecBuilder.Instance)instance), (App)Codec.STRING.fieldOf("text").forGetter(a -> a.text), (App)class_4651.field_24937.fieldOf("block").forGetter(a -> a.block), (App)Codec.INT.fieldOf("polarization").orElse((Object)2).forGetter(a -> a.pol.id), (App)Codec.STRING.fieldOf("direction").orElse((Object)"random").forGetter(a -> a.dir), (App)Codec.INT.fieldOf("char_spacing").orElse((Object)1).forGetter(a -> a.char_spacing), (App)Codec.INT.fieldOf("line_spacing").orElse((Object)1).forGetter(a -> a.line_spacing), (App)class_6122.field_31540.fieldOf("y").forGetter(a -> a.y_provider)).apply((Applicative)instance, TextStructure::new));
    String text;
    class_4651 block;
    String dir;
    int line_spacing;
    int char_spacing;
    class_6122 y_provider;
    TextData.Polarization pol;

    TextStructure(class_3195.class_7302 config, String text, class_4651 block, int pol, String dir, int line_spacing, int char_spacing, class_6122 y_provider) {
        super(config);
        this.text = text;
        this.block = block;
        this.dir = dir;
        this.pol = TextData.Polarization.of(pol);
        this.line_spacing = line_spacing;
        this.char_spacing = char_spacing;
        this.y_provider = y_provider;
    }

    public class_2350 getDir(class_3195.class_7149 context) {
        return switch (this.dir) {
            case "N" -> class_2350.field_11043;
            case "S" -> class_2350.field_11035;
            case "W" -> class_2350.field_11039;
            case "E" -> class_2350.field_11034;
            default -> class_2350.class_2353.field_11062.method_10183((class_5819)context.comp_566());
        };
    }

    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        return TextStructure.method_41612((class_3195.class_7149)context, (class_2902.class_2903)class_2902.class_2903.field_13194, collector -> this.addPieces((class_6626)collector, context));
    }

    public class_7151<?> method_41618() {
        return (class_7151)ModStructureTypes.TEXT.get();
    }

    private void addPieces(class_6626 collector, class_3195.class_7149 context) {
        class_2338 centerPos = context.comp_568().method_8323().method_10069(8, 0, 8);
        int new_y = this.y_provider.method_35391((class_5819)context.comp_566(), new class_5868(context.comp_562(), context.comp_569()));
        centerPos = centerPos.method_10086(new_y - centerPos.method_10264());
        int maxsize = 119;
        TextData data = TextData.genData(this.char_spacing, 2 * maxsize, this.text);
        int line_height = 8 + this.line_spacing;
        int length = Math.min(2 * maxsize, data.longest_line());
        int height = Math.min(2 * maxsize, line_height * data.getLineCount());
        class_2350 dir = this.getDir(context);
        int ori = TextData.getOri(this.pol, dir);
        for (int i = 0; i < data.getLineCount(); ++i) {
            int line;
            for (int j = 0; j < data.getLineLen(i) && (line = -height / 2 + i * line_height) <= maxsize; ++j) {
                int len = -length / 2 + data.offsetMap().get(i).get(j);
                List<Integer> lst = TextData.storage.get(data.charMap().get(i).get(j));
                if (lst == null) continue;
                class_2338 letterOrigin = TextData.mutate(centerPos, ori, line, len);
                collector.method_35462((class_3443)LetterPiece.of(letterOrigin, ori, lst, this.block));
            }
        }
    }
}

