/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.util;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import dev.architectury.platform.Platform;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.access.Timebombable;
import net.lerariemann.infinity.block.entity.TintableBlockEntity;
import net.lerariemann.infinity.registry.core.ModComponentTypes;
import net.lerariemann.infinity.registry.core.ModItems;
import net.lerariemann.infinity.util.BackportMethods;
import net.lerariemann.infinity.util.core.RandomProvider;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5216;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6880;

public interface InfinityMethods {
    public static final String ofRandomDim = "infinity:random";
    public static final class_5216 sampler = class_5216.method_31927((class_5819)new class_5820(0L), (int)-5, (double[])InfinityMethods.genOctaves(2));

    public static double[] genOctaves(int octaves) {
        double[] a = new double[octaves];
        Arrays.fill(a, 1.0);
        return a;
    }

    public static double sample(class_2338 pos) {
        return sampler.method_27406((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
    }

    public static class_2960 getId(String value) {
        return class_2960.method_43902((String)"infinity", (String)value);
    }

    public static class_2960 getDimId(long value) {
        return InfinityMethods.getId("generated_" + value);
    }

    public static boolean isInfinity(class_1937 w) {
        return InfinityMethods.isInfinity((class_5321<class_1937>)w.method_27983());
    }

    public static boolean isInfinity(class_5321<class_1937> key) {
        return key.method_29177().method_12836().equals("infinity");
    }

    public static boolean isBiomeInfinity(class_1936 world, class_2338 pos) {
        AtomicBoolean bl = new AtomicBoolean(false);
        world.method_23753(pos).method_40230().ifPresent(key -> bl.set(key.method_29177().method_12836().equals("infinity")));
        return bl.get();
    }

    public static boolean isBiomeInfinity(class_6880<class_1959> b) {
        return ((class_5321)b.method_40230().get()).method_29177().method_12836().equals("infinity");
    }

    public static boolean isBiomeInfinity(class_1922 world, class_2338 pos) {
        if (world instanceof class_1936) {
            class_1936 acc = (class_1936)world;
            return InfinityMethods.isBiomeInfinity(acc, pos);
        }
        return Platform.isFabric() && world.hasBiomes() && world.getBiomeFabric(pos) instanceof class_6880 && InfinityMethods.isBiomeInfinity((class_6880<class_1959>)world.getBiomeFabric(pos));
    }

    public static boolean isFabricApiLoaded(String modID) {
        if (Platform.isFabric()) {
            return Platform.isModLoaded((String)modID.replace("_", "-"));
        }
        return Platform.isModLoaded((String)modID.replace("-", "_"));
    }

    public static double sample(int x, int y, int z) {
        return sampler.method_27406((double)x, (double)y, (double)z);
    }

    public static int properMod(int a, int b) {
        int res = a % b;
        return res >= 0 ? res : b + res;
    }

    public static void sendUnexpectedError(class_3222 player, String type) {
        player.method_43496((class_2561)class_2561.method_43471((String)("error.infinity." + type + ".unexpected")));
    }

    public static class_2960 dimTextToId(String text) {
        if (text.equals("abatised redivides")) {
            return class_1937.field_25181.method_29177();
        }
        if (text.isEmpty()) {
            return InfinityMethods.getId("missingno");
        }
        String easterId = InfinityMod.provider.easterizer.getAsEaster(text);
        if (easterId != null) {
            return InfinityMethods.getId(easterId);
        }
        return InfinityMethods.getDimId(InfinityMethods.getDimensionSeed(text));
    }

    public static boolean isTimebombed(class_3218 world) {
        return ((Timebombable)world).infinity$isTimebombed();
    }

    public static boolean dimExists(class_3218 world) {
        return world != null && !InfinityMethods.isTimebombed(world);
    }

    public static long getDimensionSeed(String text) {
        HashCode f = Hashing.sha256().hashString((CharSequence)(text + InfinityMod.provider.salt), StandardCharsets.UTF_8);
        return InfinityMethods.longArithmeticEnabled() ? f.asLong() & Long.MAX_VALUE : (long)(f.asInt() & Integer.MAX_VALUE);
    }

    public static long getNumericFromId(class_2960 id) {
        long i;
        String dimensionName = id.method_12832();
        String numericId = dimensionName.substring(dimensionName.lastIndexOf("_") + 1);
        try {
            i = Long.parseLong(numericId);
        }
        catch (Exception e) {
            i = InfinityMethods.getDimensionSeed(numericId);
        }
        return i;
    }

    private static float bookBoxSample(class_2338 pos, int offset) {
        return class_3532.method_15363((float)(0.5f * (1.0f + (float)sampler.method_27406((double)(4 * pos.method_10263()), (double)(4 * (pos.method_10264() + offset)), (double)(4 * pos.method_10260())))), (float)0.0f, (float)1.0f);
    }

    public static int getBookBoxColor(class_2680 state, class_1920 world, class_2338 pos, int tintIndex) {
        if (pos != null) {
            float r = InfinityMethods.bookBoxSample(pos, -1000);
            float g = InfinityMethods.bookBoxSample(pos, 0);
            float b = InfinityMethods.bookBoxSample(pos, 1000);
            return class_3532.method_15353((float)r, (float)g, (float)b);
        }
        return 0xFFFFFF;
    }

    public static int getOverlayColorFromComponents(class_1799 stack, int layer) {
        if (stack.method_7969() != null) {
            if (layer == 1) {
                if (stack.method_31574((class_1792)ModItems.TRANSFINITE_KEY.get())) {
                    return stack.method_7969().method_10550(ModComponentTypes.COLOR);
                }
                if (stack.method_31574((class_1792)ModItems.BIOME_BOTTLE_ITEM.get())) {
                    return stack.method_7969().method_10562("BlockEntityTag").method_10550("Color");
                }
                if (stack.method_31574((class_1792)ModItems.F4.get())) {
                    return BackportMethods.getOrDefaultInt(stack, ModComponentTypes.COLOR, 10879231);
                }
            } else if (stack.method_31574((class_1792)ModItems.CHROMATIC_MATTER.get()) || stack.method_31574((class_1792)ModItems.CHROMATIC_WOOL.get()) || stack.method_31574((class_1792)ModItems.CHROMATIC_CARPET.get())) {
                return stack.method_7969().method_10550(ModComponentTypes.COLOR);
            }
        }
        return 0xFFFFFF;
    }

    public static int getPortalItemColor(class_1799 stack, int layer) {
        return 65535;
    }

    public static int getBlockEntityColor(class_2680 state, class_1920 world, class_2338 pos, int tintIndex) {
        class_2586 blockEntity;
        if (world != null && pos != null && (blockEntity = world.method_8321(pos)) instanceof TintableBlockEntity) {
            TintableBlockEntity be = (TintableBlockEntity)blockEntity;
            Integer j = be.getTint();
            return j & 0xFFFFFF;
        }
        return 0xFFFFFF;
    }

    public static int getKeyColorFromId(class_2960 id) {
        if (id.method_12836().equals("infinity") && id.method_12832().contains("generated_")) {
            return Math.toIntExact(InfinityMethods.getNumericFromId(id));
        }
        return 0;
    }

    public static long getRandomSeed(Random random) {
        return InfinityMethods.longArithmeticEnabled() ? random.nextLong() : (long)random.nextInt();
    }

    public static long getRandomSeed(class_5819 random) {
        return InfinityMethods.longArithmeticEnabled() ? random.method_43055() : (long)random.method_43054();
    }

    public static class_2960 getRandomId(Random random) {
        return InfinityMethods.getDimId(InfinityMethods.getRandomSeed(random));
    }

    public static class_2960 getRandomId(class_5819 random) {
        return InfinityMethods.getDimId(InfinityMethods.getRandomSeed(random));
    }

    public static class_5250 getDimensionNameAsText(class_2960 dimension) {
        String name = dimension.toString();
        if (name.contains("infinity:generated_")) {
            return class_2561.method_43471((String)"tooltip.infinity.key.generated").method_27693(name.replace("infinity:generated_", ""));
        }
        if (name.equals(ofRandomDim)) {
            return class_2561.method_43471((String)"tooltip.infinity.key.randomise");
        }
        return class_2561.method_48321((String)class_156.method_646((String)"dimension", (class_2960)dimension), (String)InfinityMethods.formatAsTitleCase(dimension.method_12832()));
    }

    public static String formatAsTitleCase(String text) {
        text = text.replaceAll("[_./]", " ");
        StringBuilder newText = new StringBuilder();
        int i = 0;
        char[] cArray = text.toCharArray();
        int n = cArray.length;
        for (int j = 0; j < n; ++j) {
            Character c = Character.valueOf(cArray[j]);
            if (i == 0) {
                c = Character.valueOf(c.toString().toUpperCase().charAt(0));
            }
            newText.append(c);
            ++i;
            if (c.charValue() != ' ') continue;
            i = 0;
        }
        return newText.toString();
    }

    public static boolean chaosMobsEnabled() {
        return RandomProvider.rule("chaosMobsEnabled");
    }

    public static boolean longArithmeticEnabled() {
        return RandomProvider.rule("longArithmeticEnabled");
    }

    public static boolean isCreateLoaded() {
        if (Platform.isModLoaded((String)"create")) {
            return Platform.getMod((String)"create").getVersion().charAt(0) != '5';
        }
        return false;
    }
}

