/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.util.config;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.lerariemann.infinity.util.config.ConfigFactory;
import net.lerariemann.infinity.util.config.DataCollection;
import net.lerariemann.infinity.util.config.SurfaceRuleScanner;
import net.lerariemann.infinity.util.var.ColorLogic;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_173;
import net.minecraft.class_1922;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2378;
import net.minecraft.class_2396;
import net.minecraft.class_2400;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import net.minecraft.class_4081;
import net.minecraft.class_4538;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5483;
import net.minecraft.class_6012;
import net.minecraft.class_7061;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public interface ConfigGenerator {
    public static void generateAll(MinecraftServer server) {
        ConfigFactory.of(class_7923.field_41178).generate("misc", "items");
        ConfigFactory.of(class_7923.field_41180, ConfigGenerator::extractParticle).generate("misc", "particles");
        ConfigFactory.of(class_7923.field_41177, ConfigGenerator::extractMob).generate("extra", "mobs");
        ConfigFactory.of(class_7923.field_41174, ConfigGenerator::extractEffect).generate("extra", "effects");
        ConfigGenerator.generateSounds();
        ConfigGenerator.generateBlockTags();
        SurfaceRuleScanner.scan(server);
        class_5455.class_6890 manager = server.method_30611();
        ConfigFactory.of(manager.method_30530(class_7924.field_41236), ConfigGenerator::extractBiome).generate("extra", "biomes");
        ConfigFactory.of(manager.method_30530(class_7924.field_41246), ConfigGenerator::extractStructure).generate("extra", "structures");
        ConfigFactory.of(manager.method_30530(class_7924.field_41239), ConfigGenerator::extractFeature).generate("extra", "trees");
    }

    public static void generateSounds() {
        class_2378 r = class_7923.field_41172;
        DataCollection.Logged music = new DataCollection.Logged("misc", "music", "music tracks");
        DataCollection.Logged sounds = new DataCollection.Logged("misc", "sounds");
        r.method_42021().forEach(a -> {
            class_2960 id = a.method_29177();
            if (id.toString().contains("music")) {
                DataCollection.addIdentifier(music, id);
            } else {
                DataCollection.addIdentifier(sounds, id);
            }
        });
        sounds.save();
        music.save();
    }

    public static void generateBlockTags() {
        DataCollection.Logged tagMap = new DataCollection.Logged("misc", "tags", "block tags");
        class_7923.field_41175.method_40273().forEach(tagKey -> DataCollection.addIdentifier(tagMap, tagKey.comp_327()));
        tagMap.save();
    }

    public static Set<String> generateFluids() {
        DataCollection.Logged fluidMap = new DataCollection.Logged("blocks", "fluids");
        class_7922 r = class_7923.field_41173;
        HashSet<String> fluidBlockNames = new HashSet<String>();
        r.method_42021().forEach(arg_0 -> ConfigGenerator.lambda$generateFluids$2(fluidBlockNames, (class_2378)r, fluidMap, arg_0));
        fluidMap.save();
        return fluidBlockNames;
    }

    public static void generateBlocks(class_3218 serverWorld, class_2338 inAir, class_2338 onAltar, Set<String> excludedBlockNames) {
        DataCollection.Logged blockMap = new DataCollection.Logged("blocks", "blocks");
        DataCollection colorPresetMap = new DataCollection("extra", "color_presets");
        DataCollection airMap = new DataCollection("blocks", "airs");
        DataCollection flowerMap = new DataCollection("blocks", "flowers");
        class_7922 r = class_7923.field_41175;
        r.method_42021().forEach(arg_0 -> ConfigGenerator.lambda$generateBlocks$3(excludedBlockNames, (class_2378)r, blockMap, serverWorld, inAir, onAltar, colorPresetMap, airMap, flowerMap, arg_0));
        blockMap.save();
        colorPresetMap.save();
        airMap.save();
        flowerMap.save();
    }

    public static class_2499 checkColorSet(String block) {
        AtomicInteger successCounter = new AtomicInteger();
        class_2499 colorSet = new class_2499();
        Arrays.stream(ColorLogic.vanillaColors).forEach(color -> {
            int i = block.lastIndexOf("magenta");
            String blockColored = block.substring(0, i) + color + block.substring(i + 7);
            if (class_7923.field_41175.method_10250(new class_2960(blockColored))) {
                successCounter.addAndGet(1);
                class_2487 c = new class_2487();
                c.method_10582("Name", blockColored);
                colorSet.add((Object)c);
            }
        });
        return successCounter.get() == ColorLogic.vanillaColors.length ? colorSet : null;
    }

    public static class_2487 extractFluid(class_5321<class_3611> key) {
        class_3611 b = (class_3611)class_7923.field_41173.method_29107(key);
        if (!1.$assertionsDisabled && b == null) {
            throw new AssertionError();
        }
        class_2487 res = new class_2487();
        String name = class_7923.field_41175.method_10221((Object)b.method_15785().method_15759().method_26204()).toString();
        res.method_10582("Name", name);
        res.method_10582("fluidName", key.method_29177().toString());
        return res;
    }

    public static class_2487 extractBlock(class_5321<class_2248> key, class_4538 w, class_2338 inAir, class_2338 onStone) {
        class_2248 b = (class_2248)class_7923.field_41175.method_29107(key);
        if (!1.$assertionsDisabled && b == null) {
            throw new AssertionError();
        }
        class_2680 bs = b.method_9564();
        class_2487 res = new class_2487();
        res.method_10582("Name", key.method_29177().toString());
        res.method_10556("laggy", ConfigGenerator.isLaggy(b));
        res.method_10556("full", ConfigGenerator.isFull(bs, w, inAir));
        res.method_10556("float", ConfigGenerator.isFloat(bs, w, inAir));
        class_2487 properties = new class_2487();
        if (bs.method_28498((class_2769)class_2741.field_12514)) {
            properties.method_10582("persistent", "true");
        }
        if (bs.method_28498((class_2769)class_2741.field_12548)) {
            properties.method_10582("lit", "false");
        }
        if (bs.method_28498((class_2769)class_2741.field_12555)) {
            properties.method_10582("face", "floor");
            bs = (class_2680)bs.method_11657((class_2769)class_2741.field_12555, (Comparable)class_2738.field_12475);
        }
        res.method_10556("top", ConfigGenerator.isTop(bs, w, onStone));
        if (!properties.method_33133()) {
            res.method_10566("Properties", (class_2520)properties);
        }
        return res;
    }

    public static boolean isLaggy(class_2248 b) {
        return b.method_9564().method_31709();
    }

    public static boolean isTop(class_2680 bs, class_4538 w, class_2338 onStone) {
        try {
            return bs.method_26184(w, onStone);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isFloat(class_2680 bs, class_4538 w, class_2338 inAir) {
        try {
            return bs.method_26184(w, inAir) && !(bs.method_26204() instanceof class_2346);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isFull(class_2680 bs, class_4538 w, class_2338 inAir) {
        return class_2248.method_9614((class_265)bs.method_26220((class_1922)w, inAir)) && class_2248.method_9614((class_265)bs.method_26218((class_1922)w, inAir));
    }

    public static String extractParticle(class_5321<class_2396<?>> key) {
        class_2960 id = key.method_29177();
        if (!id.method_12836().equals("minecraft") && !(class_7923.field_41180.method_10223(id) instanceof class_2400)) {
            return null;
        }
        return id.toString();
    }

    public static class_2487 extractMob(class_5321<class_1299<?>> key) {
        if (key.method_29177().method_12836().equals("minecolonies")) {
            return null;
        }
        class_1311 sg = ((class_1299)class_7923.field_41177.method_10223(key.method_29177())).method_5891();
        if (sg == class_1311.field_17715) {
            return null;
        }
        class_2487 mob = new class_2487();
        mob.method_10582("Name", key.method_29177().toString());
        mob.method_10582("Category", sg.method_15434());
        return mob;
    }

    public static class_2487 extractEffect(class_5321<class_1291> key) {
        class_2487 res = new class_2487();
        Optional o = class_7923.field_41174.method_31189(key);
        if (o.isEmpty()) {
            return null;
        }
        class_1291 effect = (class_1291)o.get();
        res.method_10582("Name", key.method_29177().toString());
        res.method_10582("Category", switch (effect.method_18792()) {
            default -> throw new IncompatibleClassChangeError();
            case class_4081.field_18272 -> "harmful";
            case class_4081.field_18271 -> "beneficial";
            case class_4081.field_18273 -> "neutral";
        });
        res.method_10569("Color", effect.method_5556());
        res.method_10556("Instant", effect.method_5561());
        return res;
    }

    public static class_2487 extractStructure(class_2378<class_3195> registry, class_5321<class_3195> key) {
        class_2960 id = key.method_29177();
        if (id.method_12836().equals("infinity") && id.method_12832().contains("_")) {
            return null;
        }
        Optional o = registry.method_31189(key);
        if (o.isEmpty()) {
            return null;
        }
        class_3195 structure = (class_3195)o.get();
        String step = structure.method_41616().name().toLowerCase();
        String adaptation = structure.method_42701().name().toLowerCase();
        class_2487 overrides = ConfigGenerator.genOverrides(structure.method_41615());
        class_2487 res = new class_2487();
        res.method_10582("id", id.toString());
        res.method_10582("step", step);
        res.method_10566("spawn_overrides", (class_2520)overrides);
        res.method_10582("terrain_adaptation", adaptation);
        return res;
    }

    public static class_2487 genOverrides(Map<class_1311, class_7061> overrides) {
        class_2487 res = new class_2487();
        overrides.forEach((key, value) -> res.method_10566(key.name().toLowerCase(), (class_2520)ConfigGenerator.genOverride(value)));
        return res;
    }

    public static class_2487 genOverride(class_7061 spawns) {
        class_2487 res = new class_2487();
        class_7061.class_7062 box = spawns.comp_514();
        res.method_10582("bounding_box", box == class_7061.class_7062.field_37199 ? "piece" : "full");
        res.method_10566("spawns", (class_2520)ConfigGenerator.genSpawns((class_6012<class_5483.class_1964>)spawns.comp_515()));
        return res;
    }

    public static class_2499 genSpawns(class_6012<class_5483.class_1964> entries) {
        class_2499 lst = new class_2499();
        entries.method_34994().forEach(entry -> lst.add((Object)ConfigGenerator.genEntry(entry)));
        return lst;
    }

    public static class_2487 genEntry(class_5483.class_1964 entry) {
        class_2487 res = new class_2487();
        res.method_10582("type", class_7923.field_41177.method_10221((Object)entry.field_9389).toString());
        res.method_10569("maxCount", entry.field_9387);
        res.method_10569("minCount", entry.field_9388);
        res.method_10569("weight", entry.method_34979().method_34976());
        return res;
    }

    public static class_2487 extractFeature(class_2378<class_2975<?, ?>> registry, class_5321<class_2975<?, ?>> key) {
        class_2960 id = key.method_29177();
        if (id.method_12836().equals("infinity") && id.method_12832().contains("_")) {
            return null;
        }
        if (id.toString().contains("bees")) {
            return null;
        }
        Optional o = registry.method_31189(key);
        if (o.isEmpty()) {
            return null;
        }
        class_2975 feature = (class_2975)o.get();
        String type = ConfigGenerator.getFeatureType(feature.comp_332());
        if (type.isEmpty()) {
            return null;
        }
        class_2487 res = new class_2487();
        res.method_10582("Name", id.toString());
        res.method_10582("Type", type);
        return res;
    }

    public static String getFeatureType(class_3031<?> type) {
        if (type.equals((Object)class_3031.field_24134)) {
            return "tree";
        }
        if (type.equals((Object)class_3031.field_22185)) {
            return "huge_fungus";
        }
        if (type.equals((Object)class_3031.field_13531)) {
            return "huge_brown_mushroom";
        }
        if (type.equals((Object)class_3031.field_13571)) {
            return "huge_red_mushroom";
        }
        return "";
    }

    public static class_2487 extractLootTable(class_2378<class_52> registry, class_5321<class_52> key) {
        class_2960 id = key.method_29177();
        Optional o = registry.method_31189(key);
        if (o.isEmpty()) {
            return null;
        }
        class_52 table = (class_52)o.get();
        class_2960 type = (class_2960)class_173.field_1178.inverse().get((Object)table.method_322());
        if (type == null) {
            return null;
        }
        class_2487 res = new class_2487();
        res.method_10582("Name", id.toString());
        res.method_10582("Type", type.method_12832());
        return res;
    }

    public static class_2487 extractBiome(class_2378<class_1959> registry, class_5321<class_1959> key) {
        class_2960 id = key.method_29177();
        if (id.method_12836().equals("infinity")) {
            return null;
        }
        Optional o = registry.method_31189(key);
        if (o.isEmpty()) {
            return null;
        }
        class_1959 biome = (class_1959)o.get();
        class_2487 res = new class_2487();
        res.method_10582("Name", id.toString());
        res.method_10569("Color", biome.method_8698());
        return res;
    }

    private static /* synthetic */ void lambda$generateBlocks$3(Set excludedBlockNames, class_2378 r, DataCollection.Logged blockMap, class_3218 serverWorld, class_2338 inAir, class_2338 onAltar, DataCollection colorPresetMap, DataCollection airMap, DataCollection flowerMap, class_5321 key) {
        class_2499 lst;
        String blockName = key.method_29177().toString();
        if (excludedBlockNames.contains(blockName)) {
            return;
        }
        class_2248 block = (class_2248)r.method_29107(key);
        if (!1.$assertionsDisabled && block == null) {
            throw new AssertionError();
        }
        String modId = key.method_29177().method_12836();
        blockMap.add(modId, ConfigGenerator.extractBlock((class_5321<class_2248>)key, (class_4538)serverWorld, inAir, onAltar));
        if (blockName.contains("magenta") && !ConfigGenerator.isLaggy(block) && ConfigGenerator.isFloat(block.method_9564(), (class_4538)serverWorld, inAir) && (lst = ConfigGenerator.checkColorSet(blockName)) != null) {
            colorPresetMap.add(modId, lst);
        }
        if (block.method_9564().method_26215()) {
            DataCollection.addIdentifier(airMap, key.method_29177());
        }
        if (block.method_9564().method_26164(class_3481.field_15480)) {
            DataCollection.addIdentifier(flowerMap, key.method_29177());
        }
    }

    private static /* synthetic */ void lambda$generateFluids$2(Set fluidBlockNames, class_2378 r, DataCollection.Logged fluidMap, class_5321 a) {
        class_3609 fl;
        class_2487 data = ConfigGenerator.extractFluid((class_5321<class_3611>)a);
        fluidBlockNames.add(data.method_10558("Name"));
        class_3611 f = (class_3611)r.method_10223(a.method_29177());
        if (f instanceof class_3609 && (fl = (class_3609)f).equals(fl.method_15751())) {
            String modId = a.method_29177().method_12836();
            fluidMap.add(modId, data);
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

