/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.util.config;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.util.core.CommonIO;
import net.lerariemann.infinity.util.core.WeighedStructure;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class DataCollection<T> {
    private final Map<String, WeighedStructure<T>> map = new HashMap<String, WeighedStructure<T>>();
    String addPath;
    String name;

    DataCollection(String addPath, String name) {
        this.addPath = addPath;
        this.name = name;
    }

    void add(String modId, T elem) {
        if (!this.map.containsKey(modId)) {
            this.map.put(modId, new WeighedStructure());
        }
        this.map.get(modId).add(elem, 1.0);
    }

    static void addIdentifier(DataCollection<String> collection, class_2960 id) {
        collection.add(id.method_12836(), id.toString());
    }

    void save() {
        this.map.forEach((modId, data) -> {
            if (!data.keys.isEmpty()) {
                CommonIO.write(DataCollection.wsToCompound(data), InfinityMod.configPath.resolve("modular").resolve((String)modId).resolve(this.addPath), this.name + ".json");
            }
        });
    }

    static <T> class_2487 wsToCompound(final WeighedStructure<T> w) {
        class_2487 res = new class_2487();
        class_2499 elements = new class_2499();
        ArrayList<Integer> range = new ArrayList<Integer>(IntStream.rangeClosed(0, w.keys.size() - 1).boxed().toList());
        range.sort(new Comparator<Integer>(){

            public String extract(int i) {
                Object obj = w.keys.get(i);
                Object t = Objects.requireNonNull(obj);
                if (t instanceof class_2487) {
                    class_2487 compound = (class_2487)t;
                    return compound.method_10558("Name");
                }
                if (obj instanceof class_2499) {
                    class_2499 list = (class_2499)obj;
                    return list.method_10534(0).toString();
                }
                return obj.toString();
            }

            @Override
            public int compare(Integer i, Integer j) {
                return this.extract(i).compareTo(this.extract(j));
            }
        });
        for (int i = 0; i < w.keys.size(); ++i) {
            class_2487 element = new class_2487();
            Object obj = w.keys.get((Integer)range.get(i));
            Object t = Objects.requireNonNull(obj);
            if (t instanceof String) {
                String string = (String)t;
                element.method_10582("key", string);
            } else if (obj instanceof class_2520) {
                class_2520 e = (class_2520)obj;
                element.method_10566("key", e);
            } else {
                throw new RuntimeException("Unexpected weighed structure format");
            }
            element.method_10549("weight", w.weights.get((Integer)range.get(i)).doubleValue());
            elements.add((Object)element);
        }
        res.method_10566("elements", (class_2520)elements);
        return res;
    }

    static void loggerOutput(int count, String type) {
        InfinityMod.LOGGER.info("Registered {} {}", (Object)count, (Object)type);
    }

    static class Logged<T>
    extends DataCollection<T> {
        private final AtomicInteger i = new AtomicInteger();
        String loggerName;

        Logged(String addPath, String name) {
            this(addPath, name, name);
        }

        Logged(String addPath, String name, String loggerName) {
            super(addPath, name);
            this.loggerName = loggerName;
        }

        @Override
        void add(String modId, T elem) {
            super.add(modId, elem);
            this.i.getAndIncrement();
        }

        @Override
        void save() {
            super.save();
            Logged.loggerOutput(this.i.get(), this.loggerName);
        }
    }
}

