/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.util.config;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.lerariemann.infinity.util.InfinityMethods;
import net.lerariemann.infinity.util.core.CommonIO;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Deprecated
public record SoundScanner(Map<class_2960, class_3298> soundIds) {
    public static SoundScanner instance;

    public static boolean isPreloaded() {
        return instance != null;
    }

    public static Stream<class_2960> getMatchingLoadedIds() {
        if (SoundScanner.isPreloaded()) {
            return SoundScanner.instance.soundIds.keySet().stream().filter(s -> s.method_12832().contains("music") && !s.method_12832().contains("record"));
        }
        return Stream.of(new class_2960[0]);
    }

    public static class_2487 saveResourcePack(class_310 client, Stream<class_2960> songIds, boolean sendJukeboxes) {
        class_2487 soundsForRP = new class_2487();
        class_2487 subtitlesForRP = new class_2487();
        class_2487 jukeboxes = new class_2487();
        songIds.forEach(id -> {
            String str = id.toString().replace(".ogg", "").replace("sounds/", "");
            List<String> arr = Arrays.stream(str.split("[:/]")).toList();
            String songID = "disc." + arr.get(0) + "." + arr.get(arr.size() - 1);
            String subtitleID = "infinity:subtitles." + songID;
            String subtitleData = InfinityMethods.formatAsTitleCase(arr.get(0) + " - " + arr.get(arr.size() - 1));
            class_2499 soundForRPList = new class_2499();
            soundForRPList.add((Object)class_2519.method_23256((String)str));
            class_2487 soundForRP = new class_2487();
            soundForRP.method_10566("sounds", (class_2520)soundForRPList);
            soundForRP.method_10582("subtitle", subtitleID);
            subtitlesForRP.method_10582(subtitleID, subtitleData);
            soundsForRP.method_10566(songID, (class_2520)soundForRP);
            if (sendJukeboxes) {
                double length;
                if (!SoundScanner.isPreloaded()) {
                    return;
                }
                try {
                    length = SoundScanner.calculateDuration(SoundScanner.instance.soundIds.get(id).method_14482().readAllBytes());
                }
                catch (IOException e) {
                    length = 600.0;
                }
                jukeboxes.method_10566(arr.get(arr.size() - 1), (class_2520)SoundScanner.getJukeboxDef(songID, subtitleID, length));
            }
        });
        CommonIO.write(soundsForRP, client.method_1479().resolve("infinity/assets/infinity"), "sounds.json");
        CommonIO.write(subtitlesForRP, client.method_1479().resolve("infinity/assets/infinity/lang"), "en_us.json");
        return jukeboxes;
    }

    public static void unpackUploadedJukeboxes(MinecraftServer server, class_2487 allJukeboxes) {
        Path pathJukeboxes = server.method_27050(class_5218.field_24186).resolve("infinity/data/infinity/jukebox_song");
        for (String key : allJukeboxes.method_10541()) {
            class_2520 class_25202 = allJukeboxes.method_10580(key);
            if (!(class_25202 instanceof class_2487)) continue;
            class_2487 jukebox = (class_2487)class_25202;
            CommonIO.write(jukebox, pathJukeboxes, key + ".json");
        }
    }

    public static double calculateDuration(byte[] track) throws IOException {
        ByteBuffer bb;
        byte[] byteArray;
        int i;
        int rate = -1;
        int length = -1;
        int size = track.length;
        for (i = size - 1 - 8 - 2 - 4; i >= 0 && length < 0; --i) {
            if (track[i] != 79 || track[i + 1] != 103 || track[i + 2] != 103 || track[i + 3] != 83) continue;
            byteArray = new byte[]{track[i + 6], track[i + 7], track[i + 8], track[i + 9], track[i + 10], track[i + 11], track[i + 12], track[i + 13]};
            bb = ByteBuffer.wrap(byteArray);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            length = bb.getInt(0);
        }
        for (i = 0; i < size - 8 - 2 - 4 && rate < 0; ++i) {
            if (track[i] != 118 || track[i + 1] != 111 || track[i + 2] != 114 || track[i + 3] != 98 || track[i + 4] != 105 || track[i + 5] != 115) continue;
            byteArray = new byte[]{track[i + 11], track[i + 12], track[i + 13], track[i + 14]};
            bb = ByteBuffer.wrap(byteArray);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            rate = bb.getInt(0);
        }
        return (double)length / (double)rate;
    }

    @NotNull
    private static class_2487 getJukeboxDef(String songID, String subtitleID, double length) {
        class_2487 jukebox_def = new class_2487();
        class_2487 sound_event = new class_2487();
        sound_event.method_10582("sound_id", "infinity:" + songID);
        jukebox_def.method_10566("sound_event", (class_2520)sound_event);
        class_2487 description = new class_2487();
        description.method_10582("translate", subtitleID);
        jukebox_def.method_10566("description", (class_2520)description);
        jukebox_def.method_10548("length_in_seconds", (float)length);
        jukebox_def.method_10569("comparator_output", 15);
        return jukebox_def;
    }
}

