/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.util.config;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.dimensions.RandomNoisePreset;
import net.lerariemann.infinity.util.config.DataCollection;
import net.lerariemann.infinity.util.core.CommonIO;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_5284;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public interface SurfaceRuleScanner {
    public static void scan(MinecraftServer server) {
        HashMap<String, class_2487> map = new HashMap<String, class_2487>();
        class_2378 registry = server.method_30611().method_30530(class_7924.field_41243);
        registry.method_42021().forEach(key -> {
            if (!key.method_29177().method_12836().contains("infinity")) {
                Optional o = registry.method_31189(key);
                o.ifPresent(settings -> {
                    Optional c = class_5284.field_24780.encodeStart((DynamicOps)class_2509.field_11560, settings).result();
                    c.ifPresent(e -> {
                        Tree t = new Tree(((class_2487)e).method_10562("surface_rule"));
                        t.biomeLocations.keySet().forEach(biome -> {
                            if (!map.containsKey(biome)) {
                                map.put((String)biome, t.wrappedRule((String)biome));
                            }
                        });
                    });
                });
            }
        });
        map.forEach((biome, value) -> {
            String biomename = biome.substring(biome.lastIndexOf(":") + 1) + ".json";
            String modname = biome.substring(0, biome.lastIndexOf(":"));
            String path = "config/infinity/modular/" + modname + "/surface_rule";
            CommonIO.writeSurfaceRule(value, path, biomename);
        });
        DataCollection.loggerOutput(map.size(), "surface rules");
    }

    public static class Tree {
        ArrayList<TreeLeaf> registry = new ArrayList();
        HashMap<String, ArrayList<Integer>> biomeLocations = new HashMap();

        Tree(class_2487 surfaceRule) {
            TreeLeaf root = new TreeLeaf(new class_2487(), -1, null, false);
            this.add(surfaceRule, root);
        }

        static class_2487 conditionCase(class_2487 if_true, class_2487 then_run) {
            class_2487 c = new class_2487();
            c.method_10566("if_true", (class_2520)if_true);
            c.method_10566("then_run", (class_2520)then_run);
            c.method_10582("type", "minecraft:condition");
            return c;
        }

        void addBiomeLoc(String s, Integer i) {
            if (!this.biomeLocations.containsKey(s)) {
                this.biomeLocations.put(s, new ArrayList());
            }
            this.biomeLocations.get(s).add(i);
        }

        TreeLeaf addOfRule(class_2487 rule, TreeLeaf where, boolean terminal) {
            TreeLeaf l = new TreeLeaf(rule, this.registry.size(), where, terminal);
            this.registry.add(l);
            return l;
        }

        void add(class_2487 rule, TreeLeaf where) {
            switch (rule.method_10558("type")) {
                case "condition": 
                case "minecraft:condition": {
                    class_2487 next = rule.method_10562("then_run");
                    class_2487 c = rule.method_10562("if_true");
                    if (c.method_10558("type").contains("above_preliminary_surface")) {
                        this.add(next, where);
                        break;
                    }
                    if (!c.method_10558("type").contains("biome")) {
                        TreeLeaf l = this.addOfRule(c, where, false);
                        this.add(next, l);
                        break;
                    }
                    TreeLeaf l = this.addOfRule(next, where, true);
                    if (!Objects.requireNonNull(c.method_10580("biome_is")).method_23258().equals((Object)class_2499.field_21039)) break;
                    c.method_10554("biome_is", 8).forEach(e -> this.addBiomeLoc(e.method_10714(), l.i));
                    break;
                }
                case "sequence": 
                case "minecraft:sequence": {
                    class_2499 sq = rule.method_10554("sequence", 10);
                    sq.forEach(e -> this.add((class_2487)e, where));
                    break;
                }
                default: {
                    if (Tree.checkUnneededParts(rule)) break;
                    TreeLeaf l = this.addOfRule(rule, where, true);
                    this.addBiomeLoc("minecraft:default", l.i);
                }
            }
        }

        static boolean checkUnneededParts(class_2487 rule) {
            return rule.method_10558("type").contains("block") && (rule.toString().contains("minecraft:bedrock") || rule.toString().contains("minecraft:deepslate"));
        }

        public class_2487 wrappedRule(String biome) {
            class_2487 c = new class_2487();
            class_2499 l = new class_2499();
            l.add((Object)class_2519.method_23256((String)biome));
            c.method_10566("biomes", (class_2520)l);
            c.method_10566("rule", (class_2520)this.extractRule(biome));
            return c;
        }

        public class_2487 extractRule(String biome) {
            if (!this.biomeLocations.containsKey(biome)) {
                return null;
            }
            class_2487 comp = RandomNoisePreset.startingRule("sequence");
            class_2499 l = new class_2499();
            try {
                this.biomeLocations.get(biome).forEach(i -> l.add((Object)this.extractRule((int)i)));
                if (this.biomeLocations.containsKey("minecraft:default")) {
                    this.biomeLocations.get("minecraft:default").forEach(i -> l.add((Object)this.extractRule((int)i)));
                } else {
                    InfinityMod.LOGGER.warn("Default locations unexpectedly missing when processing surface rules for biome {}", (Object)biome);
                }
                comp.method_10566("sequence", (class_2520)l);
            }
            catch (Exception e) {
                throw new RuntimeException("Encountered an unexpected exception when processing surface rules for biome " + biome + "\n" + e.getMessage());
            }
            this.biomeLocations.get(biome).forEach(i -> l.add((Object)this.extractRule((int)i)));
            if (this.biomeLocations.containsKey("minecraft:default")) {
                this.biomeLocations.get("minecraft:default").forEach(i -> l.add((Object)this.extractRule((int)i)));
            }
            comp.method_10566("sequence", (class_2520)l);
            return comp;
        }

        TreeLeaf getParent(TreeLeaf l) {
            if (l.i_parent == -1) {
                return l;
            }
            return this.registry.get(l.i_parent);
        }

        class_2487 extractRule(int i) {
            TreeLeaf l = this.registry.get(i);
            assert (l.is_terminal);
            if (l.i_parent == -1) {
                return l.data;
            }
            return this.extractRule(this.getParent(l), l.data);
        }

        class_2487 extractRule(TreeLeaf l, class_2487 data) {
            class_2487 newdata = Tree.conditionCase(l.data, data);
            if (l.i_parent == -1) {
                return newdata;
            }
            return this.extractRule(this.getParent(l), newdata);
        }

        static class TreeLeaf {
            class_2487 data;
            int i;
            int i_parent;
            boolean is_terminal;

            TreeLeaf(class_2487 c, int num, @Nullable TreeLeaf where, boolean e) {
                this.data = c;
                this.i = num;
                this.i_parent = where == null ? -1 : where.i;
                this.is_terminal = e;
            }
        }
    }
}

