/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.util.core;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.architectury.platform.Platform;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiFunction;
import net.lerariemann.infinity.util.core.RandomProvider;
import net.lerariemann.infinity.util.core.SaferStringReader;
import net.lerariemann.infinity.util.core.WeighedStructure;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2503;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_3532;
import org.apache.commons.io.FileUtils;

public interface CommonIO {
    public static final int maxBound = 30000000;

    public static void write(class_2487 base, String path, String filename) {
        CommonIO.write(CommonIO.compoundToString(base), Paths.get(path, new String[0]), filename);
    }

    public static void write(class_2487 base, Path dir, String filename) {
        CommonIO.write(CommonIO.compoundToString(base), dir, filename);
    }

    public static void write(String source, Path dir, String filename) {
        List<String> lines = Collections.singletonList(source);
        filename = filename.replace("/", "_").replace("\\", "_");
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            Path file = dir.resolve(filename);
            Files.write(file, lines, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeSurfaceRule(class_2487 base, String path, String filename) {
        String source = CommonIO.compoundToString(base);
        Integer[] integerArray = new Integer[]{31, 62};
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int j = integerArray[i];
            for (int i2 = -5; i2 < 6; ++i2) {
                String z = Integer.toString(j + i2);
                source = source.replace("\"absolute\": " + z, "\"absolute\": " + (String)(i2 == 0 ? "%SL%" : "%SL" + (i2 > 0 ? "+" : "") + i2 + "%"));
            }
        }
        CommonIO.write(source, Paths.get(path, new String[0]), filename);
    }

    public static int getVersion(File file) {
        try {
            String content = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
            if (!content.contains("infinity_version")) {
                return 0;
            }
            int i = content.indexOf("infinity_version");
            int end = content.indexOf(",", i);
            if (end == -1) {
                end = content.indexOf("\n", i);
            }
            return Integer.parseInt(content.substring(content.indexOf(" ", i) + 1, end).trim());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class_2487 read(String path) {
        return CommonIO.read(new File(path));
    }

    public static class_2487 read(Path path) {
        return CommonIO.read(path.toFile());
    }

    public static class_2487 read(File file) {
        try {
            if (file.exists()) {
                String content = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
                class_2487 c = SaferStringReader.parse(content);
                c.method_10551("infinity_version");
                return c;
            }
            return new class_2487();
        }
        catch (CommandSyntaxException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class_2487 readAndFormat(String path, Object ... args) {
        File file = new File(path);
        try {
            String content = String.valueOf(new Formatter(Locale.US).format(FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8), args));
            class_2487 c = class_2522.method_10718((String)content);
            c.method_10551("infinity_version");
            return c;
        }
        catch (CommandSyntaxException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class_2487 readAndAddCompound(String path, class_2487 block) {
        return CommonIO.readAndFormat(path, CommonIO.compoundToString(block));
    }

    public static class_2487 readSurfaceRule(File file, int seaLevel) {
        try {
            String content = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
            class_2487 c = CommonIO.formatSurfaceRule(content, seaLevel);
            c.method_10551("infinity_version");
            return c;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class_2487 formatSurfaceRule(String content, int seaLevel) {
        int i = content.lastIndexOf("%");
        if (i == -1) {
            try {
                return class_2522.method_10718((String)content);
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        if (content.contains("%SL%")) {
            return CommonIO.formatSurfaceRule(content.replace("%SL%", String.valueOf(seaLevel)), seaLevel);
        }
        int j = content.lastIndexOf("%SL");
        String num = content.substring(j + 3, i);
        return CommonIO.formatSurfaceRule(content.replace("%SL" + num + "%", String.valueOf(seaLevel + Integer.parseInt(num))), seaLevel);
    }

    public static WeighedStructure<String> readStringList(String path) {
        class_2487 base = CommonIO.read(path);
        WeighedStructure<String> res = new WeighedStructure<String>();
        class_2499 list = base.method_10554("elements", 10);
        for (int i = 0; i < list.size(); ++i) {
            class_2487 a = list.method_10602(i);
            res.add(a.method_10558("key"), a.method_10574("weight"));
        }
        return res;
    }

    private static boolean _checkIfModLoaded(File path1) {
        if (!RandomProvider.rule("enforceModLoadedChecks")) {
            return true;
        }
        String modname = path1.toPath().getName(path1.toPath().getNameCount() - 1).toString();
        return Platform.isModLoaded((String)modname);
    }

    private static class_2499 _extractElements(File path1, String subpath) {
        File file;
        if (CommonIO._checkIfModLoaded(path1) && (file = path1.toPath().resolve(subpath).toFile()).exists()) {
            class_2487 base = CommonIO.read(file);
            return base.method_10554("elements", 10);
        }
        return new class_2499();
    }

    public static <T> WeighedStructure<T> readWeighedList(Path path, String subPath, BiFunction<class_2487, String, T> infoGetter) {
        WeighedStructure<T> res = new WeighedStructure<T>();
        for (File path1 : Objects.requireNonNull(path.toFile().listFiles(File::isDirectory))) {
            class_2499 list = CommonIO._extractElements(path1, subPath);
            for (int i = 0; i < list.size(); ++i) {
                class_2487 a = list.method_10602(i);
                res.add(infoGetter.apply(a, "key"), a.method_10574("weight"));
            }
        }
        return res;
    }

    public static WeighedStructure<String> readStringList(Path path, String subPath) {
        return CommonIO.readWeighedList(path, subPath, class_2487::method_10558);
    }

    public static WeighedStructure<class_2520> readCompoundList(Path path, String subPath) {
        return CommonIO.readWeighedList(path, subPath, class_2487::method_10580);
    }

    public static String appendTabs(String parent, int t) {
        return parent + "\t".repeat(Math.max(0, t));
    }

    public static String elementToString(class_2520 base, int t) {
        if (base == null) {
            return "!!NULL!!";
        }
        if (base instanceof class_2487) {
            class_2487 nbtCompound = (class_2487)base;
            return CommonIO.compoundToString(nbtCompound, t + 1);
        }
        if (base instanceof class_2499) {
            class_2499 nbtElements = (class_2499)base;
            return CommonIO.listToString(nbtElements, t + 1);
        }
        if (base instanceof class_2481) {
            class_2481 nbtByte = (class_2481)base;
            return nbtByte.method_10698() != 0 ? "true" : "false";
        }
        if (base instanceof class_2489) {
            class_2489 nbtDouble = (class_2489)base;
            return String.valueOf(CommonIO.boundsCheck(nbtDouble.method_10700()));
        }
        if (base instanceof class_2494) {
            class_2494 nbtFloat = (class_2494)base;
            return String.valueOf(CommonIO.boundsCheck(nbtFloat.method_10700()));
        }
        if (base instanceof class_2503) {
            class_2503 nbtLong = (class_2503)base;
            return String.valueOf(CommonIO.boundsCheck(nbtLong.method_10699()));
        }
        if (base instanceof class_2497) {
            class_2497 nbtInt = (class_2497)base;
            return String.valueOf(CommonIO.boundsCheck(nbtInt.method_10701()));
        }
        if (base instanceof class_2516) {
            class_2516 nbtShort = (class_2516)base;
            return String.valueOf(CommonIO.boundsCheck(nbtShort.method_10696()));
        }
        if (base instanceof class_2519) {
            class_2519 nbtString = (class_2519)base;
            return "\"" + nbtString.method_10714().replace("\"", "\\\"") + "\"";
        }
        return base.toString();
    }

    public static float boundsCheck(float base) {
        return class_3532.method_15363((float)base, (float)-3.0E7f, (float)3.0E7f);
    }

    public static int boundsCheck(long base) {
        return (int)class_3532.method_15363((float)base, (float)-3.0E7f, (float)3.0E7f);
    }

    public static int boundsCheck(int base) {
        return class_3532.method_15340((int)base, (int)-30000000, (int)30000000);
    }

    public static String compoundToString(class_2487 base) {
        return CommonIO.compoundToString(base, 0);
    }

    public static String compoundToString(class_2487 base, int t) {
        Object res = "{\n";
        int i = base.method_10546() - 1;
        for (String key : base.method_10541()) {
            class_2520 elem = base.method_10580(key);
            res = CommonIO.appendTabs((String)res, t + 1) + "\"" + key + "\": " + CommonIO.elementToString(elem, t);
            if (i != 0) {
                res = (String)res + ",";
            }
            res = (String)res + "\n";
            --i;
        }
        res = CommonIO.appendTabs((String)res, t) + "}";
        return res;
    }

    public static String listToString(class_2499 base, int t) {
        Object res = "[\n";
        for (int i = 0; i < base.size(); ++i) {
            class_2520 elem = base.method_10534(i);
            res = CommonIO.appendTabs((String)res, t + 1) + CommonIO.elementToString(elem, t);
            if (i != base.size() - 1) {
                res = (String)res + ",";
            }
            res = (String)res + "\n";
        }
        res = CommonIO.appendTabs((String)res, t) + "]";
        return res;
    }
}

