/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.util.core;

import java.nio.file.Path;
import java.util.List;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.util.core.CommonIO;
import net.lerariemann.infinity.util.core.RandomProvider;
import net.lerariemann.infinity.util.core.WeighedStructure;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public record CorePack(RandomProvider provider, Path savingPath) {
    void generate() {
        this.saveTrees();
        this.saveEndOfTime();
        if (!this.savingPath.resolve("pack.mcmeta").toFile().exists()) {
            this.savePackMcmeta();
        }
    }

    void savePackMcmeta() {
        class_2487 res = new class_2487();
        class_2487 pack = new class_2487();
        pack.method_10569("pack_format", 34);
        pack.method_10582("description", "Common content providers for Infinite Dimensions");
        res.method_10566("pack", (class_2520)pack);
        CommonIO.write(res, this.savingPath, "pack.mcmeta");
    }

    public static class_2487 treePlacement(String tree, String block) {
        return CommonIO.readAndFormat(InfinityMod.utilPath.resolve("placements/tree_vanilla.json").toString(), tree, block);
    }

    void saveTrees() {
        WeighedStructure<class_2520> treesReg = this.provider.compoundRegistry.get("trees");
        if (treesReg == null) {
            return;
        }
        List<String> trees = treesReg.keys.stream().map(compound -> ((class_2487)compound).method_10558("Name")).toList();
        double size = trees.size();
        class_2487 c = new class_2487();
        class_2499 l = new class_2499();
        c.method_10566("default", (class_2520)CorePack.treePlacement(trees.get(0), "minecraft:grass_block"));
        int i = 1;
        while ((double)i < size) {
            class_2487 c1 = new class_2487();
            c1.method_10566("feature", (class_2520)CorePack.treePlacement(trees.get(i), "minecraft:grass_block"));
            c1.method_10549("chance", 1.0 / (size - (double)i + 1.0));
            l.add((Object)c1);
            ++i;
        }
        c.method_10566("features", (class_2520)l);
        class_2487 c2 = new class_2487();
        c2.method_10582("type", "minecraft:random_selector");
        c2.method_10566("config", (class_2520)c);
        CommonIO.write(c2, this.savingPath.resolve("data/infinity/worldgen/configured_feature"), "all_trees.json");
    }

    void saveEndOfTime() {
        class_2487 res = new class_2487();
        for (String category : this.provider.getMobCategories()) {
            class_2499 entries = new class_2499();
            for (String mob : this.provider.registry.get((Object)category).keys) {
                class_2487 entry = new class_2487();
                entry.method_10582("type", mob);
                entry.method_10569("minCount", 1);
                entry.method_10569("maxCount", 1);
                entry.method_10569("weight", 1);
                entries.add((Object)entry);
            }
            res.method_10566(category, (class_2520)entries);
        }
        CommonIO.write(CommonIO.readAndAddCompound(InfinityMod.utilPath.resolve("end_of_time.json").toString(), res), this.savingPath.resolve("data/infinity/worldgen/biome"), "end.json");
    }
}

