/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.util.core;

import java.util.Random;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.util.core.RandomProvider;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public interface NbtUtils {
    public static String test(class_2487 data, String key, String def) {
        return data.method_10573(key, 8) ? data.method_10558(key) : def;
    }

    public static class_2487 test(class_2487 data, String key, class_2487 def) {
        return data.method_10573(key, 10) ? data.method_10562(key) : def;
    }

    public static float test(class_2487 data, String key, float def) {
        return data.method_10573(key, 6) ? data.method_10583(key) : def;
    }

    public static int test(class_2487 data, String key, int def) {
        return data.method_10573(key, 3) ? data.method_10550(key) : def;
    }

    public static double test(class_2487 data, String key, double def) {
        return data.method_10573(key, 6) ? data.method_10574(key) : def;
    }

    public static boolean test(class_2487 data, String key, boolean def) {
        return data.method_10545(key) ? data.method_10577(key) : def;
    }

    public static String elementToName(class_2520 e) {
        if (e instanceof class_2487) {
            return ((class_2487)e).method_10558("Name");
        }
        return e.method_10714();
    }

    public static class_2487 nameToElement(String block) {
        class_2487 res = new class_2487();
        res.method_10582("Name", block);
        return res;
    }

    public static class_2487 nameToFluid(String block) {
        class_2487 res = new class_2487();
        res.method_10582("Name", block);
        res.method_10582("fluidName", block);
        return res;
    }

    public static class_2487 blockToSimpleStateProvider(class_2487 block) {
        class_2487 res = new class_2487();
        res.method_10582("type", "minecraft:simple_state_provider");
        res.method_10566("state", (class_2520)block);
        return res;
    }

    public static void addBounds(class_2487 res, int lbound, int bound) {
        class_2487 value = new class_2487();
        value.method_10569("min_inclusive", lbound);
        value.method_10569("max_inclusive", bound);
        res.method_10566("value", (class_2520)value);
    }

    public static void addBounds(class_2487 res, Random random, int lbound, int bound) {
        int a = random.nextInt(lbound, bound);
        int b = random.nextInt(lbound, bound);
        NbtUtils.addBounds(res, Math.min(a, b), Math.max(a, b));
    }

    public static class_2520 randomIntProvider(Random random, int bound, boolean acceptDistributions) {
        return NbtUtils.randomIntProvider(random, 0, bound, acceptDistributions);
    }

    public static class_2520 randomIntProvider(Random random, int lbound, int bound, boolean acceptDistributions) {
        int i = random.nextInt(acceptDistributions ? 6 : 4);
        class_2487 res = new class_2487();
        switch (i) {
            case 0: {
                res.method_10582("type", "constant");
                res.method_10569("value", random.nextInt(lbound, bound));
                return res;
            }
            case 1: 
            case 2: {
                res.method_10582("type", i == 1 ? "uniform" : "biased_to_bottom");
                res.method_10566("value", (class_2520)RandomProvider.genBounds(lbound, bound));
                return res;
            }
            case 4: {
                res.method_10582("type", "clamped");
                class_2487 value = RandomProvider.genBounds(lbound, bound);
                value.method_10566("source", NbtUtils.randomIntProvider(random, lbound, bound, false));
                res.method_10566("value", (class_2520)value);
                return res;
            }
            case 3: {
                res.method_10582("type", "clamped_normal");
                class_2487 value = RandomProvider.genBounds(lbound, bound);
                value.method_10549("mean", (double)lbound + random.nextDouble() * (double)(bound - lbound));
                value.method_10549("deviation", random.nextExponential());
                res.method_10566("value", (class_2520)value);
                return res;
            }
            case 5: {
                res.method_10582("type", "weighted_list");
                int j = 2 + random.nextInt(0, 5);
                class_2499 list = new class_2499();
                for (int k = 0; k < j; ++k) {
                    class_2487 element = new class_2487();
                    element.method_10566("data", NbtUtils.randomIntProvider(random, lbound, bound, false));
                    element.method_10569("weight", random.nextInt(100));
                    list.add((Object)element);
                }
                res.method_10566("distribution", (class_2520)list);
                return res;
            }
        }
        return res;
    }

    public static class_2487 randomHeightProvider(Random random, int lbound, int bound, boolean acceptDistributions, boolean trim) {
        int i = random.nextInt(acceptDistributions ? 6 : 5);
        String[] types = new String[]{"uniform", "biased_to_bottom", "very_biased_to_bottom", "trapezoid", "constant", "weighted_list"};
        class_2487 res = new class_2487();
        res.method_10582("type", types[i]);
        switch (i) {
            case 4: {
                class_2487 value = new class_2487();
                value.method_10569("absolute", random.nextInt(lbound, bound));
                res.method_10566("value", (class_2520)value);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                int max;
                int min;
                class_2487 min_inclusive = new class_2487();
                class_2487 max_inclusive = new class_2487();
                if (!trim && i == 3) {
                    int center = random.nextInt(lbound, bound);
                    int sigma = random.nextInt(bound - lbound);
                    min = center - sigma;
                    max = center + sigma;
                } else {
                    int k = random.nextInt(lbound, bound);
                    int j = random.nextInt(lbound, bound);
                    min = Math.min(k, j);
                    max = Math.max(k, j);
                }
                min_inclusive.method_10569("absolute", min);
                max_inclusive.method_10569("absolute", max);
                res.method_10566("min_inclusive", (class_2520)min_inclusive);
                res.method_10566("max_inclusive", (class_2520)max_inclusive);
                int randomBound = max - min;
                if (randomBound <= 1) {
                    InfinityMod.LOGGER.debug("Corrected random bound of: {} to 2!", (Object)randomBound);
                    randomBound = 2;
                }
                if (i == 3 && random.nextBoolean()) {
                    res.method_10569("plateau", random.nextInt(1, randomBound));
                    break;
                }
                if (i == 0) break;
                res.method_10569("inner", 1 + (int)Math.floor(random.nextExponential()));
                break;
            }
            case 5: {
                int j = 2 + random.nextInt(0, 5);
                class_2499 list = new class_2499();
                for (int k = 0; k < j; ++k) {
                    class_2487 element = new class_2487();
                    element.method_10566("data", (class_2520)NbtUtils.randomHeightProvider(random, lbound, bound, false, trim));
                    element.method_10569("weight", random.nextInt(100));
                    list.add((Object)element);
                }
                res.method_10566("distribution", (class_2520)list);
            }
        }
        return res;
    }

    public static class_2487 randomFloatProvider(Random random, float lbound, float bound) {
        int i = random.nextInt(3);
        String[] types = new String[]{"uniform", "clamped_normal", "trapezoid"};
        class_2487 res = new class_2487();
        res.method_10582("type", types[i]);
        class_2487 value = new class_2487();
        float a = random.nextFloat(lbound, bound);
        float b = random.nextFloat(lbound, bound);
        float min = Math.min(a, b);
        float max = Math.max(a, b);
        switch (i) {
            case 0: {
                value.method_10548("max_exclusive", max);
                value.method_10548("min_inclusive", min);
                break;
            }
            case 1: {
                value.method_10548("max", max);
                value.method_10548("min", min);
                value.method_10548("mean", random.nextFloat(min, max));
                value.method_10548("deviation", random.nextFloat(max - min));
                break;
            }
            case 2: {
                value.method_10548("max", max);
                value.method_10548("min", min);
                value.method_10548("plateau", random.nextFloat(max - min));
            }
        }
        res.method_10566("value", (class_2520)value);
        return res;
    }
}

