/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.util.core;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.util.core.CommonIO;
import net.lerariemann.infinity.util.core.CorePack;
import net.lerariemann.infinity.util.core.Easterizer;
import net.lerariemann.infinity.util.core.NbtUtils;
import net.lerariemann.infinity.util.core.WeighedStructure;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2514;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2741;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class RandomProvider {
    public Map<String, WeighedStructure<String>> registry = new HashMap<String, WeighedStructure<String>>();
    public Map<String, WeighedStructure<class_2520>> compoundRegistry = new HashMap<String, WeighedStructure<class_2520>>();
    private final Map<String, Double> rootChances = new HashMap<String, Double>();
    private final Map<String, Boolean> gameRules = new HashMap<String, Boolean>();
    private final Map<String, Integer> gameRulesInt = new HashMap<String, Integer>();
    private final Map<String, Double> gameRulesDouble = new HashMap<String, Double>();
    public ArrayList<String> disabledDimensions = new ArrayList();
    public Path savingPath;
    private String portalKey;
    public String salt;
    public Easterizer easterizer;
    public static final Map<String, String> defaultMap = Map.ofEntries(Map.entry("all_blocks", "minecraft:stone"), Map.entry("top_blocks", "minecraft:stone"), Map.entry("blocks_features", "minecraft:stone"), Map.entry("full_blocks", "minecraft:stone"), Map.entry("full_blocks_worldgen", "minecraft:stone"), Map.entry("fluids", "minecraft:water"), Map.entry("items", "minecraft:stick"), Map.entry("sounds", "minecraft:block.stone.step"), Map.entry("music", "minecraft:music.game"), Map.entry("particles", "minecraft:heart"), Map.entry("biomes", "minecraft:plains"), Map.entry("mobs", "minecraft:pig"), Map.entry("tags", "minecraft:air"), Map.entry("trees", "minecraft:oak"), Map.entry("loot_tables", "minecraft:blocks/stone"));

    public RandomProvider() {
        this.registerAll();
        this.easterizer = new Easterizer();
    }

    public RandomProvider(Path savingPath) {
        this();
        this.savingPath = savingPath;
        new CorePack(this, savingPath).generate();
    }

    public Optional<class_1792> getPortalKeyAsItem() {
        if (this.portalKey.isBlank()) {
            return Optional.empty();
        }
        return class_7923.field_41178.method_17966(new class_2960(this.portalKey));
    }

    public boolean isPortalKeyBlank() {
        return this.getPortalKeyAsItem().isEmpty();
    }

    public boolean roll(Random random, String key) {
        return random.nextDouble() < this.rootChances.getOrDefault(key, 0.0);
    }

    private static <T> T getStaticRule(BiFunction<RandomProvider, String, T> applier, BiFunction<class_2487, String, T> applier2, String key, T def) {
        if (InfinityMod.provider != null) {
            return applier.apply(InfinityMod.provider, key);
        }
        Path root = InfinityMod.configPath.resolve("infinity.json");
        if (!root.toFile().exists()) {
            return def;
        }
        class_2487 rules = CommonIO.read(InfinityMod.configPath.resolve("infinity.json")).method_10562("gameRules");
        if (!rules.method_10545(key)) {
            return def;
        }
        return applier2.apply(rules, key);
    }

    public static boolean rule(String key) {
        return RandomProvider.getStaticRule((p, k) -> p.gameRules.getOrDefault(k, false), class_2487::method_10577, key, false);
    }

    public static int ruleInt(String key) {
        return RandomProvider.getStaticRule(RandomProvider::_ruleInt, (p, k) -> ((class_2514)Objects.requireNonNull(p.method_10580(k))).method_10701(), key, -1);
    }

    private int _ruleInt(String key) {
        if (this.gameRulesInt.containsKey(key)) {
            return this.gameRulesInt.get(key);
        }
        return this.gameRulesDouble.get(key).intValue();
    }

    public String randomName(Random random, String key) {
        return this.randomName(random.nextDouble(), key);
    }

    public String randomName(class_5819 random, String key) {
        return this.randomName(random.method_43058(), key);
    }

    public String randomName(double d, String key) {
        if (this.compoundRegistry.containsKey(key)) {
            return NbtUtils.elementToName(this.compoundRegistry.get(key).getElement(d));
        }
        if (this.registry.containsKey(key)) {
            return this.registry.get(key).getElement(d);
        }
        return defaultMap.get(key);
    }

    public class_2487 randomElement(class_5819 random, String key) {
        return this.randomElement(random.method_43058(), key);
    }

    public class_2487 randomElement(Random random, String key) {
        return this.randomElement(random.nextDouble(), key);
    }

    public class_2487 randomElement(double d, String key) {
        return this.randomElementInternal(d, key, key.equals("fluids") ? NbtUtils::nameToFluid : NbtUtils::nameToElement);
    }

    private class_2487 randomElementInternal(double d, String key, Function<String, class_2487> converter) {
        if (this.compoundRegistry.containsKey(key)) {
            class_2520 compound = this.compoundRegistry.get(key).getElement(d);
            if (compound instanceof class_2487) {
                return (class_2487)compound;
            }
            if (compound instanceof class_2519) {
                return converter.apply(compound.method_10714());
            }
        } else if (this.registry.containsKey(key)) {
            return converter.apply(this.registry.get(key).getElement(d));
        }
        return converter.apply(defaultMap.get(key));
    }

    void registerAll() {
        this.readRootConfig();
        this.registerCategory(this.registry, "misc", CommonIO::readStringList);
        this.registerCategory(this.registry, "features", CommonIO::readStringList);
        this.registerCategory(this.registry, "vegetation", CommonIO::readStringList);
        this.registerCategory(this.compoundRegistry, "blocks", CommonIO::readCompoundList);
        this.extractBlocks();
        this.registerCategory(this.compoundRegistry, "extra", CommonIO::readCompoundList);
        this.extractMobs();
        this.registerHardcoded();
    }

    void readRootConfig() {
        class_2487 rootConfig = CommonIO.read(InfinityMod.configPath.resolve("infinity.json"));
        this.portalKey = rootConfig.method_10558("portalKey");
        this.salt = rootConfig.method_10558("salt");
        class_2487 gamerules = rootConfig.method_10562("gameRules");
        for (Object s : gamerules.method_10541()) {
            class_2520 elem = gamerules.method_10580((String)s);
            if (elem == null) continue;
            if (elem.method_10711() == 3) {
                this.gameRulesInt.put((String)s, gamerules.method_10550((String)s));
            }
            if (elem.method_10711() == 6) {
                this.gameRulesDouble.put((String)s, gamerules.method_10574((String)s));
                continue;
            }
            this.gameRules.put((String)s, gamerules.method_10577((String)s));
        }
        class_2487 rootchances = rootConfig.method_10562("rootChances");
        for (String c : rootchances.method_10541()) {
            for (String s : rootchances.method_10562(c).method_10541()) {
                this.rootChances.put(s, rootchances.method_10562(c).method_10574(s));
            }
        }
        class_2499 disableddimensions = rootConfig.method_10554("disabledDimensions", 8);
        for (class_2520 jsonElement : disableddimensions) {
            this.disabledDimensions.add(jsonElement.method_10714());
        }
    }

    void extractBlocks() {
        if (this.compoundRegistry.containsKey("blocks")) {
            WeighedStructure<class_2520> blocksSettings = this.compoundRegistry.get("blocks");
            WeighedStructure<class_2487> allBlocks = new WeighedStructure<class_2487>();
            WeighedStructure<class_2487> blocksFeatures = new WeighedStructure<class_2487>();
            WeighedStructure<class_2487> topBlocks = new WeighedStructure<class_2487>();
            WeighedStructure<class_2487> fullBlocks = new WeighedStructure<class_2487>();
            WeighedStructure<class_2487> fullBlocksWG = new WeighedStructure<class_2487>();
            for (int i = 0; i < blocksSettings.keys.size(); ++i) {
                class_2487 e = (class_2487)blocksSettings.keys.get(i);
                boolean isfull = RandomProvider.popBlockData(e, "full", false);
                boolean islaggy = RandomProvider.popBlockData(e, "laggy", false);
                boolean isfloat = RandomProvider.popBlockData(e, "float", isfull);
                boolean istop = RandomProvider.popBlockData(e, "top", isfull);
                istop = istop || isfloat;
                Double w = blocksSettings.weights.get(i);
                allBlocks.add(e, w);
                if (isfull) {
                    fullBlocks.add(e, w);
                }
                if (istop && !islaggy) {
                    topBlocks.add(e, w);
                }
                if (isfloat) {
                    blocksFeatures.add(e, w);
                }
                if (!isfull || !isfloat || islaggy) continue;
                fullBlocksWG.add(e, w);
            }
            this.compoundRegistry.put("all_blocks", allBlocks);
            this.compoundRegistry.put("blocks_features", blocksFeatures);
            this.compoundRegistry.put("full_blocks", fullBlocks);
            this.compoundRegistry.put("full_blocks_worldgen", fullBlocksWG);
            this.compoundRegistry.put("top_blocks", topBlocks);
            this.compoundRegistry.remove("blocks");
        }
    }

    static boolean popBlockData(class_2487 e, String key, boolean def) {
        boolean res = NbtUtils.test(e, key, def);
        e.method_10551(key);
        return res;
    }

    void extractMobs() {
        if (this.compoundRegistry.containsKey("mobs")) {
            WeighedStructure<class_2520> allmobs = this.compoundRegistry.get("mobs");
            WeighedStructure<String> allMobNames = new WeighedStructure<String>();
            for (int i = 0; i < allmobs.size(); ++i) {
                Object t = allmobs.keys.get(i);
                if (!(t instanceof class_2487)) continue;
                class_2487 mob = (class_2487)t;
                String group = mob.method_10558("Category");
                if (!this.registry.containsKey(group)) {
                    this.registry.put(group, new WeighedStructure());
                }
                this.registry.get(group).add(mob.method_10558("Name"), allmobs.weights.get(i));
                allMobNames.add(mob.method_10558("Name"), allmobs.weights.get(i));
            }
            this.registry.put("mobs", allMobNames);
            this.compoundRegistry.remove("mobs");
        }
    }

    <B> void registerCategory(Map<String, B> reg, String subpath, ListReader<B> reader) {
        Path path = InfinityMod.configPath.resolve("modular");
        try (Stream<Path> files = Files.walk(path.resolve("minecraft").resolve(subpath), new FileVisitOption[0]);){
            files.filter(p -> p.toFile().isFile()).forEach(p -> {
                String fullname = p.toString();
                String name = p.getFileName().toString().replace(".json", "");
                int i = fullname.replace("minecraft_", "%%%").lastIndexOf("minecraft");
                String sub = fullname.substring(i + 10);
                reg.put(name, reader.op(path, sub));
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void registerHardcoded() {
        try (Stream<Path> files = Files.walk(InfinityMod.configPath.resolve("hardcoded"), new FileVisitOption[0]);){
            files.map(Path::toString).filter(s -> s.endsWith(".json")).forEach(fullname -> {
                String name = fullname.substring(fullname.lastIndexOf("/") + 1, fullname.length() - 5);
                if (!(name = name.substring(name.lastIndexOf(92) + 1)).equals("none")) {
                    this.registry.put(name, CommonIO.readStringList(fullname));
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getMobCategories() {
        return this.registry.get((Object)"mob_categories").keys;
    }

    public class_2487 blockToProvider(class_2487 block, Random random) {
        class_2487 res = new class_2487();
        boolean isRotatable = ((class_2248)class_7923.field_41175.method_10223(new class_2960(block.method_10558("Name")))).method_9564().method_28501().contains(class_2741.field_12496);
        res.method_10582("type", isRotatable && this.roll(random, "rotate_blocks") ? "minecraft:rotated_block_provider" : "minecraft:simple_state_provider");
        res.method_10566("state", (class_2520)block);
        return res;
    }

    public class_2487 randomBlockProvider(Random random, String key) {
        return this.blockToProvider(this.randomElement(random, key), random);
    }

    public class_2487 randomPreset(Random random, String key) {
        class_2520 list = this.compoundRegistry.get("color_presets").getRandomElement(random);
        class_2487 res = new class_2487();
        if (list instanceof class_2499) {
            class_2499 lst = (class_2499)list;
            res.method_10582("type", key);
            if (key.equals("noise_provider")) {
                res.method_10569("seed", 0);
                res.method_10549("scale", 4.0);
                res.method_10566("states", (class_2520)lst);
                res.method_10566("noise", (class_2520)CommonIO.read(String.valueOf(InfinityMod.utilPath) + "/noise.json"));
            }
            if (key.equals("weighted_state_provider")) {
                class_2499 entries = new class_2499();
                for (class_2520 block : lst) {
                    class_2487 entry = new class_2487();
                    entry.method_10566("data", block);
                    entry.method_10549("weight", 1.0);
                    entries.add((Object)entry);
                }
                res.method_10566("entries", (class_2520)entries);
            }
        }
        return res;
    }

    public static class_2487 genBounds(int lbound, int bound) {
        class_2487 value = new class_2487();
        value.method_10569("min_inclusive", lbound);
        value.method_10569("max_inclusive", bound);
        return value;
    }

    public void kickGhostsOut(class_5455 s) {
        class_2378 reg = s.method_30530(class_7924.field_41236);
        WeighedStructure<String> biomes = this.registry.get("biomes");
        if (biomes != null) {
            int i = 0;
            while (i < biomes.keys.size()) {
                if (!reg.method_10250(new class_2960((String)biomes.keys.get(i)))) {
                    biomes.kick(i);
                    continue;
                }
                ++i;
            }
            this.registry.put("biomes", biomes);
        }
    }

    static interface ListReader<B> {
        public B op(Path var1, String var2);
    }
}

