/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.util.loading;

import com.mojang.serialization.Codec;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.lerariemann.infinity.dimensions.RandomDimension;
import net.lerariemann.infinity.util.PlatformMethods;
import net.lerariemann.infinity.util.loading.JsonGrabber;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2487;
import net.minecraft.class_2874;
import net.minecraft.class_2922;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3195;
import net.minecraft.class_5284;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_6796;
import net.minecraft.class_6903;
import net.minecraft.class_7059;
import net.minecraft.class_7876;
import net.minecraft.class_7924;

public class DimensionGrabber {
    class_6903.class_7863 registryInfoGetter;
    class_5455 baseRegistryManager;

    public DimensionGrabber(class_5455 brm) {
        this.baseRegistryManager = brm;
        ArrayList entries = new ArrayList();
        this.baseRegistryManager.method_40311().forEach(entry -> {
            PlatformMethods.unfreeze(entry.comp_351());
            entries.add((class_2385)entry.comp_351());
        });
        this.registryInfoGetter = this.getGetter(entries);
    }

    public class_5363 grab_all(RandomDimension d) {
        Path rootdir = Paths.get(d.getStoragePath(), new String[0]);
        this.buildGrabber(class_2975.field_25833, class_7924.field_41239).grabAll(rootdir.resolve("worldgen/configured_feature"));
        this.buildGrabber(class_6796.field_35729, class_7924.field_41245).grabAll(rootdir.resolve("worldgen/placed_feature"), true);
        this.buildGrabber(class_2922.field_25832, class_7924.field_41238).grabAll(rootdir.resolve("worldgen/configured_carver"));
        this.buildGrabber(class_1959.field_25819, class_7924.field_41236).grabAll(rootdir.resolve("worldgen/biome"));
        this.buildGrabber(class_3195.field_37744, class_7924.field_41246).grabAll(rootdir.resolve("worldgen/structure"));
        this.buildGrabber(class_7059.field_37195, class_7924.field_41248).grabAll(rootdir.resolve("worldgen/structure_set"));
        this.buildGrabber(class_5284.field_24780, class_7924.field_41243).grabAll(rootdir.resolve("worldgen/noise_settings"));
        this.buildGrabber(class_2874.field_24757, class_7924.field_41241).grabAll(rootdir.resolve("dimension_type"));
        return this.grab_dimension(rootdir, d.getName());
    }

    public <T> JsonGrabber<T> buildGrabber(Codec<T> codec, class_5321<class_2378<T>> key) {
        return new JsonGrabber<T>(this.registryInfoGetter, codec, (class_2385)this.baseRegistryManager.method_30530(key));
    }

    <T> void grab_one_for_client(Codec<T> codec, class_5321<class_2378<T>> key, class_2960 id, class_2487 optiondata) {
        if (!this.baseRegistryManager.method_30530(key).method_35842(class_5321.method_29179(key, (class_2960)id))) {
            this.buildGrabber(codec, key).grab(id, optiondata, false);
        }
    }

    public void grab_dim_for_client(class_2960 id, class_2487 dimdata) {
        if (!dimdata.method_33133()) {
            this.grab_one_for_client(class_2874.field_24757, class_7924.field_41241, id, dimdata);
        }
    }

    public void grab_biome_for_client(class_2960 id, class_2487 biomedata) {
        this.grab_one_for_client(class_1959.field_25819, class_7924.field_41236, id, biomedata);
    }

    class_5363 grab_dimension(Path rootdir, String i) {
        class_5363 ret = (class_5363)this.buildGrabber(class_5363.field_25411, class_7924.field_41224).grab_with_return(rootdir.toString() + "/dimension", i, false);
        this.close();
        return ret;
    }

    public void grab_for_client(class_2960 id, class_2487 optiondata, List<class_2960> biomeids, List<class_2487> biomes) {
        if (!optiondata.method_33133()) {
            this.grab_dim_for_client(id, optiondata);
        }
        int i = biomes.size();
        for (int j = 0; j < i; ++j) {
            this.grab_biome_for_client(biomeids.get(j), biomes.get(j));
        }
        this.close();
    }

    public void close() {
        this.baseRegistryManager.method_40311().forEach(entry -> entry.comp_351().method_40276());
    }

    public class_6903.class_7863 getGetter(List<class_2385<?>> additionalRegistries) {
        final HashMap map = new HashMap();
        this.baseRegistryManager.method_40311().forEach(entry -> map.put(entry.comp_350(), DimensionGrabber.createInfo((class_2385)entry.comp_351())));
        additionalRegistries.forEach(first -> map.put(first.method_30517(), DimensionGrabber.createInfo(first)));
        return new class_6903.class_7863(){

            public <T> Optional<class_6903.class_7862<T>> method_46623(class_5321<? extends class_2378<? extends T>> registryRef) {
                return Optional.ofNullable((class_6903.class_7862)map.get(registryRef));
            }
        };
    }

    public static <T> class_6903.class_7862<T> createInfo(class_2385<T> registry) {
        return new class_6903.class_7862((class_7876)registry.method_46771(), registry.method_46769(), registry.method_31138());
    }
}

