/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.util.loading;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Stream;
import net.lerariemann.infinity.util.InfinityMethods;
import net.lerariemann.infinity.util.core.CommonIO;
import net.minecraft.class_2385;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6903;
import org.apache.commons.io.FileUtils;

public class JsonGrabber<E> {
    Codec<E> decoder;
    class_2385<E> registry;
    class_6903.class_7863 registryInfoGetter;

    JsonGrabber(class_6903.class_7863 get, Codec<E> dec, class_2385<E> reg) {
        this.decoder = dec;
        this.registry = reg;
        this.registryInfoGetter = get;
    }

    public void grabAll(Path rootdir) {
        this.grabAll(rootdir, false);
    }

    void grabAll(Path rootdir, boolean bl) {
        if (!rootdir.toFile().exists()) {
            return;
        }
        try (Stream<Path> files = Files.walk(rootdir, new FileVisitOption[0]);){
            files.forEach(a -> this.grab((Path)a, bl));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void grab(Path path, boolean bl) {
        String path1 = path.toString();
        if (path1.endsWith(".json")) {
            String fullname = path1.substring(path1.lastIndexOf("/") + 1, path1.length() - 5);
            int i = fullname.lastIndexOf("\\");
            if (i >= 0) {
                fullname = fullname.substring(i + 1);
            }
            class_5321 key = class_5321.method_29179((class_5321)this.registry.method_30517(), (class_2960)InfinityMethods.getId(fullname));
            this.grab(path1, key, bl);
        }
    }

    void grab(class_2960 id, class_2487 compound, boolean bl) {
        this.grab(class_5321.method_29179((class_5321)this.registry.method_30517(), (class_2960)id), JsonParser.parseString((String)CommonIO.compoundToString(compound)), bl);
    }

    void grab(class_5321<E> key, JsonElement jsonElement, boolean bl) {
        class_6903 registryOps = class_6903.method_40414((DynamicOps)JsonOps.INSTANCE, (class_6903.class_7863)this.registryInfoGetter);
        DataResult dataResult = this.decoder.parse((DynamicOps)registryOps, (Object)jsonElement);
        Object object = dataResult.getOrThrow(false, error -> {});
        if (bl || !this.registry.method_35842(key)) {
            this.registry.method_10272(key, object, Lifecycle.stable());
        }
    }

    void grab(String path, class_5321<E> registryKey, boolean bl) {
        String content;
        File file = new File(path);
        try {
            content = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JsonElement jsonElement = JsonParser.parseString((String)content);
        this.grab(registryKey, jsonElement, bl);
    }

    E grab_with_return(String rootdir, String i, boolean register) {
        String content;
        String path = rootdir + "/" + i + ".json";
        class_5321 key = class_5321.method_29179((class_5321)this.registry.method_30517(), (class_2960)InfinityMethods.getId("generated_" + i));
        File file = new File(path);
        try {
            content = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JsonElement jsonElement = JsonParser.parseString((String)content);
        class_6903 registryOps = class_6903.method_40414((DynamicOps)JsonOps.INSTANCE, (class_6903.class_7863)this.registryInfoGetter);
        DataResult dataResult = this.decoder.parse((DynamicOps)registryOps, (Object)jsonElement);
        Object object = dataResult.getOrThrow(false, error -> {});
        if (register) {
            this.registry.method_10272(key, object, Lifecycle.stable());
        }
        return (E)object;
    }
}

