/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.util.loading;

import com.google.common.util.concurrent.AtomicDouble;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.lerariemann.infinity.access.GameRendererAccess;
import net.lerariemann.infinity.iridescence.Iridescence;
import net.lerariemann.infinity.util.InfinityMethods;
import net.lerariemann.infinity.util.core.CommonIO;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_310;
import net.minecraft.class_3283;

@Environment(value=EnvType.CLIENT)
public interface ShaderLoader {
    public static final String FILENAME = "current.json";
    public static final AtomicInteger iridLevel = new AtomicInteger(-1);
    public static final AtomicDouble iridProgress = new AtomicDouble(0.0);

    public static Path shaderDir(class_310 client) {
        return client.method_1479().resolve("infinity/assets/infinity/shaders");
    }

    public static void reloadShaders(class_310 client, boolean bl) {
        ShaderLoader.reloadShaders(client, bl, Iridescence.shouldApplyShader((class_1657)client.field_1724));
    }

    public static void reloadShaders(class_310 client, boolean bl, boolean iridescence) {
        if (client.field_1687 == null) {
            return;
        }
        if (iridescence) {
            ((GameRendererAccess)client.field_1773).infinity$loadPP(InfinityMethods.getId("shaders/post/iridescence.json"));
            return;
        }
        iridLevel.set(-1);
        iridProgress.set(0.0);
        try {
            ShaderLoader.updateWorldShaderFromDisk(client);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (bl && ShaderLoader.shaderDir(client).resolve(FILENAME).toFile().exists()) {
            ((GameRendererAccess)client.field_1773).infinity$loadPP(InfinityMethods.getId("shaders/current.json"));
            return;
        }
        client.field_1773.method_3207();
    }

    public static void updateWorldShaderFromDisk(class_310 client) throws IOException {
        class_3283 m = client.method_1520();
        Path path = client.method_1479().resolve("infinity");
        String name = "file/" + path.getFileName().toString();
        Files.createDirectories(path.resolve("assets/infinity/shaders"), new FileAttribute[0]);
        if (!path.resolve("pack.mcmeta").toFile().exists()) {
            CommonIO.write(ShaderLoader.packMcmeta(), path.toString(), "pack.mcmeta");
        }
        m.method_14445();
        m.method_49427(name);
    }

    public static class_2487 packMcmeta() {
        class_2487 res = new class_2487();
        class_2487 pack = new class_2487();
        pack.method_10569("pack_format", 15);
        pack.method_10582("description", "Shader container");
        res.method_10566("pack", (class_2520)pack);
        return res;
    }
}

