/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.util.teleport;

import java.util.Comparator;
import java.util.Optional;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.block.entity.InfinityPortalBlockEntity;
import net.lerariemann.infinity.registry.var.ModPoi;
import net.lerariemann.infinity.util.InfinityMethods;
import net.lerariemann.infinity.util.teleport.PortalCreator;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2423;
import net.minecraft.class_2424;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2784;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_4153;
import net.minecraft.class_4156;
import net.minecraft.class_4538;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_5459;
import net.minecraft.class_7477;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class InfinityPortal {
    InfinityPortalBlockEntity ipbe;
    class_3218 worldFrom;
    class_2338 posFrom;
    class_2350.class_2351 axisFrom;
    class_5459.class_5460 portalFrom;
    @Nullable
    class_3218 worldTo;
    @Nullable
    class_2338 posTo;
    @Nullable
    class_5459.class_5460 portalTo;
    boolean unableToCreatePortalFlag = false;
    boolean noSyncFlag = false;

    public InfinityPortal(InfinityPortalBlockEntity ipbe, class_3218 worldFrom, class_2338 startingPos) {
        this.ipbe = ipbe;
        this.worldFrom = worldFrom;
        this.portalFrom = InfinityPortal.getRect((class_1937)worldFrom, startingPos);
        this.posFrom = InfinityPortal.lowerCenterPos(this.portalFrom, (class_1937)worldFrom);
        this.axisFrom = (class_2350.class_2351)worldFrom.method_8320(this.posFrom).method_11654((class_2769)class_2741.field_12529);
        this.worldTo = worldFrom.method_8503().method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)ipbe.getDimension()));
        InfinityPortal.tryUpdateOpenStatus(ipbe, worldFrom, startingPos, this.worldTo);
        if (this.portalShouldWork()) {
            class_2338 targetPos = ipbe.getOtherSidePos();
            if (InfinityPortal.isValidDestination(worldFrom, this.worldTo, targetPos)) {
                this.posTo = targetPos;
                this.scanExistingTarget();
            }
            this.scanNewTeleportTarget();
        }
    }

    public static void tryUpdateOpenStatus(InfinityPortalBlockEntity ipbe, class_3218 worldFrom, class_2338 posFrom, MinecraftServer server) {
        class_3218 worldTo = server.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)ipbe.getDimension()));
        InfinityPortal.tryUpdateOpenStatus(ipbe, worldFrom, posFrom, worldTo);
    }

    public static void tryUpdateOpenStatus(InfinityPortalBlockEntity ipbe, class_3218 worldFrom, class_2338 posFrom, class_3218 worldTo) {
        if (!ipbe.isOpen() ^ worldTo == null) {
            PortalCreator.modifyPortalRecursive(worldFrom, posFrom, e -> e.setOpen(!ipbe.isOpen()));
        }
    }

    public static class_5459.class_5460 getRect(class_1937 world, class_2338 pos) {
        class_2680 blockStateFrom = world.method_8320(pos);
        return class_5459.method_30574((class_2338)pos, (class_2350.class_2351)InfinityPortal.getAxisOrDefault(blockStateFrom), (int)21, (class_2350.class_2351)class_2350.class_2351.field_11052, (int)21, posx -> world.method_8320(posx) == blockStateFrom);
    }

    static class_2338 lowerCenterPos(class_5459.class_5460 rect, class_1937 world) {
        return InfinityPortal.lowerCenterPos(rect, (class_2350.class_2351)world.method_8320(rect.field_25936).method_11654((class_2769)class_2741.field_12529));
    }

    static class_2338 lowerCenterPos(class_5459.class_5460 rect, class_2350.class_2351 axis) {
        boolean bl = axis.equals((Object)class_2350.class_2351.field_11048);
        int i = rect.field_25937 / 2;
        return rect.field_25936.method_10069(bl ? i : 0, 0, bl ? 0 : i);
    }

    public class_5454 getTeleportTarget(class_1297 entity) {
        if (this.portalShouldWork() && this.portalTo != null && this.worldTo != null && this.posTo != null) {
            InfinityPortal.createTicket(this.worldTo, this.posTo);
            return class_2424.method_30484((class_3218)this.worldTo, (class_5459.class_5460)this.portalTo, (class_2350.class_2351)this.axisFrom, (class_243)entity.method_30633(this.axisFrom, this.portalFrom), (class_1297)entity, (class_243)entity.method_18798(), (float)entity.method_36454(), (float)entity.method_36455());
        }
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            this.sendErrors(player);
        }
        return InfinityPortal.emptyTarget(entity);
    }

    public boolean portalShouldWork() {
        return InfinityMethods.dimExists(this.worldTo) && this.ipbe.isOpen() && !this.worldTo.method_27983().equals(this.worldFrom.method_27983());
    }

    public void sendErrors(class_3222 player) {
        if (this.worldTo != null) {
            if (this.worldTo.method_27983().equals(this.worldFrom.method_27983())) {
                player.method_43496((class_2561)class_2561.method_43471((String)"error.infinity.portal.matching_ends"));
            } else if (InfinityMethods.isTimebombed(this.worldTo)) {
                player.method_43496((class_2561)class_2561.method_43471((String)"error.infinity.portal.deleted"));
            } else if (this.unableToCreatePortalFlag) {
                player.method_43496((class_2561)class_2561.method_43471((String)"error.infinity.portal.cannot_create"));
            } else {
                InfinityMethods.sendUnexpectedError(player, "portal");
            }
        } else if (!this.ipbe.isOpen()) {
            InfinityMod.provider.getPortalKeyAsItem().ifPresent(item -> player.method_43496((class_2561)class_2561.method_43469((String)"error.infinity.portal.closed", (Object[])new Object[]{((class_5250)item.method_7848()).method_27692(class_124.field_1075)})));
        } else {
            player.method_43496((class_2561)class_2561.method_43471((String)"error.infinity.portal.null"));
        }
    }

    public static void createTicket(class_3218 worldTo, class_2338 posTo) {
        worldTo.method_14178().method_17297(class_3230.field_19280, new class_1923(posTo), 3, (Object)posTo);
    }

    public static class_2350.class_2351 getAxisOrDefault(class_2680 state) {
        if (state.method_28501().contains(class_2741.field_12529)) {
            return (class_2350.class_2351)state.method_11654((class_2769)class_2741.field_12529);
        }
        return class_2350.class_2351.field_11048;
    }

    public static class_5454 emptyTarget(class_1297 entity) {
        return new class_5454(entity.method_19538(), entity.method_18798(), entity.method_36454(), entity.method_36455());
    }

    public static boolean isValidDestination(class_3218 worldFrom, class_3218 worldTo, class_2338 posTo) {
        InfinityPortalBlockEntity ipbeTo;
        if (posTo == null || !InfinityMethods.dimExists(worldTo)) {
            return false;
        }
        class_2586 class_25862 = worldTo.method_8321(posTo);
        return class_25862 instanceof InfinityPortalBlockEntity && (ipbeTo = (InfinityPortalBlockEntity)class_25862).getDimension().toString().equals(worldFrom.method_27983().method_29177().toString());
    }

    private void scanExistingTarget() {
        assert (this.worldTo != null && this.posTo != null);
        class_2680 blockState = this.worldTo.method_8320(this.posTo);
        this.portalTo = class_5459.method_30574((class_2338)this.posTo, (class_2350.class_2351)InfinityPortal.getAxisOrDefault(blockState), (int)21, (class_2350.class_2351)class_2350.class_2351.field_11052, (int)21, posx -> this.worldTo.method_8320(posx) == blockState);
    }

    private void scanNewTeleportTarget() {
        assert (this.worldTo != null);
        this.findOrCreateExitPortal();
        if (this.portalTo == null) {
            return;
        }
        this.posTo = InfinityPortal.lowerCenterPos(this.portalTo, (class_1937)this.worldTo);
        if (!this.noSyncFlag) {
            InfinityPortal.trySyncPortals(this.worldFrom, this.posFrom, this.worldTo, this.posTo);
        }
    }

    private void findOrCreateExitPortal() {
        assert (this.worldTo != null);
        class_2784 wb = this.worldTo.method_8621();
        double d = class_2874.method_31109((class_2874)this.worldFrom.method_8597(), (class_2874)this.worldTo.method_8597());
        class_2338 originOfTesting = wb.method_39538((double)this.posFrom.method_10263() * d, (double)this.posFrom.method_10264(), (double)this.posFrom.method_10260() * d);
        Optional<class_2338> optional = this.findNewExitPortalPosition(wb, originOfTesting);
        if (optional.isPresent()) {
            this.portalTo = InfinityPortal.getRect((class_1937)this.worldTo, optional.get());
        } else {
            class_2350.class_2351 axis = InfinityPortal.getAxisOrDefault(this.worldFrom.method_8320(this.posFrom));
            this.worldTo.method_14173().method_30482(originOfTesting, axis).ifPresentOrElse(rect -> {
                this.portalTo = rect;
            }, () -> {
                this.unableToCreatePortalFlag = true;
            });
        }
    }

    private Optional<class_2338> findNewExitPortalPosition(class_2784 wbTo, class_2338 originOfTesting) {
        assert (this.worldTo != null);
        int radiusOfTesting = 128;
        class_4153 poiStorage = this.worldTo.method_19494();
        poiStorage.method_22439((class_4538)this.worldTo, originOfTesting, radiusOfTesting);
        Optional<class_2338> portal = poiStorage.method_22383(poiType -> poiType.method_40225(ModPoi.NEITHER_PORTAL_KEY), originOfTesting, radiusOfTesting, class_4153.class_4155.field_18489).map(class_4156::method_19141).filter(arg_0 -> ((class_2784)wbTo).method_11952(arg_0)).filter(pos -> InfinityPortal.isValidDestination(this.worldFrom, this.worldTo, pos)).min(Comparator.comparingDouble(posTo -> posTo.method_10262((class_2382)originOfTesting)));
        if (portal.isPresent()) {
            return portal;
        }
        portal = poiStorage.method_22383(poiType -> poiType.method_40225(class_7477.field_39295), originOfTesting, radiusOfTesting, class_4153.class_4155.field_18489).map(class_4156::method_19141).filter(arg_0 -> ((class_2784)wbTo).method_11952(arg_0)).min(Comparator.comparingDouble(posTo -> posTo.method_10262((class_2382)originOfTesting)));
        this.noSyncFlag = portal.isPresent();
        return portal;
    }

    public static void trySyncPortals(class_3218 worldFrom, class_2338 posFrom, class_3218 worldTo, class_2338 posTo) {
        if (worldTo == null || posTo == null || !(worldTo.method_8320(posTo).method_26204() instanceof class_2423)) {
            return;
        }
        PortalCreator.PortalModifierUnion otherSideModifier = new PortalCreator.PortalModifierUnion();
        class_2960 idFrom = worldFrom.method_27983().method_29177();
        class_2586 class_25862 = worldTo.method_8321(posTo);
        if (class_25862 instanceof InfinityPortalBlockEntity) {
            InfinityPortalBlockEntity ipbeTo = (InfinityPortalBlockEntity)class_25862;
            if (!ipbeTo.getDimension().toString().equals(idFrom.toString())) {
                return;
            }
            if (ipbeTo.isConnectedBothSides()) {
                return;
            }
        } else {
            otherSideModifier = PortalCreator.forInitialSetupping(worldTo, posTo, idFrom, true);
        }
        otherSideModifier.addModifier(ipbe1 -> ipbe1.setBlockPos(posFrom));
        PortalCreator.modifyPortalRecursive(worldFrom, posFrom, ipbe -> ipbe.setBlockPos(posTo));
        PortalCreator.modifyPortalRecursive(worldTo, posTo, otherSideModifier);
    }
}

