/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.util.teleport;

import dev.architectury.platform.Platform;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.access.MinecraftServerAccess;
import net.lerariemann.infinity.block.custom.Boopable;
import net.lerariemann.infinity.block.custom.InfinityPortalBlock;
import net.lerariemann.infinity.block.entity.InfinityPortalBlockEntity;
import net.lerariemann.infinity.compat.ComputerCraftCompat;
import net.lerariemann.infinity.compat.CreateCompat;
import net.lerariemann.infinity.dimensions.RandomDimension;
import net.lerariemann.infinity.options.PortalColorApplier;
import net.lerariemann.infinity.registry.core.ModBlocks;
import net.lerariemann.infinity.registry.core.ModItems;
import net.lerariemann.infinity.registry.var.ModCriteria;
import net.lerariemann.infinity.registry.var.ModPayloads;
import net.lerariemann.infinity.registry.var.ModSounds;
import net.lerariemann.infinity.registry.var.ModStats;
import net.lerariemann.infinity.util.BackportMethods;
import net.lerariemann.infinity.util.InfinityMethods;
import net.lerariemann.infinity.util.PlatformMethods;
import net.lerariemann.infinity.util.core.CommonIO;
import net.lerariemann.infinity.util.core.RandomProvider;
import net.lerariemann.infinity.util.loading.DimensionGrabber;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2423;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_5455;
import net.minecraft.class_5459;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public interface PortalCreator {
    public static void tryCreatePortalFromItem(class_1937 world, class_2338 pos, class_1542 entity) {
        if (entity.method_31481()) {
            return;
        }
        class_1799 itemStack = entity.method_6983();
        if (itemStack.method_7909() == ModItems.TRANSFINITE_KEY.get()) {
            class_2960 key_dest = BackportMethods.getDimensionIdentifier(itemStack);
            MinecraftServer server = world.method_8503();
            if (server != null && world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                boolean bl = PortalCreator.modifyOnInitialCollision(Objects.requireNonNullElse(key_dest, class_2960.method_43902((String)"minecraft", (String)"random")), serverWorld, pos);
                if (bl) {
                    entity.method_5650(class_1297.class_5529.field_27002);
                }
            }
        } else if (itemStack.method_7909() == class_1802.field_8360 || itemStack.method_7909() == class_1802.field_8674) {
            class_2487 compound = itemStack.method_7969();
            String content = compound != null ? PortalCreator.parseComponents(compound, itemStack.method_7909()) : "";
            MinecraftServer server = world.method_8503();
            if (server != null) {
                class_2960 id = InfinityMethods.dimTextToId(content);
                if (world instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)world;
                    boolean bl = PortalCreator.modifyOnInitialCollision(id, serverWorld, pos);
                    if (bl) {
                        entity.method_5650(class_1297.class_5529.field_27002);
                    }
                    PortalCreator.recordIdTranslation(world.method_8503(), id, content);
                }
            }
        } else if (Platform.isModLoaded((String)"computercraft")) {
            try {
                String content = ComputerCraftCompat.checkPrintedPage(itemStack);
                MinecraftServer server = world.method_8503();
                if (server != null) {
                    class_2960 id = InfinityMethods.dimTextToId(content);
                    if (world instanceof class_3218) {
                        class_3218 serverWorld = (class_3218)world;
                        boolean bl = PortalCreator.modifyOnInitialCollision(id, serverWorld, pos);
                        if (bl) {
                            entity.method_5650(class_1297.class_5529.field_27002);
                        }
                        PortalCreator.recordIdTranslation(world.method_8503(), id, content);
                    }
                }
            }
            catch (Exception e) {
                InfinityMod.LOGGER.warn("An incompatible version of ComputerCraft is present. Please update it to the latest version");
            }
        }
    }

    public static String parseComponents(class_2487 compound, class_1792 item) {
        class_2499 pages = compound.method_10554("pages", 8);
        if (pages.isEmpty()) {
            return "";
        }
        if (item == class_1802.field_8360) {
            String pagesString = pages.method_10534(0).method_10714();
            return pagesString.substring(pagesString.indexOf(58) + 2, pagesString.length() - 2);
        }
        if (item == class_1802.field_8674) {
            return pages.method_10534(0).method_10714();
        }
        return "";
    }

    public static boolean modifyOnInitialCollision(class_2960 dimName, class_3218 world, class_2338 pos) {
        MinecraftServer server = world.method_8503();
        class_1657 nearestPlayer = world.method_18459((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 5.0, false);
        if (((MinecraftServerAccess)server).infinity$needsInvocation()) {
            PortalCreator.onInvocationNeedDetected(nearestPlayer);
            return false;
        }
        if (dimName.method_12832().equals("random")) {
            dimName = InfinityMethods.getRandomId(world.field_9229);
        }
        boolean dimensionExistsAlready = server.method_29435().contains(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)dimName));
        PortalCreator.modifyPortalRecursive(world, pos, dimName, dimensionExistsAlready);
        if (dimensionExistsAlready) {
            if (nearestPlayer != null) {
                nearestPlayer.method_7342(ModStats.PORTALS_OPENED_STAT, 1);
            }
            PortalCreator.runAfterEffects(world, pos, false, true);
        } else if (InfinityMod.provider.isPortalKeyBlank()) {
            PortalCreator.openWithStatIncrease(nearestPlayer, server, world, pos);
        } else {
            PortalCreator.runAfterEffects(world, pos, false, false);
        }
        return true;
    }

    public static void openWithStatIncrease(class_1657 player, MinecraftServer s, class_3218 world, class_2338 pos) {
        if (((MinecraftServerAccess)s).infinity$needsInvocation()) {
            PortalCreator.onInvocationNeedDetected(player);
            return;
        }
        boolean isDimensionNew = PortalCreator.open(s, world, pos);
        if (player != null) {
            if (isDimensionNew) {
                player.method_7342(ModStats.DIMS_OPENED_STAT, 1);
                ModCriteria.DIMS_OPENED.trigger((class_3222)player);
            }
            player.method_7342(ModStats.PORTALS_OPENED_STAT, 1);
        }
    }

    public static void onInvocationNeedDetected(class_1657 player) {
        if (player != null) {
            player.method_43496((class_2561)class_2561.method_43471((String)"error.infinity.invocation_needed"));
        }
    }

    public static boolean open(MinecraftServer s, class_3218 world, class_2338 pos) {
        class_2586 blockEntity = world.method_8321(pos);
        boolean bl = false;
        if (blockEntity instanceof InfinityPortalBlockEntity) {
            InfinityPortalBlockEntity npbe = (InfinityPortalBlockEntity)blockEntity;
            class_2960 i = npbe.getDimension();
            if (i.method_12836().equals("infinity")) {
                bl = PortalCreator.tryAddInfinityDimension(s, i);
            }
            PortalCreator.modifyPortalRecursive(world, pos, (InfinityPortalBlockEntity be) -> {
                be.setOpen(true);
                be.method_5431();
            });
            PortalCreator.runAfterEffects(world, pos, bl, true);
        }
        return bl;
    }

    public static void modifyPortalRecursive(class_3218 world, class_2338 pos, class_2960 id, boolean open) {
        PortalCreator.modifyPortalRecursive(world, pos, PortalCreator.forInitialSetupping(world, pos, id, open));
    }

    public static void modifyPortalRecursive(class_3218 world, class_2338 pos, Consumer<InfinityPortalBlockEntity> consumer) {
        PortalCreator.modifyPortalRecursive(world, pos, new PortalModifier(consumer));
    }

    public static void modifyPortalRecursive(class_3218 world, class_2338 pos, BiConsumer<class_1937, class_2338> modifier) {
        class_2350.class_2351 axis = (class_2350.class_2351)world.method_8320(pos).method_11654((class_2769)class_2423.field_11310);
        class_5459.class_5460 rect = class_5459.method_30574((class_2338)pos, (class_2350.class_2351)axis, (int)21, (class_2350.class_2351)class_2350.class_2351.field_11052, (int)21, posx -> world.method_8320(posx).method_26204() instanceof class_2423);
        for (int i = 0; i < rect.field_25937; ++i) {
            for (int j = 0; j < rect.field_25938; ++j) {
                class_2338 blockPos = rect.field_25936.method_10086(j).method_30513(axis, i);
                modifier.accept((class_1937)world, blockPos);
            }
        }
    }

    public static Consumer<class_2338> infPortalSetupper(class_3218 world, class_2338 pos) {
        class_2680 originalState = world.method_8320(pos);
        class_2680 state = (class_2680)((class_2680)((class_2248)ModBlocks.PORTAL.get()).method_9564().method_11657((class_2769)class_2423.field_11310, (Comparable)((class_2350.class_2351)originalState.method_11654((class_2769)class_2423.field_11310)))).method_11657((class_2769)InfinityPortalBlock.BOOP, (Comparable)Boolean.valueOf(!Boopable.getBoop(world.method_8320(pos))));
        return p -> world.method_30092(p, state, 3, 1);
    }

    public static PortalModifierUnion forInitialSetupping(class_3218 world, class_2338 pos, class_2960 id, boolean open) {
        PortalColorApplier applier = PortalColorApplier.of(id, world.method_8503());
        PortalModifierUnion union = new PortalModifierUnion().addSetupper(PortalCreator.infPortalSetupper(world, pos)).addModifier(nbpe -> nbpe.setDimension(id)).addModifier(npbe -> npbe.setColor(applier.apply(npbe.method_11016()))).addModifier(npbe -> npbe.setOpen(open)).addModifier(class_2586::method_5431);
        if (InfinityMethods.isCreateLoaded()) {
            union.addModifier(CreateCompat::tryModifyRails);
        }
        return union;
    }

    public static boolean tryAddInfinityDimension(MinecraftServer server, class_2960 id) {
        if (!id.method_12836().equals("infinity")) {
            return false;
        }
        class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)id);
        if (((MinecraftServerAccess)server).infinity$hasToAdd((class_5321<class_1937>)key)) {
            return false;
        }
        class_3218 w = server.method_3847(key);
        if (w != null) {
            return false;
        }
        RandomDimension d = new RandomDimension(id, server);
        if (!RandomProvider.rule("runtimeGenerationEnabled")) {
            return false;
        }
        ((MinecraftServerAccess)server).infinity$addWorld((class_5321<class_1937>)key, new DimensionGrabber((class_5455)server.method_30611()).grab_all(d));
        server.method_3760().method_14571().forEach(a -> PortalCreator.sendNewWorld(a, id, d));
        return true;
    }

    public static void sendNewWorld(class_3222 player, class_2960 id, RandomDimension d) {
        ServerPlayNetworking.send((class_3222)player, (class_2960)ModPayloads.WORLD_ADD, (class_2540)PortalCreator.buildPacket(id, d));
    }

    public static class_2540 buildPacket(class_2960 id, RandomDimension d) {
        class_2540 buf = PlatformMethods.createPacketByteBufs();
        buf.method_10812(id);
        buf.method_10794(d.type != null ? d.type.data : new class_2487());
        buf.writeInt(d.random_biomes.size());
        d.random_biomes.forEach(b -> {
            buf.method_10812(InfinityMethods.getId(b.name));
            buf.method_10794(b.data);
        });
        return buf;
    }

    public static void runAfterEffects(class_3218 world, class_2338 pos, boolean dimensionIsNew, boolean portalWorks) {
        if (!portalWorks) {
            PortalCreator.playSound(world, pos, ModSounds.BACKPORT_VAULT_EVENT);
        } else {
            if (dimensionIsNew) {
                PortalCreator.playSound(world, pos, ModSounds.BACKPORT_VAULT_EVENT);
            }
            PortalCreator.playSound(world, pos, class_3417.field_14703);
        }
    }

    public static void playSound(class_3218 world, class_2338 pos, class_3414 soundEvent) {
        world.method_8396(null, pos, soundEvent, class_3419.field_15245, 1.0f, 1.0f);
    }

    public static boolean convertReturnPortal(class_3218 destination, MinecraftServer server, class_5321<class_1937> registryKey, class_5454 teleportTarget) {
        boolean bl = false;
        if (RandomProvider.rule("returnPortalsEnabled") && registryKey.method_29177().method_12836().equals("infinity")) {
            class_2338 pos = class_2338.method_49638((class_2374)teleportTarget.field_25879);
            for (class_2338 pos2 : new class_2338[]{pos, pos.method_10069(1, 0, 0), pos.method_10069(0, 0, 1), pos.method_10069(-1, 0, 0), pos.method_10069(0, 0, -1)}) {
                if (!destination.method_8320(pos2).method_27852(class_2246.field_10316)) continue;
                bl = true;
                class_2960 dimensionName = registryKey.method_29177();
                PortalCreator.modifyPortalRecursive(destination, pos2, dimensionName, true);
                break;
            }
        }
        return bl;
    }

    public static void recordIdTranslation(MinecraftServer server, class_2960 id, String value) {
        String key;
        String filename;
        value = value.replaceAll("\n", "/n");
        Path dir = server.method_27050(class_5218.field_24186).resolve("infinity");
        class_2487 comp = CommonIO.read(dir.resolve(filename = "translation_tables.json"));
        if (comp.method_10545(key = id.method_12832())) {
            class_2499 l;
            if (comp.method_10573(key, 8)) {
                l = new class_2499();
                l.add((Object)comp.method_10580(key));
            } else {
                l = comp.method_10554(key, 8);
            }
            l.add((Object)class_2519.method_23256((String)value));
            comp.method_10551(key);
            comp.method_10566(key, (class_2520)l);
        } else {
            comp.method_10582(key, value);
        }
        CommonIO.write(comp, dir, filename);
    }

    public record PortalModifierUnion(List<Consumer<class_2338>> setuppers, List<Consumer<InfinityPortalBlockEntity>> modifiers) implements BiConsumer<class_1937, class_2338>
    {
        public PortalModifierUnion() {
            this(new ArrayList<Consumer<class_2338>>(), new ArrayList<Consumer<InfinityPortalBlockEntity>>());
        }

        PortalModifierUnion addSetupper(Consumer<class_2338> setupper) {
            this.setuppers.add(setupper);
            return this;
        }

        public PortalModifierUnion addModifier(Consumer<InfinityPortalBlockEntity> modifier) {
            this.modifiers.add(modifier);
            return this;
        }

        @Override
        public void accept(class_1937 world, class_2338 pos) {
            this.setuppers.forEach(setupper -> setupper.accept(pos));
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof InfinityPortalBlockEntity) {
                InfinityPortalBlockEntity npbe = (InfinityPortalBlockEntity)blockEntity;
                this.modifiers.forEach(modifier -> modifier.accept(npbe));
            }
        }
    }

    public record PortalModifier(Consumer<InfinityPortalBlockEntity> modifier) implements BiConsumer<class_1937, class_2338>
    {
        @Override
        public void accept(class_1937 world, class_2338 pos) {
            class_2586 class_25862 = world.method_8321(pos);
            if (class_25862 instanceof InfinityPortalBlockEntity) {
                InfinityPortalBlockEntity npbe = (InfinityPortalBlockEntity)class_25862;
                this.modifier.accept(npbe);
            }
        }
    }
}

