/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.util.teleport;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashSet;
import java.util.Objects;
import net.lerariemann.infinity.access.MinecraftServerAccess;
import net.lerariemann.infinity.access.ServerPlayerEntityAccess;
import net.lerariemann.infinity.registry.var.ModCommands;
import net.lerariemann.infinity.registry.var.ModStats;
import net.lerariemann.infinity.util.InfinityMethods;
import net.lerariemann.infinity.util.teleport.PortalCreator;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2168;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface WarpLogic {
    public static void requestWarpById(CommandContext<class_2168> context, long value) {
        WarpLogic.requestWarp(((class_2168)context.getSource()).method_44023(), InfinityMethods.getDimId(value), true);
    }

    public static void requestWarpToExisting(CommandContext<class_2168> context, class_2960 value) throws CommandSyntaxException {
        class_3218 w = ((class_2168)context.getSource()).method_9211().method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)value));
        if (w == null) {
            throw ModCommands.MALFORM_IDENTIFIER_EXCEPTION.create((Object)value);
        }
        if (InfinityMethods.isTimebombed(w)) {
            throw ModCommands.TIMEBOMBED_EXCEPRION.create((Object)value);
        }
        WarpLogic.requestWarp(((class_2168)context.getSource()).method_44023(), value, true);
    }

    public static void requestWarpByText(CommandContext<class_2168> context, String value) {
        class_2960 id = InfinityMethods.dimTextToId(value);
        WarpLogic.requestWarp(((class_2168)context.getSource()).method_44023(), id, true);
        PortalCreator.recordIdTranslation(((class_2168)context.getSource()).method_9211(), id, value);
    }

    public static void requestWarp(@Nullable class_3222 player, class_2960 value, boolean increaseStats) {
        if (player == null) {
            return;
        }
        MinecraftServer s = player.method_5682();
        if (s == null) {
            return;
        }
        if (((MinecraftServerAccess)s).infinity$needsInvocation()) {
            PortalCreator.onInvocationNeedDetected((class_1657)player);
            return;
        }
        boolean isThisANewDimension = PortalCreator.tryAddInfinityDimension(s, value);
        if (isThisANewDimension) {
            if (increaseStats) {
                player.method_7342(ModStats.DIMS_OPENED_STAT, 1);
            }
            ((ServerPlayerEntityAccess)player).infinity$setWarpTimer(2L, value);
        } else {
            WarpLogic.performWarp(player, value);
        }
    }

    public static void respawnAlive(@Nullable class_3222 player) {
        if (player == null) {
            return;
        }
        class_2338 targ = player.method_26280();
        class_3218 serverWorld = player.field_13995.method_3847(player.method_26281());
        if (targ == null || serverWorld == null) {
            serverWorld = player.field_13995.method_30002();
            targ = serverWorld.method_43126();
        }
        player.method_48105(serverWorld, (double)targ.method_10263() + 0.5, (double)targ.method_10264(), (double)targ.method_10260() + 0.5, new HashSet(), player.method_36454(), player.method_36455());
    }

    public static void sendToMissingno(class_3222 player) {
        WarpLogic.requestWarp(player, InfinityMethods.getId("missingno"), false);
    }

    public static void performWarp(class_3222 player, class_2960 idForWarp) {
        class_5321 key;
        MinecraftServer s = player.method_51469().method_8503();
        class_3218 w = s.method_3847(key = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)idForWarp));
        if (w == null) {
            InfinityMethods.sendUnexpectedError(player, "warp");
            return;
        }
        double d = class_2874.method_31109((class_2874)player.method_51469().method_8597(), (class_2874)w.method_8597());
        double y = class_3532.method_15350((double)player.method_23318(), (double)w.method_31607(), (double)w.method_31600());
        class_2338 blockPos2 = WarpLogic.getPosForWarp(w.method_8621().method_39538(player.method_23317() * d, y, player.method_23321() * d), w);
        WarpLogic.ensureSafety(w, blockPos2.method_10074(), class_2246.field_10540);
        WarpLogic.ensureSafety(w, blockPos2, class_2246.field_10124);
        WarpLogic.ensureSafety(w, blockPos2.method_10084(), class_2246.field_10124);
        player.method_48105(w, (double)blockPos2.method_10263() + 0.5, (double)blockPos2.method_10264(), (double)blockPos2.method_10260() + 0.5, new HashSet(), player.method_36454(), player.method_36455());
    }

    public static int getKeyColorFromId(class_2960 id) {
        if (id.method_12836().equals("infinity") && id.method_12832().contains("generated_")) {
            return Math.toIntExact(InfinityMethods.getNumericFromId(id) & 0xFFFFFFL);
        }
        return 0;
    }

    public static boolean isSafe(class_2680 state, class_2680 fallback) {
        if (state.method_26215()) {
            return fallback.method_26215();
        }
        class_3610 fluidState = state.method_26227();
        return fluidState.method_39360(class_3612.field_15906) || fluidState.method_15767(class_3486.field_15517);
    }

    public static class_2338 getPosForWarp(@NotNull class_2338 orig, @NotNull class_3218 world) {
        class_2338 iter = orig;
        int counter = 0;
        class_2338 pos = WarpLogic.scanColumn(orig, world, true);
        while (pos == null) {
            iter = iter.method_10069(world.field_9229.method_43048(16) - 8, 0, world.field_9229.method_43048(16) - 8);
            pos = WarpLogic.scanColumn(iter, world, true);
            if (++counter <= 7) continue;
            pos = Objects.requireNonNullElse(WarpLogic.scanColumn(orig, world, false), orig);
            break;
        }
        return pos;
    }

    @Nullable
    public static class_2338 scanColumn(class_2338 orig, class_3218 world, boolean strong) {
        int z;
        int y1;
        int x = orig.method_10263();
        if (WarpLogic.isPosViable(x, y1 = orig.method_10264(), z = orig.method_10260(), (class_1922)world, strong)) {
            return orig;
        }
        int y2 = y1;
        while (y1 > world.method_31607() || y2 < world.method_31600()) {
            if (WarpLogic.isPosViable(x, --y1, z, (class_1922)world, strong)) {
                return new class_2338(x, y1, z);
            }
            if (!WarpLogic.isPosViable(x, ++y2, z, (class_1922)world, strong)) continue;
            return new class_2338(x, y2, z);
        }
        return null;
    }

    public static boolean isPosViable(int x, int y, int z, class_1922 w, boolean strong) {
        return strong ? WarpLogic.isPosViableStrong(new class_2338(x, y, z), w) : WarpLogic.isPosViableWeak(new class_2338(x, y, z), w);
    }

    public static boolean isPosViableWeak(class_2338 pos, class_1922 w) {
        if (w.method_31601(pos.method_10264())) {
            return false;
        }
        boolean bl = w.method_8320(pos.method_10084()).method_26215();
        boolean bl2 = w.method_8320(pos).method_26215();
        boolean bl3 = w.method_8320(pos.method_10074()).method_26215();
        return !bl3 && bl2 && bl;
    }

    public static boolean isPosViableStrong(class_2338 pos, class_1922 w) {
        if (w.method_31601(pos.method_10264())) {
            return false;
        }
        boolean bl = WarpLogic.isSafe(w, pos.method_10084(), true);
        boolean bl2 = WarpLogic.isSafe(w, pos, true);
        boolean bl3 = WarpLogic.isSafe(w, pos.method_10074(), false);
        return bl3 && bl2 && bl;
    }

    public static boolean isSafe(class_1922 world, class_2338 pos, boolean asAir) {
        class_2680 state = world.method_8320(pos);
        if (state.method_26215()) {
            return asAir;
        }
        if (asAir) {
            return false;
        }
        class_3610 fluidState = state.method_26227();
        return fluidState.method_39360(class_3612.field_15906) || fluidState.method_15767(class_3486.field_15517);
    }

    public static void ensureSafety(class_3218 world, class_2338 pos, class_2248 fallback) {
        class_2680 fb = fallback.method_9564();
        if (!WarpLogic.isSafe((class_1922)world, pos, fb.method_26215())) {
            world.method_8501(pos, fb);
        }
    }
}

