/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.util.var;

import java.awt.Color;
import java.util.Map;
import net.minecraft.class_1767;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_6862;
import net.minecraft.class_7923;

public interface ColorLogic {
    public static final Map<String, Integer> chromaticColors = Map.ofEntries(Map.entry("white", 0xFFFFFF), Map.entry("light_gray", 0x8F8F86), Map.entry("gray", 0x262F2F), Map.entry("black", 0), Map.entry("brown", 7025679), Map.entry("red", 0xA30300), Map.entry("orange", 16736768), Map.entry("yellow", 0xFFCC00), Map.entry("lime", 8371968), Map.entry("green", 4348928), Map.entry("cyan", 29308), Map.entry("light_blue", 2211562), Map.entry("blue", 1779090), Map.entry("purple", 6427810), Map.entry("magenta", 11676333), Map.entry("pink", 16746158));
    public static final int defaultChromatic = 9524443;
    public static final String[] vanillaColors = new String[]{"white", "light_gray", "gray", "black", "brown", "red", "orange", "yellow", "lime", "green", "light_blue", "blue", "cyan", "purple", "magenta", "pink"};
    public static final Map<class_6862<class_2248>, String> supportedBlockTypes = Map.ofEntries(Map.entry(class_3481.field_15481, "$_wool"), Map.entry(class_3481.field_15479, "$_carpet"));

    public static int getChromaticColor(class_1767 dye) {
        return chromaticColors.getOrDefault(dye.method_7792(), 0xFFFFFF);
    }

    public static boolean matchesPureHue(int rgb, int pureHue) {
        Color c = new Color(rgb);
        float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        return Math.abs(hsb[0] * 360.0f - (float)pureHue) <= 1.0f && hsb[1] >= 1.0f && hsb[2] >= 1.0f;
    }

    public static class_2248 getBlockByColor(String color, class_6862<class_2248> type) {
        return (class_2248)class_7923.field_41175.method_10223(new class_2960(supportedBlockTypes.get(type).replace("$", color)));
    }

    public static class_2248 getBlockByColor(class_1767 color, class_6862<class_2248> type) {
        return ColorLogic.getBlockByColor(color.method_7792(), type);
    }

    public static class_1767 getColorByState(class_2680 state) {
        for (class_6862<class_2248> key : supportedBlockTypes.keySet()) {
            if (!state.method_26164(key)) continue;
            class_2960 id = class_7923.field_41175.method_10221((Object)state.method_26204());
            return class_1767.method_7793((String)id.method_12832().replace(supportedBlockTypes.get(key).replace("$", ""), ""), null);
        }
        return null;
    }

    public static boolean isSupported(class_2680 state) {
        for (class_6862<class_2248> key : supportedBlockTypes.keySet()) {
            if (!state.method_26164(key)) continue;
            return true;
        }
        return false;
    }

    public static <T extends Comparable<T>> class_2680 applyPropertyFrom(class_2680 newState, class_2680 oldState, class_2769<T> property) {
        return (class_2680)newState.method_47968(property, oldState.method_11654(property));
    }

    public static class_2680 recolor(String color, class_2680 state) {
        for (class_6862<class_2248> key : supportedBlockTypes.keySet()) {
            if (!state.method_26164(key)) continue;
            class_2680 newState = ColorLogic.getBlockByColor(color, key).method_9564();
            for (class_2769 property : state.method_28501()) {
                newState = ColorLogic.applyPropertyFrom(newState, state, property);
            }
            return newState;
        }
        return null;
    }
}

