package me.basiqueevangelist.dynreg.mixin;

import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectList;
import me.basiqueevangelist.dynreg.access.ExtendedRegistry;
import me.basiqueevangelist.dynreg.event.RegistryEntryDeletedCallback;
import me.basiqueevangelist.dynreg.event.RegistryFrozenCallback;
import me.basiqueevangelist.dynreg.util.StackTracingMap;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.fabricmc.fabric.api.event.registry.RegistryEntryRemovedCallback;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Mixin(value = class_2370.class)
public abstract class SimpleRegistryMixin<T> implements ExtendedRegistry<T>, class_2378<T> {
    @Shadow private boolean frozen;
    @Shadow
    @Nullable
    private Map<T, class_6880.class_6883<T>> intrusiveValueToEntry;

    @Shadow
    public abstract Optional<class_6880.class_6883<T>> method_40264(class_5321<T> key);

    @Shadow
    @Final
    private Object2IntMap<T> entryToRawId;
    @Shadow
    @Final
    private ObjectList<class_6880.class_6883<T>> rawIdToEntry;
    @Mutable
    @Shadow
    @Final
    private Map<class_2960, class_6880.class_6883<T>> idToEntry;
    @Shadow
    @Final
    private Map<class_5321<T>, class_6880.class_6883<T>> keyToEntry;
    @Shadow
    @Final
    private Map<T, class_6880.class_6883<T>> valueToEntry;
    @Shadow
    @Final
    private Map<T, Lifecycle> entryToLifecycle;
    @Shadow
    @Nullable
    private List<class_6880.class_6883<T>> cachedEntries;
    @Shadow private int nextId;

    @Unique
    @SuppressWarnings("unchecked") private final Event<RegistryEntryDeletedCallback<T>> dynreg$entryDeletedEvent = EventFactory.createArrayBacked(RegistryEntryDeletedCallback.class, callbacks -> (rawId, entry) -> {
        for (var callback : callbacks) {
            callback.onEntryDeleted(rawId, entry);
        }

        if (entry.comp_349() instanceof RegistryEntryDeletedCallback<?> callback)
            ((RegistryEntryDeletedCallback<T>) callback).onEntryDeleted(rawId, entry);
    });
    @Unique
    private final Event<RegistryFrozenCallback<T>> dynreg$registryFrozenEvent = EventFactory.createArrayBacked(RegistryFrozenCallback.class, callbacks -> () -> {
        for (var callback : callbacks) {
            callback.onRegistryFrozen();
        }
    });
    @Unique
    private final IntList dynreg$freeIds = new IntArrayList();
    @Unique
    private boolean dynreg$intrusive;

    @Override
    public Event<RegistryEntryDeletedCallback<T>> dynreg$getEntryDeletedEvent() {
        return dynreg$entryDeletedEvent;
    }

    @Override
    public Event<RegistryFrozenCallback<T>> dynreg$getRegistryFrozenEvent() {
        return dynreg$registryFrozenEvent;
    }

    @Inject(method = "<init>(Lnet/minecraft/registry/RegistryKey;Lcom/mojang/serialization/Lifecycle;Z)V", at = @At("TAIL"))
    private void saveIntrusiveness(class_5321<?> key, Lifecycle lifecycle, boolean intrusive, CallbackInfo ci) {
        dynreg$intrusive = intrusive;
    }

    @Override
    public void dynreg$remove(class_5321<T> key) {
        if (frozen) {
            throw new IllegalStateException("Registry is frozen (trying to remove key " + key + ")");
        }

        class_6880.class_6883<T> entry = method_40264(key).orElseThrow();

        int rawId = entryToRawId.getInt(entry.comp_349());
        dynreg$entryDeletedEvent.invoker().onEntryDeleted(rawId, entry);
        RegistryEntryRemovedCallback.event(this).invoker().onEntryRemoved(rawId, entry.method_40237().method_29177(), entry.comp_349());

        rawIdToEntry.set(rawId, null);
        entryToRawId.removeInt(entry.comp_349());
        idToEntry.remove(key.method_29177());
        keyToEntry.remove(key);
        valueToEntry.remove(entry.comp_349());
        entryToLifecycle.remove(entry.comp_349());
        dynreg$freeIds.add(rawId);

        cachedEntries = null;
    }

    @Redirect(method = "add", at = @At(value = "FIELD", target = "Lnet/minecraft/registry/SimpleRegistry;nextId:I"))
    private int getNextId(class_2370<T> instance) {
        if (!dynreg$freeIds.isEmpty())
            return dynreg$freeIds.removeInt(0);

        return nextId;
    }

    @Override
    public void dynreg$unfreeze() {
        frozen = false;
        if (dynreg$intrusive)
            this.intrusiveValueToEntry = new IdentityHashMap<>();

        cachedEntries = null;
    }

    @Inject(method = "freeze", at = @At("HEAD"))
    private void onFreeze(CallbackInfoReturnable<class_2378<T>> cir) {
        dynreg$registryFrozenEvent.invoker().onRegistryFrozen();
    }

    @Override
    public void dynreg$installStackTracingMap() {
        this.idToEntry = new StackTracingMap<>(this.idToEntry);
    }
}
