package net.lerariemann.infinity.fluids.fabric;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRenderHandler;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributeHandler;
import net.lerariemann.infinity.registry.core.ModBlocks;
import net.lerariemann.infinity.iridescence.Iridescence;
import net.lerariemann.infinity.registry.core.ModItems;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1792;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2404;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4538;
import net.minecraft.class_5250;
import net.minecraft.class_7924;
import net.minecraft.world.*;
import org.jetbrains.annotations.Nullable;

import java.util.function.Function;

import static net.lerariemann.infinity.InfinityMod.MOD_ID;

public class ModFluidsFabric {
    public static final DeferredRegister<class_3611> FLUIDS = DeferredRegister.create(MOD_ID, class_7924.field_41270);
    public static final RegistrySupplier<IridescenceFlowing> IRIDESCENCE_FLOWING =
            FLUIDS.register("flowing_iridescence", IridescenceFlowing::new);
    public static final RegistrySupplier<IridescenceStill> IRIDESCENCE_STILL =
            FLUIDS.register("iridescence", IridescenceStill::new);

    public static void registerModFluids() {
        FLUIDS.register();
    }

    public static abstract class IridescenceFabric extends class_3609 {
        @Override
        public class_3611 method_15750() {
            return ModFluidsFabric.IRIDESCENCE_FLOWING.get();
        }
        @Override
        public class_3611 method_15751() {
            return ModFluidsFabric.IRIDESCENCE_STILL.get();
        }
        @Override
        public class_1792 method_15774() {
            return ModItems.IRIDESCENCE_BUCKET.get();
        }

        @Override
        protected class_2680 method_15790(class_3610 state) {
            return ModBlocks.IRIDESCENCE.get().method_9564().method_11657(class_2404.field_11278, method_15741(state));
        }
        @Override
        protected boolean method_15737(class_1937 world) {
            return Iridescence.isInfinite(world);
        }
        @Override
        protected void method_15730(class_1936 world, class_2338 pos, class_2680 state) {
            class_2586 blockEntity = state.method_31709() ? world.method_8321(pos) : null;
            class_2248.method_9610(state, world, pos, blockEntity);
        }
        @Override
        protected int method_15733(class_4538 world) {
            return 4;
        }
        @Override
        protected int method_15739(class_4538 world) {
            return 1;
        }
        @Override
        protected boolean method_15777(class_3610 state, class_1922 world, class_2338 pos, class_3611 fluid, class_2350 direction) {
            return direction == class_2350.field_11033 && !this.method_15780(fluid);
        }
        @Override
        public int method_15789(class_4538 world) {
            return 5;
        }
        @Override
        protected float method_15784() {
            return 100.0F;
        }
        @Override
        public boolean method_15780(class_3611 fluid) {
            return fluid == method_15751() || fluid == method_15750();
        }
    }
    public static class IridescenceStill extends IridescenceFabric {
        @Override
        public boolean method_15793(class_3610 state) {
            return true;
        }
        @Override
        public int method_15779(class_3610 state) {
            return 8;
        }
    }
    public static class IridescenceFlowing extends IridescenceFabric {
        public IridescenceFlowing() {
            super();
            this.method_15781(this.method_15783().method_11664().method_11657(field_15900, 7));
        }
        @Override
        protected void method_15775(class_2689.class_2690<class_3611, class_3610> builder) {
            super.method_15775(builder);
            builder.method_11667(field_15900);
        }
        @Override
        public int method_15779(class_3610 state) {
            return state.method_11654(field_15900);
        }
        @Override
        public boolean method_15793(class_3610 state) {
            return false;
        }
    }

    public static class IridescenceVariantAttributeHandler implements FluidVariantAttributeHandler {
        @Override
        public class_2561 getName(FluidVariant fluidVariant) {
            class_5250 txt = class_2561.method_43471("block.infinity.iridescence");
            txt = txt.method_10862(txt.method_10866().method_36139(Iridescence.getTimeBasedColor()));
            return txt;
        }
    }
    public static class IridescenceVariantRenderHandler implements FluidVariantRenderHandler {
        @Override
        public int getColor(FluidVariant fluidVariant, @Nullable class_1920 view, @Nullable class_2338 pos) {
            return (view != null && pos != null) ? Iridescence.getPosBasedColor(pos) : Iridescence.getTimeBasedColor();
        }
    }
    public static class IridescenceRenderHandler implements FluidRenderHandler {
        @Override
        public class_1058[] getFluidSprites(@Nullable class_1920 view, @Nullable class_2338 pos, class_3610 state) {
            Function<class_2960, class_1058> atlas = class_310.method_1551().method_1549(class_1059.field_5275);
            class_1058 overlaySprite = atlas.apply(Iridescence.OVERLAY_TEXTURE);
            class_1058[] sprites = new class_1058[overlaySprite == null ? 2 : 3];
            sprites[0] = atlas.apply(Iridescence.TEXTURE);
            sprites[1] = atlas.apply(Iridescence.FLOWING_TEXTURE);
            if (overlaySprite != null) sprites[2] = overlaySprite;
            return sprites;
        }

        @Override
        public int getFluidColor(@Nullable class_1920 view, @Nullable class_2338 pos, class_3610 state) {
            return (view != null && pos != null) ? Iridescence.getPosBasedColor(pos) : Iridescence.getTimeBasedColor();
        }
    }
}
