package net.lerariemann.infinity.mixin.fabric.mavity;

import net.lerariemann.infinity.access.MavityInterface;
import net.lerariemann.infinity.options.InfinityOptions;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_3483;
import net.minecraft.class_3532;
import net.minecraft.class_8149;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.*;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1309.class)
public abstract class LivingEntityMixin extends class_1297 implements class_8149, MavityInterface {
    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @ModifyConstant(method = "travel", constant = @Constant(doubleValue = 0.01))
    double inj3(double value) {
        return value*getMavity();
    }

    @Inject(method = "computeFallDamage", at = @At(value = "HEAD"), cancellable = true)
    protected void inj2(float fallDistance, float damageMultiplier, CallbackInfoReturnable<Integer> cir) {
        InfinityOptions options = InfinityOptions.access(method_37908());
        if (!options.isEmpty()) {
            if (this.method_5864().method_20210(class_3483.field_42971)) cir.setReturnValue(0);
            else {
                double f = 3.0F;
                double clampedMavity = class_3532.method_15350(options.getMavity(), 0.01, 2);
                double g = fallDistance * clampedMavity - f;
                cir.setReturnValue(class_3532.method_15384(
                        (g * damageMultiplier) * 1.0F));
            }
        }
    }
}
