package net.lerariemann.infinity.util.fabric;

import dev.architectury.registry.registries.RegistrySupplier;
import me.basiqueevangelist.dynreg.util.RegistryUtils;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.item.StarOfLangItem;
import net.lerariemann.infinity.util.InfinityMethods;
import net.lerariemann.infinity.util.PlatformMethods;
import net.lerariemann.infinity.registry.core.ModBlocks;
import net.lerariemann.infinity.fluids.fabric.ModFluidsFabric;
import net.lerariemann.infinity.iridescence.IridescenceLiquidBlock;
import net.minecraft.block.*;
import net.minecraft.class_1297;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2404;
import net.minecraft.class_2540;
import net.minecraft.class_3218;
import net.minecraft.class_3609;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import java.nio.file.Path;
import java.util.function.Function;

/**
 * See {@link PlatformMethods} for usages.
 */
@SuppressWarnings("unused")
public class PlatformMethodsImpl {

    public static class_2540 createPacketByteBufs() {
        return PacketByteBufs.create();
    }

    public static void onWorldLoad(Object mixin, class_3218 world) {
        ServerWorldEvents.LOAD.invoker().onWorldLoad((MinecraftServer) mixin, world);
    }

    public static void unfreeze(class_2378<?> registry) {
        RegistryUtils.unfreeze(registry);
    }

    public static <T extends class_1792> void addAfter(RegistrySupplier<T> supplier, class_5321<class_1761> group, class_1792 item) {
        if (InfinityMethods.isFabricApiLoaded("fabric-item-group-api-v1")) {
            ItemGroupEvents.modifyEntriesEvent(group).register(content -> content.addAfter(item, supplier.get()));
        }
    }

    public static RegistrySupplier<? extends class_3609> getIridescenceStill() {
        return ModFluidsFabric.IRIDESCENCE_STILL;
    }

    public static RegistrySupplier<? extends class_3609> getIridescenceFlowing() {
        return ModFluidsFabric.IRIDESCENCE_FLOWING;
    }

    public static RegistrySupplier<class_2404> getIridBlockForReg() {
        return ModBlocks.BLOCKS.register("iridescence", () ->
                new IridescenceLiquidBlock(PlatformMethods.getIridescenceStill(),
                        class_4970.class_2251.method_9630(class_2246.field_10382).method_31710(class_3620.field_15998)));
    }

    public static Path getRootConfigPath() {
        ModContainer mc = FabricLoader.getInstance().getModContainer(InfinityMod.MOD_ID).orElse(null);
        assert mc != null;
        return mc.getRootPaths().get(0).resolve("config");
    }

    public static Path getConfigPath() {
        return Path.of(FabricLoader.getInstance().getConfigDir() + "/infinity");
    }

    public static class_6862<class_1792> createItemTag(String id) {
        return class_6862.method_40092(class_7924.field_41197, InfinityMethods.getId(id));
    }
    public static class_6862<class_2248> createBlockTag(String id) {
        return class_6862.method_40092(class_7924.field_41254, InfinityMethods.getId(id));
    }

    public static void registerFlammableBlock(RegistrySupplier<class_2248> block, int burn, int spread) {
        FlammableBlockRegistry.getDefaultInstance().add(block.get(), burn, spread);
    }

    public static boolean acidTest(class_1297 entity, boolean eyes) {
        return false;
    }
    public static double acidHeightTest(class_1297 entity) {
        return -1;
    }

    public static Function<class_1792.class_1793, ? extends StarOfLangItem> getStarOfLangConstructor() {
        return StarOfLangItem::new;
    }
}
