package net.lerariemann.infinity.forge;

import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;

@Mixin(Entity.class)
public class EntityMixin {
    @Shadow
    private Level world;

    @Redirect(method = "tickPortal",
    at = @At(value = "INVOKE", target = "Lnet/minecraft/world/World;getRegistryKey()Lnet/minecraft/registry/RegistryKey;"),
            slice = @Slice(from = @At(
                    value = "INVOKE", target = "Lnet/minecraft/entity/Entity;getWorld()Lnet/minecraft/world/World;"
            ), to = @At("TAIL")))
    ResourceKey<Level> smuggle(Level w) {
       if (w == this.world) return Level.f_46429_;
       return w.m_46472_();
    }
}