package net.lerariemann.infinity.util.forge;

import dev.architectury.registry.registries.RegistrySupplier;
import io.netty.buffer.Unpooled;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.lerariemann.infinity.item.forge.StarOfLangItemForge;
import net.lerariemann.infinity.fluids.forge.FluidTypes;
import net.lerariemann.infinity.item.StarOfLangItem;
import net.lerariemann.infinity.util.PlatformMethods;
import net.lerariemann.infinity.registry.core.ModBlocks;
import net.lerariemann.infinity.fluids.forge.IridescenceLiquidBlockForge;
import net.lerariemann.infinity.fluids.forge.ModFluidsForge;
import net.lerariemann.infinity.util.InfinityMethods;
import net.minecraft.block.*;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;

import java.nio.file.Path;
import java.util.function.Function;

/**
 * See {@link PlatformMethods} for usages.
 */
@SuppressWarnings("unused")
public class PlatformMethodsImpl {

    public static FriendlyByteBuf createPacketByteBufs() {
        return new FriendlyByteBuf(Unpooled.buffer());
    }

    public static void onWorldLoad(Object mixin, ServerLevel world) {
        MinecraftServer server = world.m_7654_();
        server.forgeGetWorldMap().put(world.m_46472_(),world);
        server.markWorldsDirty();
        MinecraftForge.EVENT_BUS.post(new LevelEvent.Load(world));
    }

    public static void unfreeze(Registry<?> registry) {
        MappedRegistry<?> writableRegistry = (MappedRegistry<?>) registry;
        writableRegistry.unfreeze();
    }

    public static void freeze(Registry<?> registry) {
        registry.m_203521_();
    }

    //Optional, requires Item Group API.
    public static <T extends Item> void addAfter(RegistrySupplier<T> supplier, ResourceKey<CreativeModeTab> group, Item item) {
        if (InfinityMethods.isFabricApiLoaded("fabric-item-group-api-v1")) {
            ItemGroupEvents.modifyEntriesEvent(group).register(content -> content.addAfter(item, supplier.get()));
        }
    }

    public static RegistrySupplier<ForgeFlowingFluid.Source> getIridescenceStill() {
        return ModFluidsForge.IRIDESCENCE_STILL;
    }

    public static RegistrySupplier<ForgeFlowingFluid.Flowing> getIridescenceFlowing() {
        return ModFluidsForge.IRIDESCENCE_FLOWING;
    }

    public static RegistrySupplier<LiquidBlock> getIridBlockForReg() {
        return ModBlocks.BLOCKS.register("iridescence", () ->
                new IridescenceLiquidBlockForge(PlatformMethods.getIridescenceStill(), BlockBehaviour.Properties.m_60926_(Blocks.f_49990_)
                                .m_284180_(MapColor.f_283931_)));
    }

    public static Path getRootConfigPath() {
        return ModLoadingContext.get().getActiveContainer().getModInfo().getOwningFile().getFile().findResource("config");
    }

    public static Path getConfigPath() {
        return Path.of(FMLPaths.CONFIGDIR.get() + "/infinity");
    }

    public static TagKey<Item> createItemTag(String id) {
        return ItemTags.create(InfinityMethods.getId(id));
    }
    public static TagKey<Block> createBlockTag(String id) {
        return BlockTags.create(InfinityMethods.getId(id));
    }

    public static void registerFlammableBlock(RegistrySupplier<Block> block, int burn, int spread) {
        if (InfinityMethods.isFabricApiLoaded("fabric-content-registries-v0")) {
            FlammableBlockRegistry.getDefaultInstance().add(block.get(), burn, spread);
        }
    }

    public static boolean acidTest(Entity entity, boolean eyes) {
        if (entity instanceof Player) return false;
        if (eyes) return entity.isEyeInFluidType(ModFluidsForge.IRIDESCENCE_TYPE.get());
        return entity.isInFluidType(ModFluidsForge.IRIDESCENCE_TYPE.get());
    }

    public static double acidHeightTest(Entity entity) {
        if (entity instanceof Player) return -1;
        return entity.getFluidTypeHeight(ModFluidsForge.IRIDESCENCE_TYPE.get());
    }

    public static Function<Item.Properties, ? extends StarOfLangItem> getStarOfLangConstructor() {
        return StarOfLangItemForge::new;
    }
}
