/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.block.custom;

import net.lerariemann.infinity.block.entity.BiomeBottleBlockEntity;
import net.lerariemann.infinity.registry.core.ModBlocks;
import net.lerariemann.infinity.registry.var.ModCriteria;
import net.lerariemann.infinity.util.var.BishopBattle;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AltarBlock
extends Block {
    public static final int numColors = 13;
    public static final BooleanProperty FLOWER = BooleanProperty.m_61465_((String)"flower");
    public static final IntegerProperty COLOR = IntegerProperty.m_61631_((String)"color", (int)0, (int)12);
    public static final VoxelShape BASE_SHAPE = Block.m_49796_((double)1.5, (double)0.0, (double)1.5, (double)14.5, (double)14.0, (double)14.5);
    public static final VoxelShape TOP_SHAPE = Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape LEG1 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)3.0);
    public static final VoxelShape LEG2 = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)3.0, (double)16.0);
    public static final VoxelShape LEG3 = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)3.0);
    public static final VoxelShape LEG4 = Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0, (double)16.0);
    public static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)BASE_SHAPE, (VoxelShape[])new VoxelShape[]{TOP_SHAPE, LEG1, LEG2, LEG3, LEG4});

    public AltarBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)COLOR, (Comparable)Integer.valueOf(0))).m_61124_((Property)FLOWER, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{COLOR});
        builder.m_61104_(new Property[]{FLOWER});
    }

    public static void setColor(Level world, BlockPos pos, BlockState state, int i) {
        world.m_46597_(pos, (BlockState)state.m_61124_((Property)COLOR, (Comparable)Integer.valueOf(i)));
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        ItemStack res = super.m_7397_(world, pos, state);
        return res;
    }

    public void testRituals(ServerLevel world, BlockPos pos, ServerPlayer player) {
        BlockEntity blockEntity = world.m_7702_(pos.m_7494_());
        if (blockEntity instanceof BiomeBottleBlockEntity) {
            BiomeBottleBlockEntity bbbe = (BiomeBottleBlockEntity)blockEntity;
            ModCriteria.BIOME_BOTTLE.trigger(player, bbbe);
            bbbe.startTicking();
        }
        if (world.m_8055_(pos.m_7494_()).m_60713_((Block)ModBlocks.ANT.get())) {
            world.m_7471_(pos.m_7494_(), false);
            new BishopBattle(world).start(pos.m_7494_());
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            if (itemStack.m_41619_()) {
                this.testRituals(serverWorld, pos, (ServerPlayer)player);
            }
        }
        if (itemStack.m_41720_() instanceof DyeItem) {
            int i = AltarBlock.getColor(itemStack, state);
            if (i >= 0 && (Integer)state.m_61143_((Property)COLOR) != i) {
                AltarBlock.setColor(world, pos, state, i);
                world.m_5594_(null, pos, SoundEvents.f_144133_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        if (itemStack.m_150930_(Items.f_42206_)) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)FLOWER, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)FLOWER) == false)));
            world.m_5594_(null, pos, SoundEvents.f_144057_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public static int getColor(ItemStack itemStack, BlockState oldState) {
        int i = -1;
        if (itemStack.m_150930_(Items.f_42497_)) {
            i = 1;
        }
        if (itemStack.m_150930_(Items.f_42536_)) {
            i = 2;
        }
        if (itemStack.m_150930_(Items.f_42539_)) {
            i = 3;
        }
        if (itemStack.m_150930_(Items.f_42540_)) {
            int n = i = (Integer)oldState.m_61143_((Property)COLOR) == 6 ? 5 : 4;
        }
        if (itemStack.m_150930_(Items.f_42496_)) {
            int n = i = (Integer)oldState.m_61143_((Property)COLOR) == 4 ? 5 : 6;
        }
        if (itemStack.m_150930_(Items.f_42538_)) {
            i = 7;
        }
        if (itemStack.m_150930_(Items.f_42492_)) {
            i = 8;
        }
        if (itemStack.m_150930_(Items.f_42494_)) {
            i = 9;
        }
        if (itemStack.m_150930_(Items.f_42493_)) {
            i = 10;
        }
        if (itemStack.m_150930_(Items.f_42537_)) {
            i = 11;
        }
        if (itemStack.m_150930_(Items.f_42489_)) {
            i = 12;
        }
        if (itemStack.m_150930_(Items.f_42490_)) {
            i = 0;
        }
        return i;
    }
}

