/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class AntBlock
extends HorizontalDirectionalBlock {
    public AntBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
    }

    private static boolean inverseExists(Block down) {
        ResourceLocation id = BuiltInRegistries.f_256975_.m_7981_((Object)down);
        String n = id.m_135827_();
        String s = id.m_135815_();
        if (s.contains("black_")) {
            return BuiltInRegistries.f_256975_.m_7804_(ResourceLocation.m_214293_((String)n, (String)s.replace("black", "white")));
        }
        if (s.contains("white_")) {
            return BuiltInRegistries.f_256975_.m_7804_(ResourceLocation.m_214293_((String)n, (String)s.replace("white", "black")));
        }
        return false;
    }

    public static boolean isSafeToRecolor(Level world, BlockPos pos) {
        return AntBlock.inverseExists(world.m_8055_(pos).m_60734_()) && world.m_7702_(pos) == null;
    }

    public static Block recolor(Block down, boolean toWhite) {
        ResourceLocation id = BuiltInRegistries.f_256975_.m_7981_((Object)down);
        String n = id.m_135827_();
        String s = id.m_135815_();
        if (s.contains("black_")) {
            return toWhite ? (Block)BuiltInRegistries.f_256975_.m_7745_(ResourceLocation.m_214293_((String)n, (String)s.replace("black", "white"))) : down;
        }
        if (s.contains("white_")) {
            return toWhite ? down : (Block)BuiltInRegistries.f_256975_.m_7745_(ResourceLocation.m_214293_((String)n, (String)s.replace("white", "black")));
        }
        return null;
    }

    @Nullable
    public static Clockwiseness getCW(Block down) {
        String s = down.toString();
        if (s.contains("black")) {
            return Clockwiseness.CCW;
        }
        if (s.contains("white")) {
            return Clockwiseness.CW;
        }
        return null;
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        super.m_213897_(state, world, pos, random);
        if (AntBlock.isSafeToRecolor((Level)world, pos.m_7495_())) {
            this.safeMove(state, (Level)world, pos);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return this.move(state, world, pos);
    }

    private InteractionResult move(BlockState blockState, Level world, BlockPos pos) {
        if (AntBlock.isSafeToRecolor(world, pos.m_7495_())) {
            return this.safeMove(blockState, world, pos);
        }
        return InteractionResult.FAIL;
    }

    private InteractionResult safeMove(BlockState blockState, Level world, BlockPos pos) {
        BlockState down = world.m_8055_(pos.m_7495_());
        Clockwiseness clockwiseness = AntBlock.getCW(down.m_60734_());
        if (clockwiseness == null) {
            return InteractionResult.FAIL;
        }
        Direction direction = (Direction)blockState.m_61143_((Property)f_54117_);
        Direction direction2 = clockwiseness == Clockwiseness.CW ? direction.m_122427_() : direction.m_122428_();
        BlockPos blockPos = pos.m_121945_(direction2);
        if (world.m_46749_(blockPos) && world.m_8055_(blockPos).m_247087_()) {
            switch (clockwiseness.ordinal()) {
                case 0: {
                    world.m_7731_(pos.m_7495_(), AntBlock.recolor(down.m_60734_(), false).m_152465_(down), 19);
                    world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                    world.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)f_54117_, (Comparable)direction2), 3);
                    break;
                }
                case 1: {
                    world.m_7731_(pos.m_7495_(), AntBlock.recolor(down.m_60734_(), true).m_152465_(down), 19);
                    world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                    world.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)f_54117_, (Comparable)direction2), 3);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_().m_122424_());
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        world.m_186460_(pos, (Block)this, 1);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
    }

    public static enum Clockwiseness {
        CW,
        CCW;

    }
}

